/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.name;

import io.brackit.query.atomic.QNm;
import io.sirix.index.Filter;
import io.sirix.index.redblacktree.RBNodeKey;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public final class NameFilter
implements Filter {
    private final Set<QNm> includes;
    private final Set<QNm> excludes;

    public NameFilter(Set<QNm> included, Set<QNm> excluded) {
        this.includes = Objects.requireNonNull(included);
        this.excludes = Objects.requireNonNull(excluded);
    }

    public Set<QNm> getIncludes() {
        return Collections.unmodifiableSet(this.includes);
    }

    public Set<QNm> getExcludes() {
        return Collections.unmodifiableSet(this.excludes);
    }

    @Override
    public <K extends Comparable<? super K>> boolean filter(RBNodeKey<K> node) {
        K k = node.getKey();
        if (!(k instanceof QNm)) {
            throw new IllegalStateException("Key is not of type QNm!");
        }
        QNm name = (QNm)k;
        boolean included = this.includes.isEmpty() || this.includes.contains(name);
        boolean excluded = !this.excludes.isEmpty() && this.excludes.contains(name);
        return included && !excluded;
    }
}

