/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.name;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.index.ChangeListener;
import io.sirix.index.Filter;
import io.sirix.index.IndexDef;
import io.sirix.index.IndexFilterAxis;
import io.sirix.index.SearchMode;
import io.sirix.index.name.NameFilter;
import io.sirix.index.redblacktree.RBTreeReader;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import io.sirix.settings.Fixed;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public interface NameIndex<B, L extends ChangeListener> {
    public B createBuilder(PageTrx var1, IndexDef var2);

    public L createListener(PageTrx var1, IndexDef var2);

    default public Iterator<NodeReferences> openIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, NameFilter filter) {
        RBTreeReader reader = RBTreeReader.getInstance(pageRtx.getResourceSession().getIndexCache(), pageRtx, indexDef.getType(), indexDef.getID());
        if (filter.getIncludes().size() == 1 && filter.getExcludes().isEmpty()) {
            Optional optionalNodeReferences = reader.get(filter.getIncludes().iterator().next(), SearchMode.EQUAL);
            return Iterators.forArray((Object[])new NodeReferences[]{optionalNodeReferences.orElse(new NodeReferences())});
        }
        RBTreeReader rBTreeReader = reader;
        Objects.requireNonNull(rBTreeReader);
        RBTreeReader.RBNodeIterator iter = rBTreeReader.new RBTreeReader.RBNodeIterator(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
        ImmutableSet setFilter = ImmutableSet.of((Object)filter);
        return new IndexFilterAxis(reader, iter, (Set<? extends Filter>)((Set<Filter>)((Set<? extends Filter>)setFilter)));
    }
}

