/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.name;

import io.brackit.query.atomic.QNm;
import io.sirix.access.trx.node.IndexController;
import io.sirix.index.SearchMode;
import io.sirix.index.redblacktree.RBTreeReader;
import io.sirix.index.redblacktree.RBTreeWriter;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NameIndexListener {
    private final Set<QNm> includes;
    private final Set<QNm> excludes;
    private final RBTreeWriter<QNm, NodeReferences> indexWriter;

    public NameIndexListener(Set<QNm> includes, Set<QNm> excludes, RBTreeWriter<QNm, NodeReferences> indexTreeWriter) {
        this.includes = includes;
        this.excludes = excludes;
        this.indexWriter = indexTreeWriter;
    }

    public void listen(IndexController.ChangeType type, @NonNull ImmutableNode node, QNm name) {
        boolean excluded;
        boolean included = this.includes.isEmpty() || this.includes.contains(name);
        boolean bl = excluded = !this.excludes.isEmpty() && this.excludes.contains(name);
        if (!included || excluded) {
            return;
        }
        switch (type) {
            case INSERT: {
                Optional<NodeReferences> textReferences = this.indexWriter.get(name, SearchMode.EQUAL);
                if (textReferences.isPresent()) {
                    this.setNodeReferences(node, textReferences.get(), name);
                    break;
                }
                this.setNodeReferences(node, new NodeReferences(), name);
                break;
            }
            case DELETE: {
                this.indexWriter.remove(name, node.getNodeKey());
                break;
            }
        }
    }

    private void setNodeReferences(ImmutableNode node, NodeReferences references, QNm name) {
        this.indexWriter.index(name, references.addNodeKey(node.getNodeKey()), RBTreeReader.MoveCursor.NO_MOVE);
    }
}

