/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.name;

import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.index.IndexType;
import io.sirix.node.HashCountEntryNode;
import io.sirix.node.HashEntryNode;
import io.sirix.node.NodeKind;
import io.sirix.settings.Constants;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Objects;

public final class Names {
    private final Int2LongMap countNodeMap;
    private final Int2ObjectMap<byte[]> nameMap;
    private final Int2IntMap countNameMapping;
    private long maxNodeKey;
    private final int indexNumber;

    private Names(int indexNumber) {
        this.indexNumber = indexNumber;
        this.countNodeMap = new Int2LongOpenHashMap();
        this.nameMap = new Int2ObjectOpenHashMap();
        this.countNameMapping = new Int2IntOpenHashMap();
    }

    private Names(Names names) {
        this.indexNumber = names.indexNumber;
        this.maxNodeKey = names.maxNodeKey;
        this.countNodeMap = new Int2LongOpenHashMap(names.countNodeMap);
        this.nameMap = new Int2ObjectOpenHashMap(names.nameMap);
        this.countNameMapping = new Int2IntOpenHashMap(names.countNameMapping);
    }

    private Names(PageReadOnlyTrx pageReadTrx, int indexNumber, long maxNodeKey) {
        this.indexNumber = indexNumber;
        this.maxNodeKey = maxNodeKey;
        int size = (int)Math.ceil((double)maxNodeKey / 0.75);
        this.countNodeMap = new Int2LongOpenHashMap(size);
        this.nameMap = new Int2ObjectOpenHashMap(size);
        this.countNameMapping = new Int2IntOpenHashMap(size);
        for (long i = 1L; i < maxNodeKey; i += 2L) {
            Object nameNode = pageReadTrx.getRecord(i, IndexType.NAME, indexNumber);
            if (nameNode == null || nameNode.getKind() == NodeKind.DELETE) continue;
            HashEntryNode hashEntryNode = (HashEntryNode)nameNode;
            int key = hashEntryNode.getKey();
            this.nameMap.put(key, (Object)hashEntryNode.getValue().getBytes(Constants.DEFAULT_ENCODING));
            long nodeKeyOfCountNode = i + 1L;
            Object countNode = pageReadTrx.getRecord(nodeKeyOfCountNode, IndexType.NAME, indexNumber);
            if (countNode == null) {
                throw new IllegalStateException("Node couldn't be fetched from persistent storage: " + nodeKeyOfCountNode);
            }
            HashCountEntryNode hashKeyToNameCountEntryNode = (HashCountEntryNode)countNode;
            this.countNameMapping.put(key, hashKeyToNameCountEntryNode.getValue());
            this.countNodeMap.put(key, nodeKeyOfCountNode);
        }
    }

    public Names setMaxNodeKey(long maxNodeKey) {
        this.maxNodeKey = maxNodeKey;
        return this;
    }

    public void removeName(int key, PageTrx pageTrx) {
        int prevValue = this.countNameMapping.get(key);
        if (prevValue != 0) {
            long countNodeKey = this.countNodeMap.get(key);
            if (prevValue - 1 == 0) {
                this.nameMap.remove(key);
                this.countNameMapping.remove(key);
                pageTrx.removeRecord(countNodeKey - 1L, IndexType.NAME, this.indexNumber);
                pageTrx.removeRecord(countNodeKey, IndexType.NAME, this.indexNumber);
            } else {
                this.countNameMapping.put(key, prevValue - 1);
                HashCountEntryNode hashCountEntryNode = (HashCountEntryNode)pageTrx.prepareRecordForModification(countNodeKey, IndexType.NAME, this.indexNumber);
                hashCountEntryNode.decrementValue();
            }
        }
    }

    private static byte[] getBytes(String name) {
        return name.getBytes(Constants.DEFAULT_ENCODING);
    }

    public int setName(String name, PageTrx pageTrx) {
        assert (name != null);
        assert (pageTrx != null);
        int key = name.hashCode();
        byte[] previousByteValue = (byte[])this.nameMap.get(key);
        String previousStringValue = previousByteValue != null ? new String(previousByteValue, Constants.DEFAULT_ENCODING) : null;
        if (previousStringValue == null || !previousStringValue.equals(name)) {
            int newKey = this.nameMap.containsKey(key) ? this.getNewKey(key) : key;
            ++this.maxNodeKey;
            HashEntryNode hashEntryNode = new HashEntryNode(this.maxNodeKey, newKey, name);
            HashCountEntryNode hashCountEntryNode = new HashCountEntryNode(this.maxNodeKey + 1L, 1);
            pageTrx.createRecord(hashEntryNode, IndexType.NAME, this.indexNumber);
            ++this.maxNodeKey;
            this.countNodeMap.put(newKey, this.maxNodeKey);
            pageTrx.createRecord(hashCountEntryNode, IndexType.NAME, this.indexNumber);
            this.nameMap.put(newKey, (Object)Objects.requireNonNull(Names.getBytes(name)));
            this.countNameMapping.put(newKey, 1);
            return newKey;
        }
        int previousIntegerValue = this.countNameMapping.get(key);
        this.countNameMapping.put(key, previousIntegerValue + 1);
        long nodeKey = this.countNodeMap.get(key);
        HashCountEntryNode hashCountEntryNode = (HashCountEntryNode)pageTrx.prepareRecordForModification(nodeKey, IndexType.NAME, this.indexNumber);
        hashCountEntryNode.incrementValue();
        return key;
    }

    private int getNewKey(int key) {
        int newKey = key;
        while (this.nameMap.containsKey(newKey)) {
            ++newKey;
        }
        if (newKey == Integer.MAX_VALUE) {
            for (newKey = 0; this.nameMap.containsKey(newKey) && newKey < key; ++newKey) {
            }
        }
        if (newKey == key) {
            throw new IllegalStateException("Key is not unique.");
        }
        return newKey;
    }

    public String getName(int key) {
        byte[] name = (byte[])this.nameMap.get(key);
        if (name == null) {
            return null;
        }
        return new String(name, Constants.DEFAULT_ENCODING);
    }

    public int getCount(int key) {
        return this.countNameMapping.get(key);
    }

    public byte[] getRawName(int key) {
        return (byte[])this.nameMap.get(key);
    }

    public static Names getInstance(int indexNumber) {
        return new Names(indexNumber);
    }

    public static Names fromStorage(PageReadOnlyTrx readOnlyPageTrx, int indexNumber, long maxNodeKey) {
        return new Names(readOnlyPageTrx, indexNumber, maxNodeKey);
    }

    public static Names copy(Names names) {
        return new Names(names);
    }
}

