/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.path;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.index.ChangeListener;
import io.sirix.index.Filter;
import io.sirix.index.IndexDef;
import io.sirix.index.IndexFilterAxis;
import io.sirix.index.SearchMode;
import io.sirix.index.path.PathFilter;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.index.redblacktree.RBTreeReader;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import io.sirix.settings.Fixed;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public interface PathIndex<B, L extends ChangeListener> {
    public B createBuilder(PageTrx var1, PathSummaryReader var2, IndexDef var3);

    public L createListener(PageTrx var1, PathSummaryReader var2, IndexDef var3);

    default public Iterator<NodeReferences> openIndex(PageReadOnlyTrx pageRtx, IndexDef indexDef, PathFilter filter) {
        RBTreeReader reader = RBTreeReader.getInstance(pageRtx.getResourceSession().getIndexCache(), pageRtx, indexDef.getType(), indexDef.getID());
        if (filter != null && filter.getPCRs().size() == 1) {
            Optional optionalNodeReferences = reader.get(filter.getPCRs().iterator().next(), SearchMode.EQUAL);
            return Iterators.forArray((Object[])new NodeReferences[]{optionalNodeReferences.orElse(new NodeReferences())});
        }
        RBTreeReader rBTreeReader = reader;
        Objects.requireNonNull(rBTreeReader);
        RBTreeReader.RBNodeIterator iter = rBTreeReader.new RBTreeReader.RBNodeIterator(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
        ImmutableSet setFilter = filter == null ? ImmutableSet.of() : ImmutableSet.of((Object)filter);
        return new IndexFilterAxis(reader, iter, (Set<? extends Filter>)((Set<Filter>)((Set<? extends Filter>)setFilter)));
    }
}

