/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.path;

import io.brackit.query.atomic.QNm;
import io.brackit.query.util.path.Path;
import io.brackit.query.util.path.PathException;
import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.VisitResultType;
import io.sirix.exception.SirixIOException;
import io.sirix.index.SearchMode;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.index.redblacktree.RBTreeReader;
import io.sirix.index.redblacktree.RBTreeWriter;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.utils.LogWrapper;
import java.util.Optional;
import java.util.Set;
import org.slf4j.LoggerFactory;

public final class PathIndexBuilder {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(PathIndexBuilder.class));
    private final Set<Path<QNm>> paths;
    private final PathSummaryReader pathSummaryReader;
    private final RBTreeWriter<Long, NodeReferences> indexWriter;

    public PathIndexBuilder(RBTreeWriter<Long, NodeReferences> indexWriter, PathSummaryReader pathSummaryReader, Set<Path<QNm>> paths) {
        this.pathSummaryReader = pathSummaryReader;
        this.paths = paths;
        this.indexWriter = indexWriter;
    }

    public VisitResult process(ImmutableNode node, long pathNodeKey) {
        try {
            long PCR = pathNodeKey;
            if (this.pathSummaryReader.getPCRsForPaths(this.paths).contains(PCR) || this.paths.isEmpty()) {
                Optional<NodeReferences> textReferences = this.indexWriter.get(PCR, SearchMode.EQUAL);
                if (textReferences.isPresent()) {
                    this.setNodeReferences(node, textReferences.get(), PCR);
                } else {
                    this.setNodeReferences(node, new NodeReferences(), PCR);
                }
            }
        }
        catch (PathException | SirixIOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return VisitResultType.CONTINUE;
    }

    private void setNodeReferences(ImmutableNode node, NodeReferences references, long pathNodeKey) throws SirixIOException {
        this.indexWriter.index(pathNodeKey, references.addNodeKey(node.getNodeKey()), RBTreeReader.MoveCursor.NO_MOVE);
    }
}

