/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.path;

import io.brackit.query.atomic.QNm;
import io.brackit.query.util.path.Path;
import io.sirix.access.DatabaseType;
import io.sirix.api.PageTrx;
import io.sirix.index.IndexDef;
import io.sirix.index.IndexType;
import io.sirix.index.path.PathIndexBuilder;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.index.redblacktree.RBTreeWriter;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import java.util.Objects;
import java.util.Set;

public final class PathIndexBuilderFactory {
    private final DatabaseType databaseType;

    public PathIndexBuilderFactory(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public PathIndexBuilder create(PageTrx pageTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        PathSummaryReader pathSummary = Objects.requireNonNull(pathSummaryReader);
        Set<Path<QNm>> paths = Objects.requireNonNull(indexDef.getPaths());
        assert (indexDef.getType() == IndexType.PATH);
        RBTreeWriter<Long, NodeReferences> rbTreeWriter = RBTreeWriter.getInstance(this.databaseType, pageTrx, indexDef.getType(), indexDef.getID());
        return new PathIndexBuilder(rbTreeWriter, pathSummary, paths);
    }
}

