/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.path;

import io.brackit.query.atomic.QNm;
import io.brackit.query.util.path.Path;
import io.brackit.query.util.path.PathException;
import io.sirix.access.trx.node.IndexController;
import io.sirix.exception.SirixIOException;
import io.sirix.index.SearchMode;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.index.redblacktree.RBTreeReader;
import io.sirix.index.redblacktree.RBTreeWriter;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import java.util.Optional;
import java.util.Set;

public final class PathIndexListener {
    private final RBTreeWriter<Long, NodeReferences> indexWriter;
    private final PathSummaryReader pathSummaryReader;
    private final Set<Path<QNm>> paths;

    public PathIndexListener(Set<Path<QNm>> paths, PathSummaryReader pathSummaryReader, RBTreeWriter<Long, NodeReferences> indexWriter) {
        this.indexWriter = indexWriter;
        this.pathSummaryReader = pathSummaryReader;
        this.paths = paths;
    }

    public void listen(IndexController.ChangeType type, ImmutableNode node, long pathNodeKey) {
        this.pathSummaryReader.moveTo(pathNodeKey);
        try {
            switch (type) {
                case INSERT: {
                    if (!this.pathSummaryReader.getPCRsForPaths(this.paths).contains(pathNodeKey)) break;
                    Optional<NodeReferences> textReferences = this.indexWriter.get(pathNodeKey, SearchMode.EQUAL);
                    if (textReferences.isPresent()) {
                        this.setNodeReferences(node, textReferences.get(), pathNodeKey);
                        break;
                    }
                    this.setNodeReferences(node, new NodeReferences(), pathNodeKey);
                    break;
                }
                case DELETE: {
                    if (!this.pathSummaryReader.getPCRsForPaths(this.paths).contains(pathNodeKey)) break;
                    this.indexWriter.remove(pathNodeKey, node.getNodeKey());
                    break;
                }
            }
        }
        catch (PathException e) {
            throw new SirixIOException(e);
        }
    }

    private void setNodeReferences(ImmutableNode node, NodeReferences references, long pathNodeKey) throws SirixIOException {
        this.indexWriter.index(pathNodeKey, references.addNodeKey(node.getNodeKey()), RBTreeReader.MoveCursor.NO_MOVE);
    }
}

