/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.path.summary;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.brackit.query.atomic.QNm;
import io.brackit.query.util.path.Path;
import io.sirix.node.NodeKind;
import io.sirix.node.delegates.NameNodeDelegate;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.interfaces.NameNode;
import io.sirix.node.xml.AbstractStructForwardingNode;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PathNode
extends AbstractStructForwardingNode
implements NameNode {
    private final NodeDelegate nodeDel;
    private final StructNodeDelegate structNodeDel;
    private final NameNodeDelegate nameNodeDel;
    private final NodeKind kind;
    private QNm name;
    private int references;
    private final int level;
    private PathNode firstChild;
    private PathNode lastChild;
    private PathNode parent;
    private PathNode leftSibling;
    private PathNode rightSibling;
    private Path<QNm> path;

    public PathNode(QNm name, NodeDelegate nodeDel, @NonNull StructNodeDelegate structNodeDel, @NonNull NameNodeDelegate nameNodeDel, @NonNull NodeKind kind, @NonNegative int references, @NonNegative int level) {
        this.name = name;
        this.nodeDel = Objects.requireNonNull(nodeDel);
        this.structNodeDel = Objects.requireNonNull(structNodeDel);
        this.nameNodeDel = Objects.requireNonNull(nameNodeDel);
        this.kind = Objects.requireNonNull(kind);
        Preconditions.checkArgument((references > 0 ? 1 : 0) != 0, (Object)"references must be > 0!");
        this.references = references;
        this.level = level;
    }

    public Path<QNm> getPath() {
        return this.path;
    }

    public PathNode setPath(Path<QNm> path) {
        this.path = path;
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public int getReferences() {
        return this.references;
    }

    public void setReferenceCount(@NonNegative int references) {
        Preconditions.checkArgument((references > 0 ? 1 : 0) != 0, (Object)"pReferences must be > 0!");
        this.references = references;
    }

    public void incrementReferenceCount() {
        ++this.references;
    }

    public void decrementReferenceCount() {
        if (this.references <= 1) {
            throw new IllegalStateException();
        }
        --this.references;
    }

    public NodeKind getPathKind() {
        return this.kind;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.PATH;
    }

    @Override
    public int getPrefixKey() {
        return this.nameNodeDel.getPrefixKey();
    }

    @Override
    public int getLocalNameKey() {
        return this.nameNodeDel.getLocalNameKey();
    }

    @Override
    public int getURIKey() {
        return this.nameNodeDel.getURIKey();
    }

    @Override
    public void setLocalNameKey(int nameKey) {
        this.nameNodeDel.setLocalNameKey(nameKey);
    }

    @Override
    public void setPrefixKey(int prefixKey) {
        this.nameNodeDel.setPrefixKey(prefixKey);
    }

    @Override
    public void setURIKey(int uriKey) {
        this.nameNodeDel.setURIKey(uriKey);
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.structNodeDel;
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.nodeDel;
    }

    public NameNodeDelegate getNameNodeDelegate() {
        return this.nameNodeDel;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.nodeDel, this.nameNodeDel});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof PathNode) {
            PathNode other = (PathNode)obj;
            return com.google.common.base.Objects.equal((Object)this.nodeDel, (Object)other.nodeDel) && com.google.common.base.Objects.equal((Object)this.nameNodeDel, (Object)other.nameNodeDel);
        }
        return false;
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node delegate", (Object)this.nodeDel).add("struct delegate", (Object)this.structNodeDel).add("name delegate", (Object)this.nameNodeDel).add("references", this.references).add("kind", (Object)this.kind).add("level", this.level).toString();
    }

    @Override
    public void setPathNodeKey(long nodeKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getPathNodeKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QNm getName() {
        return this.name;
    }

    public void setFirstChild(PathNode pathNode) {
        this.firstChild = pathNode;
    }

    public void setLastChild(PathNode pathNode) {
        this.lastChild = pathNode;
    }

    public void setParent(PathNode pathNode) {
        this.parent = pathNode;
    }

    public void setLeftSibling(PathNode pathNode) {
        this.leftSibling = pathNode;
    }

    public void setRightSibling(PathNode pathNode) {
        this.rightSibling = pathNode;
    }

    public PathNode getFirstChild() {
        return this.firstChild;
    }

    public PathNode getLastChild() {
        return this.lastChild;
    }

    public PathNode getParent() {
        return this.parent;
    }

    public PathNode getLeftSibling() {
        return this.leftSibling;
    }

    public PathNode getRightSibling() {
        return this.rightSibling;
    }

    public void setName(QNm qNm) {
        this.name = qNm;
    }
}

