/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.path.summary;

import com.google.common.base.MoreObjects;
import io.brackit.query.atomic.QNm;
import io.brackit.query.util.path.Path;
import io.brackit.query.util.path.PathException;
import io.sirix.access.User;
import io.sirix.access.trx.node.CommitCredentials;
import io.sirix.api.Filter;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.ResourceSession;
import io.sirix.api.json.JsonResourceSession;
import io.sirix.axis.DescendantAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.axis.filter.FilterAxis;
import io.sirix.axis.filter.PathNameFilter;
import io.sirix.axis.pathsummary.LevelOrderSettingInMemoryInstancesAxis;
import io.sirix.cache.Cache;
import io.sirix.cache.PathSummaryData;
import io.sirix.exception.SirixIOException;
import io.sirix.index.IndexType;
import io.sirix.index.path.summary.ImmutablePathNode;
import io.sirix.index.path.summary.PathNode;
import io.sirix.node.NodeKind;
import io.sirix.node.NullNode;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.immutable.json.ImmutableJsonDocumentRootNode;
import io.sirix.node.immutable.xml.ImmutableXmlDocumentRootNode;
import io.sirix.node.interfaces.NameNode;
import io.sirix.node.interfaces.StructNode;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.node.json.JsonDocumentRootNode;
import io.sirix.node.xml.XmlDocumentRootNode;
import io.sirix.page.PageReference;
import io.sirix.page.PathSummaryPage;
import io.sirix.settings.Fixed;
import io.sirix.utils.IntToObjectMap;
import io.sirix.utils.NamePageHash;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongHash;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.time.Instant;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.index.qual.NonNegative;

public final class PathSummaryReader
implements NodeReadOnlyTrx,
NodeCursor {
    private StructNode currentNode;
    private final PageReadOnlyTrx pageReadTrx;
    private final ResourceSession<? extends NodeReadOnlyTrx, ? extends NodeTrx> resourceSession;
    private boolean isClosed;
    private final IntToObjectMap<StructNode> pathNodeMapping;
    private final Map<QNm, Set<PathNode>> qnmMapping;
    private final Map<Path<QNm>, LongSet> pathCache = new HashMap<Path<QNm>, LongSet>();
    private boolean init = true;

    private PathSummaryReader(PageReadOnlyTrx pageReadTrx, ResourceSession<? extends NodeReadOnlyTrx, ? extends NodeTrx> resourceSession) {
        this.pageReadTrx = pageReadTrx;
        this.isClosed = false;
        this.resourceSession = resourceSession;
        Cache<Integer, PathSummaryData> pathSummaryCache = pageReadTrx.getBufferManager().getPathSummaryCache();
        PathSummaryData pathSummaryData = pathSummaryCache.get(pageReadTrx.getRevisionNumber());
        if (pathSummaryData == null || pageReadTrx.hasTrxIntentLog()) {
            this.currentNode = (StructNode)this.pageReadTrx.getRecord(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), IndexType.PATH_SUMMARY, 0);
            if (this.currentNode == null) {
                throw new IllegalStateException("Node couldn't be fetched from persistent storage!");
            }
            int maxNrOfNodes = (int)this.pageReadTrx.getPathSummaryPage(this.pageReadTrx.getActualRevisionRootPage()).getMaxNodeKey(0);
            int maxNrOfNodesForMap = (int)Math.ceil((double)maxNrOfNodes / 0.75);
            this.pathNodeMapping = new IntToObjectMap(maxNrOfNodes);
            this.qnmMapping = new HashMap<QNm, Set<PathNode>>(maxNrOfNodesForMap);
            boolean first = true;
            boolean hasMoved = this.moveToFirstChild();
            if (hasMoved) {
                LevelOrderSettingInMemoryInstancesAxis axis = new LevelOrderSettingInMemoryInstancesAxis.Builder(this).includeSelf().build();
                while (axis.hasNext()) {
                    PathNode pathNode = axis.next();
                    this.pathNodeMapping.put((int)pathNode.getNodeKey(), pathNode);
                    this.moveTo(pathNode.getNodeKey());
                    assert (this.getNodeKey() == pathNode.getNodeKey());
                    this.qnmMapping.computeIfAbsent(this.getName(), unused -> new HashSet()).add(pathNode);
                    assert (Objects.equals(this.getName(), pathNode.getName()));
                }
                this.moveToDocumentRoot();
            }
            if (!pageReadTrx.hasTrxIntentLog()) {
                pathSummaryCache.put(pageReadTrx.getRevisionNumber(), new PathSummaryData(this.currentNode, this.pathNodeMapping, this.qnmMapping));
            }
        } else {
            this.currentNode = pathSummaryData.currentNode();
            this.pathNodeMapping = pathSummaryData.pathNodeMapping();
            this.qnmMapping = pathSummaryData.qnmMapping();
        }
        this.init = false;
    }

    @Override
    public Optional<User> getUser() {
        return this.pageReadTrx.getActualRevisionRootPage().getUser();
    }

    @Override
    public boolean storeDeweyIDs() {
        return false;
    }

    @Override
    public PageReadOnlyTrx getPageTrx() {
        return this.pageReadTrx;
    }

    public static PathSummaryReader getInstance(PageReadOnlyTrx pageReadTrx, ResourceSession<? extends NodeReadOnlyTrx, ? extends NodeTrx> resourceSession) {
        return new PathSummaryReader(Objects.requireNonNull(pageReadTrx), Objects.requireNonNull(resourceSession));
    }

    void putMapping(@NonNegative long pathNodeKey, StructNode node) {
        this.pathNodeMapping.put((int)pathNodeKey, node);
    }

    StructNode removeMapping(@NonNegative long pathNodeKey) {
        return this.pathNodeMapping.remove((int)pathNodeKey);
    }

    void putQNameMapping(PathNode node, QNm name) {
        Set pathNodes = this.qnmMapping.computeIfAbsent(this.getName(), unused -> new HashSet());
        pathNodes.add(node);
        this.qnmMapping.put(name, pathNodes);
    }

    void removeQNameMapping(@NonNegative PathNode node, QNm name) {
        Set pathNodes = this.qnmMapping.computeIfAbsent(this.getName(), unused -> new HashSet());
        if (pathNodes.size() == 1) {
            this.qnmMapping.remove(name);
        } else {
            pathNodes.remove(node);
        }
    }

    public BitSet matchDescendants(QNm name, @NonNegative long pathNodeKey, IncludeSelf includeSelf) {
        this.assertNotClosed();
        Set<PathNode> set = this.qnmMapping.get(name);
        if (set == null) {
            return new BitSet(0);
        }
        this.moveTo(pathNodeKey);
        BitSet matches = new BitSet();
        LongIterator longIterator = new FilterAxis<PathSummaryReader>(new DescendantAxis(this, includeSelf), new PathNameFilter(this, name.toString()), new Filter[0]).iterator();
        while (longIterator.hasNext()) {
            long nodeKey = (Long)longIterator.next();
            matches.set((int)nodeKey);
        }
        return matches;
    }

    public BitSet match(QNm name, @NonNegative int minLevel) {
        this.assertNotClosed();
        Set<PathNode> set = this.qnmMapping.get(name);
        if (set == null) {
            return new BitSet(0);
        }
        BitSet matches = new BitSet();
        for (PathNode psn : set) {
            if (psn.getLevel() < minLevel) continue;
            matches.set((int)psn.getNodeKey());
        }
        return matches;
    }

    public BitSet match(QNm name, @NonNegative int minLevel, NodeKind nodeKind) {
        this.assertNotClosed();
        Set<PathNode> set = this.qnmMapping.get(name);
        if (set == null) {
            return new BitSet(0);
        }
        BitSet matches = new BitSet();
        for (PathNode psn : set) {
            if (psn.getLevel() < minLevel || psn.getPathKind() != nodeKind) continue;
            matches.set((int)psn.getNodeKey());
        }
        return matches;
    }

    public Optional<PathNode> matchLevel(QNm name, @NonNegative int level, NodeKind nodeKind) {
        this.assertNotClosed();
        Set<PathNode> set = this.qnmMapping.get(name);
        if (set == null) {
            return Optional.empty();
        }
        for (PathNode pathNode : set) {
            if (pathNode.getLevel() != level || pathNode.getPathKind() != nodeKind) continue;
            return Optional.of(pathNode);
        }
        return Optional.empty();
    }

    public LongSet getPCRsForPaths(Collection<Path<QNm>> expressions) throws PathException {
        this.assertNotClosed();
        LongOpenHashSet pcrs = new LongOpenHashSet();
        for (Path<QNm> path : expressions) {
            pcrs.addAll((LongCollection)this.getPCRsForPath(path));
        }
        return pcrs;
    }

    public PathNode getPathNodeForPathNodeKey(@NonNegative long pathNodeKey) {
        this.assertNotClosed();
        return (PathNode)this.pathNodeMapping.get((int)pathNodeKey);
    }

    @Override
    public ImmutableNode getNode() {
        this.assertNotClosed();
        if (this.currentNode instanceof XmlDocumentRootNode) {
            return ImmutableXmlDocumentRootNode.of((XmlDocumentRootNode)this.currentNode);
        }
        if (this.currentNode instanceof JsonDocumentRootNode) {
            return ImmutableJsonDocumentRootNode.of((JsonDocumentRootNode)this.currentNode);
        }
        return ImmutablePathNode.of((PathNode)this.currentNode);
    }

    public LongSet getPCRsForPath(Path<QNm> path) throws PathException {
        LongSet pcrSet = this.pathCache.get(path);
        if (pcrSet != null) {
            return pcrSet;
        }
        pcrSet = new LongOpenHashSet();
        boolean isAttributePattern = path.isAttribute();
        int pathLength = path.getLength();
        long nodeKey = this.currentNode.getNodeKey();
        this.moveToDocumentRoot();
        DescendantAxis axis = new DescendantAxis(this);
        while (axis.hasNext()) {
            axis.nextLong();
            PathNode node = this.getPathNode();
            if (node == null || node.getLevel() < pathLength || isAttributePattern ^ node.getPathKind() == NodeKind.ATTRIBUTE) continue;
            Path<QNm> nodePath = this.getPath();
            assert (nodePath != null);
            if (!path.matches(nodePath)) continue;
            pcrSet.add(node.getNodeKey());
        }
        this.moveTo(nodeKey);
        this.pathCache.put(path, pcrSet);
        return pcrSet;
    }

    @Override
    public boolean hasChildren() {
        this.assertNotClosed();
        return this.getStructuralNode().getChildCount() > 0L;
    }

    public PathNode getPathNode() {
        this.assertNotClosed();
        if (this.currentNode instanceof PathNode) {
            return (PathNode)this.currentNode;
        }
        return null;
    }

    @Override
    public boolean moveTo(long nodeKey) {
        StructNode newNode;
        this.assertNotClosed();
        if (!this.init && nodeKey != 0L) {
            PathNode node = (PathNode)this.pathNodeMapping.get((int)nodeKey);
            if (node != null) {
                this.currentNode = node;
                return true;
            }
            return false;
        }
        StructNode oldNode = this.currentNode;
        try {
            newNode = (StructNode)this.pageReadTrx.getRecord(nodeKey, IndexType.PATH_SUMMARY, 0);
        }
        catch (SirixIOException e) {
            newNode = null;
        }
        if (newNode == null) {
            this.currentNode = oldNode;
            return false;
        }
        this.currentNode = newNode;
        return true;
    }

    @Override
    public boolean moveToParent() {
        PathNode pathNode;
        this.assertNotClosed();
        if (!this.getStructuralNode().hasParent()) {
            return false;
        }
        StructNode node = this.getStructuralNode();
        if (node instanceof PathNode && (pathNode = (PathNode)node).getParent() != null) {
            this.currentNode = pathNode.getParent();
            return true;
        }
        return this.moveTo(this.getStructuralNode().getParentKey());
    }

    @Override
    public boolean moveToFirstChild() {
        PathNode pathNode;
        this.assertNotClosed();
        if (!this.getStructuralNode().hasFirstChild()) {
            return false;
        }
        StructNode node = this.getStructuralNode();
        if (node instanceof PathNode && (pathNode = (PathNode)node).getFirstChild() != null) {
            this.currentNode = pathNode.getFirstChild();
            return true;
        }
        return this.moveTo(this.getStructuralNode().getFirstChildKey());
    }

    @Override
    public boolean moveToLeftSibling() {
        PathNode pathNode;
        this.assertNotClosed();
        if (!this.getStructuralNode().hasLeftSibling()) {
            return false;
        }
        StructNode node = this.getStructuralNode();
        if (node instanceof PathNode && (pathNode = (PathNode)node).getLeftSibling() != null) {
            this.currentNode = pathNode.getLeftSibling();
            return true;
        }
        return this.moveTo(this.getStructuralNode().getLeftSiblingKey());
    }

    @Override
    public boolean moveToRightSibling() {
        PathNode pathNode;
        this.assertNotClosed();
        if (!this.getStructuralNode().hasRightSibling()) {
            return false;
        }
        StructNode node = this.getStructuralNode();
        if (node instanceof PathNode && (pathNode = (PathNode)node).getRightSibling() != null) {
            this.currentNode = pathNode.getRightSibling();
            return true;
        }
        return this.moveTo(this.getStructuralNode().getRightSiblingKey());
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.currentNode = null;
            this.isClosed = true;
            if (this.pageReadTrx != null && !this.pageReadTrx.isClosed()) {
                this.pageReadTrx.close();
            }
        }
    }

    private void assertNotClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Path summary is already closed.");
        }
    }

    @Override
    public boolean moveToDocumentRoot() {
        return this.moveTo(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
    }

    private StructNode getStructuralNode() {
        if (this.currentNode != null) {
            return this.currentNode;
        }
        return new NullNode(null);
    }

    @Override
    public long getId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRevisionNumber() {
        this.assertNotClosed();
        return this.pageReadTrx.getRevisionNumber();
    }

    @Override
    public Instant getRevisionTimestamp() {
        this.assertNotClosed();
        return Instant.ofEpochMilli(this.pageReadTrx.getActualRevisionRootPage().getRevisionTimestamp());
    }

    @Override
    public long getMaxNodeKey() {
        this.assertNotClosed();
        PageReference pageReference = this.pageReadTrx.getActualRevisionRootPage().getPathSummaryPageReference();
        if (pageReference.getPage() == null) {
            pageReference.setPage(this.pageReadTrx.getReader().read(pageReference, this.pageReadTrx));
        }
        return ((PathSummaryPage)pageReference.getPage()).getMaxNodeKey(0);
    }

    @Override
    public boolean moveToNextFollowing() {
        this.assertNotClosed();
        while (!this.getStructuralNode().hasRightSibling() && this.currentNode.hasParent()) {
            this.moveToParent();
        }
        return this.moveToRightSibling();
    }

    @Override
    public QNm getName() {
        this.assertNotClosed();
        StructNode structNode = this.currentNode;
        if (structNode instanceof NameNode) {
            NameNode nameNode = (NameNode)((Object)structNode);
            QNm name = nameNode.getName();
            if (name != null) {
                return nameNode.getName();
            }
            int uriKey = nameNode.getURIKey();
            String uri = uriKey == -1 || this.pageReadTrx.getResourceSession() instanceof JsonResourceSession ? "" : this.pageReadTrx.getName(nameNode.getURIKey(), NodeKind.NAMESPACE);
            int prefixKey = nameNode.getPrefixKey();
            String prefix = prefixKey == -1 ? "" : this.pageReadTrx.getName(prefixKey, ((PathNode)this.currentNode).getPathKind());
            int localNameKey = nameNode.getLocalNameKey();
            String localName = localNameKey == -1 ? "" : this.pageReadTrx.getName(localNameKey, ((PathNode)this.currentNode).getPathKind());
            QNm qNm = new QNm(uri, prefix, localName);
            if (nameNode instanceof PathNode) {
                PathNode pathNode = (PathNode)nameNode;
                pathNode.setName(qNm);
            }
            return qNm;
        }
        return null;
    }

    @Override
    public int keyForName(String pName) {
        this.assertNotClosed();
        return NamePageHash.generateHashForString(pName);
    }

    @Override
    public String nameForKey(int key) {
        this.assertNotClosed();
        StructNode structNode = this.currentNode;
        if (structNode instanceof PathNode) {
            PathNode node = (PathNode)structNode;
            return this.pageReadTrx.getName(key, node.getPathKind());
        }
        return "";
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public ResourceSession<? extends NodeReadOnlyTrx, ? extends NodeTrx> getResourceSession() {
        this.assertNotClosed();
        return this.resourceSession;
    }

    @Override
    public boolean moveToLastChild() {
        this.assertNotClosed();
        if (this.getStructuralNode().hasFirstChild()) {
            this.moveToFirstChild();
            while (this.getStructuralNode().hasRightSibling()) {
                this.moveToRightSibling();
            }
            return true;
        }
        return false;
    }

    public Path<QNm> getPath() {
        Path<QNm> pathFromNode;
        PathNode currNode = this.getPathNode();
        PathNode node = currNode;
        if (node == null) {
            this.moveToFirstChild();
            node = this.getPathNode();
            if (node == null) {
                return null;
            }
        }
        if ((pathFromNode = node.getPath()) != null) {
            return pathFromNode;
        }
        long nodeKey = this.getNodeKey();
        this.moveTo(node.getNodeKey());
        PathNode[] paths = new PathNode[node.getLevel()];
        for (int i = node.getLevel() - 1; i >= 0; --i) {
            paths[i] = node;
            this.moveToParent();
            node = this.getPathNode();
        }
        Path path = new Path();
        for (PathNode pathNode : paths) {
            this.moveTo(pathNode.getNodeKey());
            if (pathNode.getPathKind() == NodeKind.ATTRIBUTE) {
                path.attribute((Object)this.getName());
                continue;
            }
            if (pathNode.getPathKind() == NodeKind.ARRAY) {
                path.childArray();
                continue;
            }
            if (pathNode.getPathKind() == NodeKind.OBJECT_KEY) {
                path.childObjectField((Object)this.getName());
                continue;
            }
            path.child((Object)this.getName());
        }
        this.moveTo(nodeKey);
        assert (currNode != null);
        currNode.setPath((Path<QNm>)path);
        return path;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        StructNode structNode = this.currentNode;
        if (structNode instanceof PathNode) {
            PathNode node = (PathNode)structNode;
            helper.add("uri", (Object)this.pageReadTrx.getName(node.getURIKey(), node.getPathKind()));
            helper.add("prefix", (Object)this.pageReadTrx.getName(node.getPrefixKey(), node.getPathKind()));
            helper.add("localName", (Object)this.pageReadTrx.getName(node.getLocalNameKey(), node.getPathKind()));
        }
        helper.add("node", (Object)this.currentNode);
        return helper.toString();
    }

    public int getLevel() {
        this.assertNotClosed();
        if (this.currentNode instanceof PathNode) {
            assert (this.getPathNode() != null);
            return this.getPathNode().getLevel();
        }
        return 0;
    }

    @Override
    public boolean hasNode(@NonNegative long key) {
        this.assertNotClosed();
        long currNodeKey = this.currentNode.getNodeKey();
        boolean retVal = this.moveTo(key);
        boolean movedBack = this.moveTo(currNodeKey);
        assert (movedBack) : "moveTo(currNodeKey) must succeed!";
        return retVal;
    }

    @Override
    public boolean hasParent() {
        this.assertNotClosed();
        return this.currentNode.hasParent();
    }

    @Override
    public boolean hasFirstChild() {
        this.assertNotClosed();
        return this.getStructuralNode().hasFirstChild();
    }

    @Override
    public boolean hasLastChild() {
        this.assertNotClosed();
        return this.getStructuralNode().hasFirstChild();
    }

    @Override
    public boolean hasLeftSibling() {
        this.assertNotClosed();
        return this.getStructuralNode().hasLeftSibling();
    }

    @Override
    public boolean hasRightSibling() {
        this.assertNotClosed();
        return this.getStructuralNode().hasRightSibling();
    }

    @Override
    public long getNodeKey() {
        this.assertNotClosed();
        return this.currentNode.getNodeKey();
    }

    @Override
    public long getLeftSiblingKey() {
        this.assertNotClosed();
        return this.getStructuralNode().getLeftSiblingKey();
    }

    @Override
    public long getRightSiblingKey() {
        this.assertNotClosed();
        return this.getStructuralNode().getRightSiblingKey();
    }

    @Override
    public long getFirstChildKey() {
        this.assertNotClosed();
        return this.getStructuralNode().getFirstChildKey();
    }

    @Override
    public long getLastChildKey() {
        this.assertNotClosed();
        if (this.getStructuralNode().hasFirstChild()) {
            this.moveToFirstChild();
            while (this.getStructuralNode().hasRightSibling()) {
                this.moveToRightSibling();
            }
            return this.currentNode.getNodeKey();
        }
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public long getParentKey() {
        this.assertNotClosed();
        return this.currentNode.getParentKey();
    }

    @Override
    public NodeKind getKind() {
        this.assertNotClosed();
        return this.currentNode.getKind();
    }

    @Override
    public long getPathNodeKey() {
        this.assertNotClosed();
        return -1L;
    }

    @Override
    public NodeKind getPathKind() {
        this.assertNotClosed();
        if (this.currentNode instanceof PathNode) {
            return ((PathNode)this.currentNode).getPathKind();
        }
        return NodeKind.NULL;
    }

    @Override
    public long getChildCount() {
        this.assertNotClosed();
        return this.getStructuralNode().getChildCount();
    }

    @Override
    public long getDescendantCount() {
        this.assertNotClosed();
        return this.getStructuralNode().getDescendantCount();
    }

    @Override
    public NodeKind getFirstChildKind() {
        this.assertNotClosed();
        return NodeKind.PATH;
    }

    @Override
    public NodeKind getLastChildKind() {
        this.assertNotClosed();
        return NodeKind.PATH;
    }

    @Override
    public NodeKind getLeftSiblingKind() {
        this.assertNotClosed();
        return NodeKind.PATH;
    }

    @Override
    public NodeKind getParentKind() {
        this.assertNotClosed();
        if (this.currentNode.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
            StructNode currentStructNode = this.getStructuralNode();
            this.moveToParent();
            NodeKind parentKind = this.currentNode.getKind();
            this.currentNode = currentStructNode;
            return parentKind;
        }
        if (this.currentNode.getParentKey() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return NodeKind.UNKNOWN;
        }
        return NodeKind.PATH;
    }

    @Override
    public NodeKind getRightSiblingKind() {
        this.assertNotClosed();
        return NodeKind.PATH;
    }

    public int getReferences() {
        this.assertNotClosed();
        if (this.currentNode.getKind() == NodeKind.XML_DOCUMENT) {
            return 1;
        }
        assert (this.getPathNode() != null);
        return this.getPathNode().getReferences();
    }

    @Override
    public boolean isDocumentRoot() {
        this.assertNotClosed();
        return this.currentNode.getKind() == NodeKind.XML_DOCUMENT || this.currentNode.getKind() == NodeKind.JSON_DOCUMENT;
    }

    @Override
    public boolean moveToPrevious() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (node.hasLeftSibling()) {
            boolean leftSiblMove = this.moveTo(node.getLeftSiblingKey());
            while (this.hasFirstChild()) {
                this.moveToLastChild();
            }
            return leftSiblMove;
        }
        return this.moveTo(node.getParentKey());
    }

    @Override
    public boolean moveToNext() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (node.hasRightSibling()) {
            return this.moveTo(node.getRightSiblingKey());
        }
        return this.moveToNextFollowing();
    }

    @Override
    public CommitCredentials getCommitCredentials() {
        this.assertNotClosed();
        return this.pageReadTrx.getCommitCredentials();
    }

    public boolean isNameNode() {
        this.assertNotClosed();
        return this.currentNode instanceof NameNode;
    }

    public int getLocalNameKey() {
        this.assertNotClosed();
        if (this.currentNode instanceof NameNode) {
            return ((NameNode)((Object)this.currentNode)).getLocalNameKey();
        }
        return -1;
    }

    public int getPrefixKey() {
        this.assertNotClosed();
        StructNode structNode = this.currentNode;
        if (structNode instanceof NameNode) {
            NameNode nameNode = (NameNode)((Object)structNode);
            return nameNode.getPrefixKey();
        }
        return -1;
    }

    @Override
    public long getHash() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SirixDeweyID getDeweyID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPreviousRevisionNumber() {
        throw new UnsupportedOperationException();
    }

    public void clearCache() {
        this.pathCache.clear();
    }

    public void removeFromCache(QNm name) {
        this.pathCache.keySet().removeIf(path -> ((QNm)path.tail()).equals((Object)name));
    }

    private static class DictionaryHashStrategy
    implements LongHash.Strategy {
        private DictionaryHashStrategy() {
        }

        public int hashCode(long l) {
            return (int)(l ^ l >>> 32);
        }

        public boolean equals(long l1, long l2) {
            return l1 == l2;
        }
    }
}

