/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.redblacktree;

import com.google.common.base.MoreObjects;
import io.brackit.query.atomic.QNm;
import io.sirix.index.redblacktree.interfaces.MutableRBNodeKey;
import io.sirix.index.redblacktree.keyvalue.CASValue;
import io.sirix.node.AbstractForwardingNode;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.settings.Fixed;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class RBNodeKey<K extends Comparable<? super K>>
extends AbstractForwardingNode
implements MutableRBNodeKey<K> {
    private K key;
    private long valueNodeKey;
    private long left = Fixed.NULL_NODE_KEY.getStandardProperty();
    private long right = Fixed.NULL_NODE_KEY.getStandardProperty();
    private boolean isChanged;
    private final NodeDelegate nodeDelegate;
    private RBNodeKey<K> parent;
    private RBNodeKey<K> leftChild;
    private RBNodeKey<K> rightChild;

    public RBNodeKey(K key, long valueNodeKey, NodeDelegate nodeDelegate) {
        this.key = (Comparable)Objects.requireNonNull(key);
        this.valueNodeKey = valueNodeKey;
        this.nodeDelegate = Objects.requireNonNull(nodeDelegate);
    }

    @Override
    public NodeKind getKind() {
        if (this.key instanceof Long) {
            return NodeKind.PATHRB;
        }
        if (this.key instanceof CASValue) {
            return NodeKind.CASRB;
        }
        if (this.key instanceof QNm) {
            return NodeKind.NAMERB;
        }
        return NodeKind.UNKNOWN;
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.nodeDelegate;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public long getValueNodeKey() {
        return this.valueNodeKey;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void setChanged(boolean changed) {
        this.isChanged = changed;
    }

    @Override
    public boolean hasLeftChild() {
        return this.left != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public boolean hasRightChild() {
        return this.right != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public long getLeftChildKey() {
        return this.left;
    }

    @Override
    public long getRightChildKey() {
        return this.right;
    }

    public RBNodeKey<K> getParent() {
        return this.parent;
    }

    public RBNodeKey<K> getLeftChild() {
        return this.leftChild;
    }

    public RBNodeKey<K> getRightChild() {
        return this.rightChild;
    }

    public void setLeftChild(RBNodeKey<K> leftChild) {
        this.leftChild = leftChild;
    }

    public void setRightChild(RBNodeKey<K> rightChild) {
        this.rightChild = rightChild;
    }

    public void setParent(RBNodeKey<K> parent) {
        this.parent = parent;
    }

    @Override
    public void setLeftChildKey(long left) {
        this.left = left;
    }

    @Override
    public void setRightChildKey(long right) {
        this.right = right;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.nodeDelegate.getNodeKey()});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof RBNodeKey) {
            RBNodeKey other = (RBNodeKey)obj;
            return this.nodeDelegate.getNodeKey() == other.nodeDelegate.getNodeKey();
        }
        return false;
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node delegate", (Object)this.nodeDelegate).add("left child", this.left).add("right child", this.right).add("changed", this.isChanged).add("key", this.key).add("valueNodeKey", this.valueNodeKey).toString();
    }

    @Override
    public void setKey(K key) {
        this.key = (Comparable)Objects.requireNonNull(key);
    }

    @Override
    public SirixDeweyID getDeweyID() {
        return null;
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return null;
    }

    @Override
    public int getPreviousRevisionNumber() {
        throw new UnsupportedOperationException();
    }
}

