/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.redblacktree;

import com.google.common.base.MoreObjects;
import io.sirix.index.redblacktree.interfaces.MutableRBNodeValue;
import io.sirix.node.AbstractForwardingNode;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.settings.Fixed;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class RBNodeValue<V>
extends AbstractForwardingNode
implements MutableRBNodeValue<V> {
    private V value;
    private static final long LEFT = Fixed.NULL_NODE_KEY.getStandardProperty();
    private static final long RIGHT = Fixed.NULL_NODE_KEY.getStandardProperty();
    private NodeDelegate nodeDelegate;

    public RBNodeValue(V value, NodeDelegate nodeDelegate) {
        this.value = Objects.requireNonNull(value);
        this.nodeDelegate = Objects.requireNonNull(nodeDelegate);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.RB_NODE_VALUE;
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.nodeDelegate;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public boolean hasLeftChild() {
        return LEFT != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public boolean hasRightChild() {
        return RIGHT != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public long getLeftChildKey() {
        return LEFT;
    }

    @Override
    public long getRightChildKey() {
        return RIGHT;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.nodeDelegate.getNodeKey()});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof RBNodeValue) {
            RBNodeValue other = (RBNodeValue)obj;
            return this.nodeDelegate.getNodeKey() == other.nodeDelegate.getNodeKey();
        }
        return false;
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node delegate", (Object)this.nodeDelegate).add("value", this.value).toString();
    }

    @Override
    public SirixDeweyID getDeweyID() {
        return null;
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return null;
    }

    @Override
    public int getPreviousRevisionNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValue(V value) {
        this.value = value;
    }
}

