/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.redblacktree.keyvalue;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ComparisonChain;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.jdm.Type;
import io.sirix.exception.SirixException;
import io.sirix.index.AtomicUtil;
import io.sirix.utils.LogWrapper;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.LoggerFactory;

public final class CASValue
implements Comparable<CASValue> {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(CASValue.class));
    private final Atomic value;
    private final long pathNodeKey;
    private final Type type;

    public CASValue(Atomic value, Type type, @NonNegative long pathNodeKey) {
        this.value = Objects.requireNonNull(value);
        this.type = Objects.requireNonNull(type);
        this.pathNodeKey = pathNodeKey;
    }

    public byte[] getValue() {
        if (this.value == null || this.type == null) {
            return null;
        }
        byte[] retVal = new byte[1];
        try {
            retVal = AtomicUtil.toBytes(this.value, this.type);
        }
        catch (SirixException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return retVal;
    }

    public Atomic getAtomicValue() {
        if (this.value == null || this.type == null) {
            return null;
        }
        try {
            return this.value;
        }
        catch (QueryException e) {
            LOGGER.error(e.getMessage(), new Object[]{e});
            return null;
        }
    }

    @Override
    public int compareTo(@Nullable CASValue other) {
        if (other == null) {
            return 1;
        }
        Atomic thisAtomic = this.value.asType(this.type);
        Atomic otherAtomic = other.value.asType(other.type);
        return ComparisonChain.start().compare(this.pathNodeKey, other.pathNodeKey).compare((Comparable)thisAtomic, (Comparable)otherAtomic).result();
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.value, this.type, this.pathNodeKey});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof CASValue) {
            CASValue otherValue = (CASValue)obj;
            return com.google.common.base.Objects.equal((Object)otherValue.value, (Object)this.value) && com.google.common.base.Objects.equal((Object)otherValue.type, (Object)this.type) && otherValue.pathNodeKey == this.pathNodeKey;
        }
        return false;
    }

    public long getPathNodeKey() {
        return this.pathNodeKey;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("pathNodeKey", this.pathNodeKey).toString();
    }

    public Type getType() {
        return this.type;
    }
}

