/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io;

import io.sirix.api.PageReadOnlyTrx;
import io.sirix.io.Reader;
import io.sirix.io.bytepipe.ByteHandler;
import io.sirix.page.PagePersister;
import io.sirix.page.PageReference;
import io.sirix.page.SerializationType;
import io.sirix.page.UberPage;
import io.sirix.page.interfaces.Page;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;

public abstract class AbstractReader
implements Reader {
    protected final ByteHandler byteHandler;
    protected final SerializationType type;
    protected final PagePersister pagePersister;

    public AbstractReader(ByteHandler byteHandler, PagePersister pagePersister, SerializationType type) {
        this.byteHandler = byteHandler;
        this.pagePersister = pagePersister;
        this.type = type;
    }

    public Page deserialize(PageReadOnlyTrx pageReadTrx, byte[] page) throws IOException {
        InputStream inputStream = this.byteHandler.deserialize(new ByteArrayInputStream(page));
        return this.pagePersister.deserializePage(pageReadTrx, (BytesIn<?>)Bytes.wrapForRead((byte[])inputStream.readAllBytes()), this.type);
    }

    @Override
    public PageReference readUberPageReference() {
        PageReference uberPageReference = new PageReference();
        uberPageReference.setKey(0L);
        UberPage page = (UberPage)this.read(uberPageReference, null);
        uberPageReference.setPage(page);
        return uberPageReference;
    }

    public ByteHandler getByteHandler() {
        return this.byteHandler;
    }
}

