/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import net.openhft.chronicle.core.OS;

public final class DirectIOUtils {
    public static final int BLOCK_SIZE = OS.pageSize();

    public static ByteBuffer allocate(int size) {
        int n = (size + BLOCK_SIZE - 1) / BLOCK_SIZE + 1;
        return ByteBuffer.allocateDirect(n * BLOCK_SIZE).alignedSlice(BLOCK_SIZE).order(ByteOrder.nativeOrder());
    }

    public static long nearestMultipleOfBlockSize(long size) {
        return size + (long)BLOCK_SIZE - 1L & (long)(-BLOCK_SIZE);
    }

    public static int read(FileChannel channel, ByteBuffer dst, long position) throws IOException {
        int r;
        int lim = dst.limit();
        int len = lim + (r = (int)(position & (long)(BLOCK_SIZE - 1)));
        dst.limit((len & BLOCK_SIZE - 1) == 0 ? len : (len & -BLOCK_SIZE) + BLOCK_SIZE);
        int n = channel.read(dst, position & (long)(-BLOCK_SIZE));
        n -= r;
        n = Math.min(n, lim);
        dst.position(r).limit(r + n);
        if (r != 0) {
            dst.compact();
        }
        dst.position(n).limit(lim);
        return n;
    }
}

