/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io.bytepipe;

import io.sirix.io.bytepipe.ByteHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ByteHandlerPipeline
implements ByteHandler {
    private final List<ByteHandler> byteHandlers;

    public ByteHandlerPipeline(ByteHandlerPipeline pipeline) {
        this.byteHandlers = new ArrayList<ByteHandler>(pipeline.byteHandlers.size());
        for (ByteHandler handler : pipeline.byteHandlers) {
            this.byteHandlers.add(handler.getInstance());
        }
    }

    public ByteHandlerPipeline(ByteHandler ... parts) {
        this.byteHandlers = new ArrayList<ByteHandler>();
        if (parts != null) {
            Collections.addAll(this.byteHandlers, parts);
        }
    }

    @Override
    public OutputStream serialize(OutputStream toSerialize) {
        OutputStream pipeData = toSerialize;
        for (ByteHandler byteHandler : this.byteHandlers) {
            pipeData = byteHandler.serialize(pipeData);
        }
        return pipeData;
    }

    @Override
    public InputStream deserialize(InputStream toDeserialize) {
        InputStream pipeData = toDeserialize;
        for (ByteHandler part : this.byteHandlers) {
            pipeData = part.deserialize(pipeData);
        }
        return pipeData;
    }

    public List<ByteHandler> getComponents() {
        return Collections.unmodifiableList(this.byteHandlers);
    }

    @Override
    public ByteHandler getInstance() {
        return new ByteHandlerPipeline(new ByteHandler[0]);
    }
}

