/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io.directio;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.sun.nio.file.ExtendedOpenOption;
import io.sirix.access.ResourceConfiguration;
import io.sirix.exception.SirixIOException;
import io.sirix.io.IOStorage;
import io.sirix.io.Reader;
import io.sirix.io.RevisionFileData;
import io.sirix.io.Writer;
import io.sirix.io.bytepipe.ByteHandler;
import io.sirix.io.bytepipe.ByteHandlerPipeline;
import io.sirix.io.directio.FileChannelReader;
import io.sirix.io.directio.FileChannelWriter;
import io.sirix.page.PagePersister;
import io.sirix.page.SerializationType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public final class FileChannelStorage
implements IOStorage {
    private static final String FILENAME = "sirix.data";
    private static final String REVISIONS_FILENAME = "sirix.revisions";
    private final Path file;
    private final ByteHandlerPipeline byteHandlerPipeline;
    private FileChannel revisionsOffsetFileChannel;
    private FileChannel dataFileChannel;
    final Semaphore semaphore = new Semaphore(1);
    private final AsyncCache<Integer, RevisionFileData> cache;

    public FileChannelStorage(ResourceConfiguration resourceConfig, AsyncCache<Integer, RevisionFileData> cache) {
        assert (resourceConfig != null) : "resourceConfig must not be null!";
        this.file = resourceConfig.resourcePath;
        this.byteHandlerPipeline = resourceConfig.byteHandlePipeline;
        this.cache = cache;
    }

    @Override
    public Reader createReader() {
        try {
            boolean sempahoreAcquired = this.semaphore.tryAcquire(5L, TimeUnit.SECONDS);
            if (!sempahoreAcquired) {
                throw new IllegalStateException("Couldn't acquire semaphore.");
            }
            Path dataFilePath = this.createDirectoriesAndFile();
            Path revisionsOffsetFilePath = this.getRevisionFilePath();
            this.createRevisionsOffsetFileIfNotExists(revisionsOffsetFilePath);
            this.createRevisionsOffsetFileChannelIfNotInitialized(revisionsOffsetFilePath);
            this.createDataFileChannelIfNotInitialized(dataFilePath);
            FileChannelReader fileChannelReader = new FileChannelReader(this.dataFileChannel, this.revisionsOffsetFileChannel, new ByteHandlerPipeline(this.byteHandlerPipeline), SerializationType.DATA, new PagePersister(), (Cache<Integer, RevisionFileData>)this.cache.synchronous());
            return fileChannelReader;
        }
        catch (IOException | InterruptedException e) {
            throw new SirixIOException(e);
        }
        finally {
            this.semaphore.release();
        }
    }

    private void createDataFileChannelIfNotInitialized(Path dataFilePath) throws IOException {
        if (this.dataFileChannel == null) {
            this.dataFileChannel = FileChannel.open(dataFilePath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SPARSE, StandardOpenOption.CREATE, ExtendedOpenOption.DIRECT);
        }
    }

    private void createRevisionsOffsetFileChannelIfNotInitialized(Path revisionsOffsetFilePath) throws IOException {
        if (this.revisionsOffsetFileChannel == null) {
            this.revisionsOffsetFileChannel = FileChannel.open(revisionsOffsetFilePath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
    }

    private Path createDirectoriesAndFile() throws IOException {
        Path concreteStorage = this.getDataFilePath();
        if (!Files.exists(concreteStorage, new LinkOption[0])) {
            Files.createDirectories(concreteStorage.getParent(), new FileAttribute[0]);
            Files.createFile(concreteStorage, new FileAttribute[0]);
        }
        return concreteStorage;
    }

    @Override
    public Writer createWriter() {
        try {
            boolean sempahoreAcquired = this.semaphore.tryAcquire(5L, TimeUnit.SECONDS);
            if (!sempahoreAcquired) {
                throw new IllegalStateException("Couldn't acquire semaphore.");
            }
            Path dataFilePath = this.createDirectoriesAndFile();
            Path revisionsOffsetFilePath = this.getRevisionFilePath();
            this.createRevisionsOffsetFileIfNotExists(revisionsOffsetFilePath);
            this.createRevisionsOffsetFileChannelIfNotInitialized(revisionsOffsetFilePath);
            this.createDataFileChannelIfNotInitialized(dataFilePath);
            ByteHandlerPipeline byteHandlePipeline = new ByteHandlerPipeline(this.byteHandlerPipeline);
            SerializationType serializationType = SerializationType.DATA;
            PagePersister pagePersister = new PagePersister();
            FileChannelReader reader = new FileChannelReader(this.dataFileChannel, this.revisionsOffsetFileChannel, byteHandlePipeline, serializationType, pagePersister, (Cache<Integer, RevisionFileData>)this.cache.synchronous());
            FileChannelWriter fileChannelWriter = new FileChannelWriter(this.dataFileChannel, this.revisionsOffsetFileChannel, serializationType, pagePersister, this.cache, reader);
            return fileChannelWriter;
        }
        catch (IOException | InterruptedException e) {
            throw new SirixIOException(e);
        }
        finally {
            this.semaphore.release();
        }
    }

    private synchronized void createRevisionsOffsetFileIfNotExists(Path revisionsOffsetFilePath) throws IOException {
        if (!Files.exists(revisionsOffsetFilePath, new LinkOption[0])) {
            Files.createFile(revisionsOffsetFilePath, new FileAttribute[0]);
        }
    }

    @Override
    public void close() {
        try {
            if (this.revisionsOffsetFileChannel != null) {
                this.revisionsOffsetFileChannel.close();
            }
            this.dataFileChannel.close();
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    private Path getDataFilePath() {
        return this.file.resolve(ResourceConfiguration.ResourcePaths.DATA.getPath()).resolve(FILENAME);
    }

    private Path getRevisionFilePath() {
        return this.file.resolve(ResourceConfiguration.ResourcePaths.DATA.getPath()).resolve(REVISIONS_FILENAME);
    }

    @Override
    public boolean exists() {
        Path storage = this.getDataFilePath();
        try {
            return Files.exists(storage, new LinkOption[0]) && Files.size(storage) > 0L;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public ByteHandler getByteHandler() {
        return this.byteHandlerPipeline;
    }
}

