/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io.directio;

import com.github.benmanes.caffeine.cache.AsyncCache;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.exception.SirixIOException;
import io.sirix.io.AbstractForwardingReader;
import io.sirix.io.DirectIOUtils;
import io.sirix.io.Reader;
import io.sirix.io.RevisionFileData;
import io.sirix.io.Writer;
import io.sirix.io.directio.FileChannelReader;
import io.sirix.page.KeyValueLeafPage;
import io.sirix.page.PagePersister;
import io.sirix.page.PageReference;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.SerializationType;
import io.sirix.page.UberPage;
import io.sirix.page.interfaces.Page;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class FileChannelWriter
extends AbstractForwardingReader
implements Writer {
    private final FileChannel dataFileChannel;
    private final FileChannelReader reader;
    private final SerializationType serializationType;
    private final FileChannel revisionsFileChannel;
    private final PagePersister pagePersister;
    private final AsyncCache<Integer, RevisionFileData> cache;
    private boolean isFirstUberPage;
    private final Bytes<ByteBuffer> byteBufferBytes = Bytes.elasticByteBuffer((int)1000);

    public FileChannelWriter(FileChannel dataFileChannel, FileChannel revisionsOffsetFileChannel, SerializationType serializationType, PagePersister pagePersister, AsyncCache<Integer, RevisionFileData> cache, FileChannelReader reader) {
        this.dataFileChannel = dataFileChannel;
        this.serializationType = Objects.requireNonNull(serializationType);
        this.revisionsFileChannel = revisionsOffsetFileChannel;
        this.pagePersister = Objects.requireNonNull(pagePersister);
        this.cache = Objects.requireNonNull(cache);
        this.reader = Objects.requireNonNull(reader);
    }

    @Override
    public Writer truncateTo(PageReadOnlyTrx pageReadOnlyTrx, int revision) {
        try {
            long dataFileRevisionRootPageOffset = ((RevisionFileData)this.cache.get((Object)revision, unused -> this.getRevisionFileData(revision)).get(5L, TimeUnit.SECONDS)).offset();
            ByteBuffer buffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder());
            this.dataFileChannel.read(buffer, dataFileRevisionRootPageOffset);
            buffer.position(0);
            int dataLength = buffer.getInt();
            this.dataFileChannel.truncate(dataFileRevisionRootPageOffset + 4L + (long)dataLength);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    public FileChannelWriter write(PageReadOnlyTrx pageReadOnlyTrx, PageReference pageReference, Bytes<ByteBuffer> bufferedBytes) {
        try {
            long offset = this.getOffset(bufferedBytes);
            return this.writePageReference(pageReadOnlyTrx, pageReference, bufferedBytes, offset);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    private long getOffset(Bytes<ByteBuffer> bufferedBytes) throws IOException {
        long offset;
        long fileSize = this.dataFileChannel.size();
        if (fileSize == 0L) {
            offset = (long)DirectIOUtils.BLOCK_SIZE * 3L;
            offset += bufferedBytes.writePosition();
        } else {
            offset = fileSize + DirectIOUtils.nearestMultipleOfBlockSize(bufferedBytes.writePosition());
        }
        return offset;
    }

    private @NonNull FileChannelWriter writePageReference(PageReadOnlyTrx pageReadOnlyTrx, PageReference pageReference, Bytes<ByteBuffer> bufferedBytes, long offset) {
        try {
            byte[] serializedPage;
            Page page = pageReference.getPage();
            assert (page != null);
            this.pagePersister.serializePage(pageReadOnlyTrx, (BytesOut<?>)this.byteBufferBytes, page, this.serializationType);
            byte[] byteArray = this.byteBufferBytes.toByteArray();
            try (ByteArrayOutputStream output = new ByteArrayOutputStream(byteArray.length);){
                try (DataOutputStream dataOutput = new DataOutputStream(this.reader.getByteHandler().serialize(output));){
                    dataOutput.write(byteArray);
                    dataOutput.flush();
                }
                serializedPage = output.toByteArray();
            }
            this.byteBufferBytes.clear();
            long nearestMultipleOfBlockSize = DirectIOUtils.nearestMultipleOfBlockSize(serializedPage.length);
            long offsetToAdd = nearestMultipleOfBlockSize - (long)serializedPage.length - 4L;
            bufferedBytes.writeInt(serializedPage.length);
            bufferedBytes.write(serializedPage);
            if (offsetToAdd > 0L) {
                byte[] bytesToAdd = new byte[(int)offsetToAdd];
                bufferedBytes.write(bytesToAdd);
            }
            if (bufferedBytes.writePosition() > 64000L) {
                this.flushBuffer(bufferedBytes);
            }
            pageReference.setKey(offset);
            if (page instanceof KeyValueLeafPage) {
                KeyValueLeafPage keyValueLeafPage = (KeyValueLeafPage)page;
                pageReference.setHash(keyValueLeafPage.getHashCode());
            } else {
                pageReference.setHash(this.reader.hashFunction.hashBytes(serializedPage).asBytes());
            }
            if (this.serializationType == SerializationType.DATA) {
                if (page instanceof RevisionRootPage) {
                    RevisionRootPage revisionRootPage = (RevisionRootPage)page;
                    ByteBuffer buffer = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
                    buffer.putLong(offset);
                    buffer.position(8);
                    buffer.putLong(revisionRootPage.getRevisionTimestamp());
                    buffer.position(0);
                    long revisionsFileOffset = revisionRootPage.getRevision() == 0 ? this.revisionsFileChannel.size() + 1024L : this.revisionsFileChannel.size();
                    this.revisionsFileChannel.write(buffer, revisionsFileOffset);
                    long currOffset = offset;
                    this.cache.put((Object)revisionRootPage.getRevision(), CompletableFuture.supplyAsync(() -> new RevisionFileData(currOffset, Instant.ofEpochMilli(revisionRootPage.getRevisionTimestamp()))));
                } else if (page instanceof UberPage && this.isFirstUberPage) {
                    ByteBuffer buffer = ByteBuffer.allocateDirect(512).order(ByteOrder.nativeOrder());
                    buffer.put(serializedPage);
                    buffer.position(0);
                    this.revisionsFileChannel.write(buffer, 0L);
                    buffer.position(0);
                    this.revisionsFileChannel.write(buffer, 512L);
                }
            }
            return this;
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.dataFileChannel != null) {
                this.dataFileChannel.force(true);
            }
            if (this.revisionsFileChannel != null) {
                this.revisionsFileChannel.force(true);
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public Writer writeUberPageReference(PageReadOnlyTrx pageReadOnlyTrx, PageReference pageReference, Bytes<ByteBuffer> bufferedBytes) {
        try {
            if (bufferedBytes.writePosition() > 0L) {
                this.flushBuffer(bufferedBytes);
            }
            this.isFirstUberPage = true;
            this.writePageReference(pageReadOnlyTrx, pageReference, bufferedBytes, DirectIOUtils.BLOCK_SIZE);
            this.isFirstUberPage = false;
            this.writePageReference(pageReadOnlyTrx, pageReference, bufferedBytes, (long)DirectIOUtils.BLOCK_SIZE * 2L);
            ByteBuffer buffer = (ByteBuffer)bufferedBytes.underlyingObject();
            buffer.limit((int)bufferedBytes.readLimit());
            this.dataFileChannel.write(buffer.alignedSlice(DirectIOUtils.BLOCK_SIZE).order(ByteOrder.nativeOrder()), DirectIOUtils.BLOCK_SIZE);
            this.dataFileChannel.force(false);
            bufferedBytes.clear();
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
        return this;
    }

    private void flushBuffer(Bytes<ByteBuffer> bufferedBytes) throws IOException {
        long fileSize = this.dataFileChannel.size();
        long offset = fileSize == 0L ? (long)DirectIOUtils.BLOCK_SIZE * 3L : fileSize;
        ByteBuffer buffer = (ByteBuffer)bufferedBytes.underlyingObject();
        buffer.limit((int)bufferedBytes.readLimit());
        this.dataFileChannel.write(buffer.alignedSlice(DirectIOUtils.BLOCK_SIZE).order(ByteOrder.nativeOrder()), offset);
        this.dataFileChannel.force(false);
        bufferedBytes.clear();
    }

    @Override
    protected Reader delegate() {
        return this.reader;
    }

    @Override
    public Writer truncate() {
        try {
            this.dataFileChannel.truncate(0L);
            if (this.revisionsFileChannel != null) {
                this.revisionsFileChannel.truncate(0L);
            }
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
        return this;
    }
}

