/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io.file;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Cache;
import io.sirix.access.ResourceConfiguration;
import io.sirix.io.IOStorage;
import io.sirix.io.Reader;
import io.sirix.io.RevisionFileData;
import io.sirix.io.Writer;
import io.sirix.io.bytepipe.ByteHandler;
import io.sirix.io.bytepipe.ByteHandlerPipeline;
import io.sirix.io.file.FileReader;
import io.sirix.io.file.FileWriter;
import io.sirix.page.PagePersister;
import io.sirix.page.SerializationType;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class FileStorage
implements IOStorage {
    private static final String FILENAME = "sirix.data";
    private static final String REVISIONS_FILENAME = "sirix.revisions";
    private final Path file;
    private final ByteHandlerPipeline byteHandlerPipeline;
    private final AsyncCache<Integer, RevisionFileData> cache;

    public FileStorage(ResourceConfiguration resourceConfig, AsyncCache<Integer, RevisionFileData> cache) {
        assert (resourceConfig != null) : "resourceConfig must not be null!";
        this.file = resourceConfig.resourcePath;
        this.byteHandlerPipeline = resourceConfig.byteHandlePipeline;
        this.cache = cache;
    }

    @Override
    public Reader createReader() {
        try {
            Path dataFilePath = this.createDirectoriesAndFile();
            Path revisionsOffsetFilePath = this.getRevisionFilePath();
            if (!Files.exists(revisionsOffsetFilePath, new LinkOption[0])) {
                Files.createFile(revisionsOffsetFilePath, new FileAttribute[0]);
            }
            return new FileReader(new RandomAccessFile(dataFilePath.toFile(), "r"), new RandomAccessFile(revisionsOffsetFilePath.toFile(), "r"), new ByteHandlerPipeline(this.byteHandlerPipeline), SerializationType.DATA, new PagePersister(), (Cache<Integer, RevisionFileData>)this.cache.synchronous());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path createDirectoriesAndFile() throws IOException {
        Path concreteStorage = this.getDataFilePath();
        if (!Files.exists(concreteStorage, new LinkOption[0])) {
            Files.createDirectories(concreteStorage.getParent(), new FileAttribute[0]);
            Files.createFile(concreteStorage, new FileAttribute[0]);
        }
        return concreteStorage;
    }

    @Override
    public Writer createWriter() {
        try {
            Path dataFilePath = this.createDirectoriesAndFile();
            Path revisionsOffsetFilePath = this.getRevisionFilePath();
            if (!Files.exists(revisionsOffsetFilePath, new LinkOption[0])) {
                Files.createFile(revisionsOffsetFilePath, new FileAttribute[0]);
            }
            RandomAccessFile randomAccessDataFile = new RandomAccessFile(dataFilePath.toFile(), "rw");
            RandomAccessFile randomAccessRevisionDataFile = new RandomAccessFile(revisionsOffsetFilePath.toFile(), "rw");
            ByteHandlerPipeline byteHandlerPipe = new ByteHandlerPipeline(this.byteHandlerPipeline);
            SerializationType serializationType = SerializationType.DATA;
            PagePersister pagePersister = new PagePersister();
            FileReader reader = new FileReader(randomAccessDataFile, randomAccessRevisionDataFile, byteHandlerPipe, serializationType, pagePersister, (Cache<Integer, RevisionFileData>)this.cache.synchronous());
            return new FileWriter(randomAccessDataFile, randomAccessRevisionDataFile, serializationType, pagePersister, this.cache, reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
    }

    private Path getDataFilePath() {
        return this.file.resolve(ResourceConfiguration.ResourcePaths.DATA.getPath()).resolve(FILENAME);
    }

    private Path getRevisionFilePath() {
        return this.file.resolve(ResourceConfiguration.ResourcePaths.DATA.getPath()).resolve(REVISIONS_FILENAME);
    }

    @Override
    public boolean exists() {
        Path storage = this.getDataFilePath();
        try {
            return Files.exists(storage, new LinkOption[0]) && Files.size(storage) > 0L;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public ByteHandler getByteHandler() {
        return this.byteHandlerPipeline;
    }
}

