/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io.memorymapped;

import com.github.benmanes.caffeine.cache.Cache;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.exception.SirixIOException;
import io.sirix.io.AbstractReader;
import io.sirix.io.RevisionFileData;
import io.sirix.io.bytepipe.ByteHandler;
import io.sirix.page.PagePersister;
import io.sirix.page.PageReference;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.SerializationType;
import io.sirix.page.interfaces.Page;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.time.Instant;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MMFileReader
extends AbstractReader {
    static final ValueLayout.OfByte LAYOUT_BYTE = ValueLayout.JAVA_BYTE;
    static final ValueLayout.OfInt LAYOUT_INT = ValueLayout.JAVA_INT;
    static final ValueLayout.OfLong LAYOUT_LONG = ValueLayout.JAVA_LONG;
    private final MemorySegment dataFileSegment;
    private final MemorySegment revisionsOffsetFileSegment;
    private final Cache<Integer, RevisionFileData> cache;
    private final Arena arena;

    public MMFileReader(MemorySegment dataFileSegment, MemorySegment revisionFileSegment, ByteHandler byteHandler, SerializationType type, PagePersister pagePersistenter, Cache<Integer, RevisionFileData> cache, Arena arena) {
        super(byteHandler, pagePersistenter, type);
        this.dataFileSegment = Objects.requireNonNull(dataFileSegment);
        this.revisionsOffsetFileSegment = Objects.requireNonNull(revisionFileSegment);
        this.cache = Objects.requireNonNull(cache);
        this.arena = Objects.requireNonNull(arena);
    }

    @Override
    public Page read(@NonNull PageReference reference, @Nullable PageReadOnlyTrx pageReadTrx) {
        try {
            long offset = reference.getKey() + LAYOUT_INT.byteSize();
            int dataLength = this.dataFileSegment.get(LAYOUT_INT, reference.getKey());
            byte[] page = new byte[dataLength];
            MemorySegment.copy(this.dataFileSegment, LAYOUT_BYTE, offset, page, 0, dataLength);
            return this.deserialize(pageReadTrx, page);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public RevisionRootPage readRevisionRootPage(int revision, PageReadOnlyTrx pageReadTrx) {
        try {
            long dataFileOffset = ((RevisionFileData)this.cache.get((Object)revision, unused -> this.getRevisionFileData(revision))).offset();
            int dataLength = this.dataFileSegment.get(LAYOUT_INT, dataFileOffset);
            byte[] page = new byte[dataLength];
            MemorySegment.copy(this.dataFileSegment, LAYOUT_BYTE, dataFileOffset + LAYOUT_INT.byteSize(), page, 0, dataLength);
            return (RevisionRootPage)this.deserialize(pageReadTrx, page);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public Instant readRevisionRootPageCommitTimestamp(int revision) {
        return ((RevisionFileData)this.cache.get((Object)revision, unused -> this.getRevisionFileData(revision))).timestamp();
    }

    @Override
    public RevisionFileData getRevisionFileData(int revision) {
        long fileOffset = 1024L + (long)revision * LAYOUT_LONG.byteSize() * 2L;
        long revisionOffset = this.revisionsOffsetFileSegment.get(LAYOUT_LONG, fileOffset);
        Instant timestamp = Instant.ofEpochMilli(this.revisionsOffsetFileSegment.get(LAYOUT_LONG, fileOffset + LAYOUT_LONG.byteSize()));
        return new RevisionFileData(revisionOffset, timestamp);
    }

    @Override
    public void close() {
        this.arena.close();
    }
}

