/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io.memorymapped;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Cache;
import io.sirix.access.ResourceConfiguration;
import io.sirix.exception.SirixIOException;
import io.sirix.io.IOStorage;
import io.sirix.io.Reader;
import io.sirix.io.RevisionFileData;
import io.sirix.io.Writer;
import io.sirix.io.bytepipe.ByteHandler;
import io.sirix.io.bytepipe.ByteHandlerPipeline;
import io.sirix.io.filechannel.FileChannelReader;
import io.sirix.io.filechannel.FileChannelWriter;
import io.sirix.page.PagePersister;
import io.sirix.page.SerializationType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public final class MMStorage
implements IOStorage {
    private static final String FILENAME = "sirix.data";
    private static final String REVISIONS_FILENAME = "sirix.revisions";
    private final ByteHandlerPipeline byteHandlerPipeline;
    final Semaphore semaphore = new Semaphore(1);
    private final AsyncCache<Integer, RevisionFileData> cache;
    private final Path revisionsFilePath;
    private final Path dataFilePath;
    private FileChannel dataFileChannel;
    private FileChannel revisionsOffsetFileChannel;

    public MMStorage(ResourceConfiguration resourceConfig, AsyncCache<Integer, RevisionFileData> cache) {
        assert (resourceConfig != null) : "resourceConfig must not be null!";
        Path file = resourceConfig.resourcePath;
        this.revisionsFilePath = file.resolve(ResourceConfiguration.ResourcePaths.DATA.getPath()).resolve(REVISIONS_FILENAME);
        this.dataFilePath = file.resolve(ResourceConfiguration.ResourcePaths.DATA.getPath()).resolve(FILENAME);
        this.byteHandlerPipeline = resourceConfig.byteHandlePipeline;
        this.cache = cache;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Reader createReader() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createRevisionsOffsetFileIfItDoesNotExist(Path revisionsOffsetFilePath) throws IOException {
        if (!Files.exists(revisionsOffsetFilePath, new LinkOption[0])) {
            Files.createFile(revisionsOffsetFilePath, new FileAttribute[0]);
        }
    }

    private Path createDirectoriesAndFile() throws IOException {
        Path concreteStorage = this.getDataFilePath();
        if (!Files.exists(concreteStorage, new LinkOption[0])) {
            Files.createDirectories(concreteStorage.getParent(), new FileAttribute[0]);
            Files.createFile(concreteStorage, new FileAttribute[0]);
        }
        return concreteStorage;
    }

    @Override
    public synchronized Writer createWriter() {
        try {
            boolean sempahoreAcquired = this.semaphore.tryAcquire(5L, TimeUnit.SECONDS);
            if (!sempahoreAcquired) {
                throw new IllegalStateException("Couldn't acquire semaphore.");
            }
            Path dataFilePath = this.createDirectoriesAndFile();
            Path revisionsOffsetFilePath = this.getRevisionFilePath();
            this.createRevisionsOffsetFileIfItDoesNotExist(revisionsOffsetFilePath);
            this.createDataFileChannelIfNotInitialized(dataFilePath);
            this.createRevisionsOffsetFileChannelIfNotInitialized(revisionsOffsetFilePath);
            ByteHandlerPipeline byteHandlePipeline = new ByteHandlerPipeline(this.byteHandlerPipeline);
            SerializationType serializationType = SerializationType.DATA;
            PagePersister pagePersister = new PagePersister();
            FileChannelReader reader = new FileChannelReader(this.dataFileChannel, this.revisionsOffsetFileChannel, byteHandlePipeline, serializationType, pagePersister, (Cache<Integer, RevisionFileData>)this.cache.synchronous());
            FileChannelWriter fileChannelWriter = new FileChannelWriter(this.dataFileChannel, this.revisionsOffsetFileChannel, serializationType, pagePersister, this.cache, reader);
            return fileChannelWriter;
        }
        catch (IOException | InterruptedException e) {
            throw new SirixIOException(e);
        }
        finally {
            this.semaphore.release();
        }
    }

    private void createDataFileChannelIfNotInitialized(Path dataFilePath) throws IOException {
        if (this.dataFileChannel == null) {
            this.dataFileChannel = FileChannel.open(dataFilePath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SPARSE);
        }
    }

    private void createRevisionsOffsetFileChannelIfNotInitialized(Path revisionsOffsetFilePath) throws IOException {
        if (this.revisionsOffsetFileChannel == null) {
            this.revisionsOffsetFileChannel = FileChannel.open(revisionsOffsetFilePath, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
    }

    @Override
    public void close() {
        try {
            if (this.revisionsOffsetFileChannel != null) {
                this.revisionsOffsetFileChannel.close();
            }
            if (this.dataFileChannel != null) {
                this.dataFileChannel.close();
            }
        }
        catch (IOException e) {
            throw new SirixIOException(e.getMessage(), e);
        }
    }

    private Path getDataFilePath() {
        return this.dataFilePath;
    }

    private Path getRevisionFilePath() {
        return this.revisionsFilePath;
    }

    @Override
    public boolean exists() {
        Path storage = this.getDataFilePath();
        try {
            return Files.exists(storage, new LinkOption[0]) && Files.size(storage) > 0L;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public ByteHandler getByteHandler() {
        return this.byteHandlerPipeline;
    }
}

