/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io.ram;

import io.sirix.access.ResourceConfiguration;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.exception.SirixIOException;
import io.sirix.io.IOStorage;
import io.sirix.io.Reader;
import io.sirix.io.RevisionFileData;
import io.sirix.io.Writer;
import io.sirix.io.bytepipe.ByteHandlerPipeline;
import io.sirix.page.PageReference;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.interfaces.Page;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class RAMStorage
implements IOStorage {
    private final ConcurrentMap<String, ConcurrentMap<Long, Page>> mDataStorage;
    private final ConcurrentMap<String, ConcurrentMap<Integer, RevisionRootPage>> mRevisionRootsStorage;
    private ConcurrentMap<Long, Page> mResourceFileStorage;
    private ConcurrentMap<Integer, RevisionRootPage> mResourceRevisionRootsStorage;
    private final ConcurrentMap<Integer, Long> mUberPageKey;
    private final ByteHandlerPipeline mHandler;
    private final RAMAccess mAccess;
    private boolean mExists;
    private long mPageKey;
    private final ResourceConfiguration mResourceConfiguration;

    public RAMStorage(ResourceConfiguration resourceConfig) {
        this.mResourceConfiguration = resourceConfig;
        this.mDataStorage = new ConcurrentHashMap<String, ConcurrentMap<Long, Page>>();
        this.mRevisionRootsStorage = new ConcurrentHashMap<String, ConcurrentMap<Integer, RevisionRootPage>>();
        this.mHandler = resourceConfig.byteHandlePipeline;
        this.mAccess = new RAMAccess();
        this.mUberPageKey = new ConcurrentHashMap<Integer, Long>();
        this.mUberPageKey.put(-1, 0L);
    }

    @Override
    public Writer createWriter() {
        this.instantiate();
        return this.mAccess;
    }

    private void instantiate() {
        String resource = this.mResourceConfiguration.getResource().getFileName().toString();
        this.mExists = this.mDataStorage.containsKey(resource);
        this.mDataStorage.putIfAbsent(resource, new ConcurrentHashMap());
        this.mResourceFileStorage = (ConcurrentMap)this.mDataStorage.get(resource);
        this.mRevisionRootsStorage.putIfAbsent(resource, new ConcurrentHashMap());
        this.mResourceRevisionRootsStorage = (ConcurrentMap)this.mRevisionRootsStorage.get(resource);
    }

    @Override
    public Reader createReader() {
        this.instantiate();
        return this.mAccess;
    }

    @Override
    public void close() {
    }

    @Override
    public ByteHandlerPipeline getByteHandler() {
        return this.mHandler;
    }

    @Override
    public boolean exists() throws SirixIOException {
        return this.mExists;
    }

    public class RAMAccess
    implements Writer {
        @Override
        public Writer truncate() {
            RAMStorage.this.mUberPageKey.clear();
            RAMStorage.this.mResourceFileStorage.clear();
            RAMStorage.this.mExists = false;
            return this;
        }

        @Override
        public Page read(PageReference reference, @Nullable PageReadOnlyTrx pageReadTrx) {
            return (Page)RAMStorage.this.mResourceFileStorage.get(reference.getKey());
        }

        @Override
        public PageReference readUberPageReference() {
            Page page = (Page)RAMStorage.this.mResourceFileStorage.get(RAMStorage.this.mUberPageKey.get(-1));
            PageReference uberPageReference = new PageReference();
            uberPageReference.setKey(-1L);
            uberPageReference.setPage(page);
            return uberPageReference;
        }

        @Override
        public Writer write(PageReadOnlyTrx pageReadOnlyTrx, PageReference pageReference, Bytes<ByteBuffer> bufferedBytes) {
            Page page = pageReference.getPage();
            pageReference.setKey(RAMStorage.this.mPageKey);
            RAMStorage.this.mResourceFileStorage.put(RAMStorage.this.mPageKey++, page);
            RAMStorage.this.mExists = true;
            return this;
        }

        @Override
        public Writer writeUberPageReference(PageReadOnlyTrx pageReadOnlyTrx, PageReference pageReference, Bytes<ByteBuffer> bufferedBytes) {
            Page page = pageReference.getPage();
            pageReference.setKey(RAMStorage.this.mPageKey);
            RAMStorage.this.mResourceFileStorage.put(RAMStorage.this.mPageKey, page);
            RAMStorage.this.mUberPageKey.put(-1, RAMStorage.this.mPageKey++);
            RAMStorage.this.mExists = true;
            return this;
        }

        @Override
        public Instant readRevisionRootPageCommitTimestamp(int revision) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RevisionFileData getRevisionFileData(int revision) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws SirixIOException {
        }

        @Override
        public Writer truncateTo(PageReadOnlyTrx pageReadOnlyTrx, int revision) {
            return this;
        }

        @Override
        public RevisionRootPage readRevisionRootPage(int revision, PageReadOnlyTrx pageReadTrx) {
            return (RevisionRootPage)RAMStorage.this.mResourceRevisionRootsStorage.get(revision);
        }
    }
}

