/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node;

import com.google.common.base.MoreObjects;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.interfaces.DataRecord;
import java.util.Objects;

public final class HashEntryNode
implements DataRecord {
    private final long nodeKey;
    private final int key;
    private final String value;

    public HashEntryNode(long nodeKey, int key, String value) {
        this.nodeKey = nodeKey;
        this.key = key;
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.HASH_ENTRY;
    }

    public int getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.key, this.value});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HashEntryNode)) {
            return false;
        }
        HashEntryNode other = (HashEntryNode)obj;
        return com.google.common.base.Objects.equal((Object)this.key, (Object)other.key) && com.google.common.base.Objects.equal((Object)this.value, (Object)other.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("value", (Object)this.value).toString();
    }

    @Override
    public long getNodeKey() {
        return this.nodeKey;
    }

    @Override
    public int getLastModifiedRevisionNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPreviousRevisionNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SirixDeweyID getDeweyID() {
        return null;
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return null;
    }
}

