/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.Type;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.trx.node.HashType;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.index.AtomicUtil;
import io.sirix.index.path.summary.PathNode;
import io.sirix.index.redblacktree.RBNodeKey;
import io.sirix.index.redblacktree.RBNodeValue;
import io.sirix.index.redblacktree.keyvalue.CASValue;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import io.sirix.node.DeletedNode;
import io.sirix.node.DeweyIDMappingNode;
import io.sirix.node.DeweyIDNode;
import io.sirix.node.HashCountEntryNode;
import io.sirix.node.HashEntryNode;
import io.sirix.node.RevisionReferencesNode;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.Utils;
import io.sirix.node.delegates.NameNodeDelegate;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.delegates.ValueNodeDelegate;
import io.sirix.node.interfaces.DataRecord;
import io.sirix.node.interfaces.DeweyIdSerializer;
import io.sirix.node.interfaces.StructNode;
import io.sirix.node.json.ArrayNode;
import io.sirix.node.json.BooleanNode;
import io.sirix.node.json.JsonDocumentRootNode;
import io.sirix.node.json.NullNode;
import io.sirix.node.json.NumberNode;
import io.sirix.node.json.ObjectBooleanNode;
import io.sirix.node.json.ObjectKeyNode;
import io.sirix.node.json.ObjectNode;
import io.sirix.node.json.ObjectNullNode;
import io.sirix.node.json.ObjectNumberNode;
import io.sirix.node.json.ObjectStringNode;
import io.sirix.node.json.StringNode;
import io.sirix.node.xml.AttributeNode;
import io.sirix.node.xml.CommentNode;
import io.sirix.node.xml.ElementNode;
import io.sirix.node.xml.NamespaceNode;
import io.sirix.node.xml.PINode;
import io.sirix.node.xml.TextNode;
import io.sirix.node.xml.XmlDocumentRootNode;
import io.sirix.service.xml.xpath.AtomicValue;
import io.sirix.settings.Constants;
import io.sirix.settings.Fixed;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.hashing.LongHashFunction;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.roaringbitmap.longlong.Roaring64Bitmap;

public enum NodeKind implements DeweyIdSerializer
{
    ELEMENT(1, ElementNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = NodeKind.deserializeStructDel(this, nodeDel, source, pageReadTrx.getResourceSession().getResourceConfig());
            long hashCode = NodeKind.getHash(source, pageReadTrx);
            NameNodeDelegate nameDel = NodeKind.deserializeNameDelegate(nodeDel, source);
            int attrCount = source.readInt();
            LongArrayList attrKeys = new LongArrayList(attrCount);
            for (int i = 0; i < attrCount; ++i) {
                long nodeKey = source.readLong();
                attrKeys.add(nodeKey);
            }
            int nsCount = source.readInt();
            LongArrayList namespaceKeys = new LongArrayList(nsCount);
            for (int i = 0; i < nsCount; ++i) {
                namespaceKeys.add(source.readLong());
            }
            return new ElementNode(hashCode, structDel, nameDel, (LongList)attrKeys, (LongList)namespaceKeys, new QNm(""));
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            int i;
            ElementNode node = (ElementNode)record;
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeStructDelegate(this, node.getStructNodeDelegate(), sink, pageReadTrx.getResourceSession().getResourceConfig());
            if (pageReadTrx.getResourceSession().getResourceConfig().hashType != HashType.NONE) {
                NodeKind.writeHash(sink, node.getHash());
            }
            NodeKind.serializeNameDelegate(node.getNameNodeDelegate(), sink);
            sink.writeInt(node.getAttributeCount());
            int attCount = node.getAttributeCount();
            for (i = 0; i < attCount; ++i) {
                long key = node.getAttributeKey(i);
                sink.writeLong(key);
            }
            sink.writeInt(node.getNamespaceCount());
            int nspCount = node.getNamespaceCount();
            for (i = 0; i < nspCount; ++i) {
                sink.writeLong(node.getNamespaceKey(i));
            }
        }
    }
    ,
    ATTRIBUTE(2, AttributeNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            NameNodeDelegate nameDel = NodeKind.deserializeNameDelegate(nodeDel, source);
            boolean isCompressed = source.readByte() == 1;
            byte[] vals = new byte[source.readInt()];
            source.read(vals, 0, vals.length);
            ValueNodeDelegate valDel = new ValueNodeDelegate(nodeDel, vals, isCompressed);
            return new AttributeNode(nodeDel, nameDel, valDel, new QNm(""));
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            AttributeNode node = (AttributeNode)record;
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeNameDelegate(node.getNameNodeDelegate(), sink);
            NodeKind.serializeValDelegate(node.getValNodeDelegate(), sink);
        }
    }
    ,
    NAMESPACE(13, NamespaceNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            NameNodeDelegate nameDel = NodeKind.deserializeNameDelegate(nodeDel, source);
            return new NamespaceNode(nodeDel, nameDel, null);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            NamespaceNode node = (NamespaceNode)record;
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeNameDelegate(node.getNameNodeDelegate(), sink);
        }
    }
    ,
    TEXT(3, TextNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            boolean isCompressed = source.readByte() == 1;
            byte[] vals = new byte[source.readInt()];
            source.read(vals, 0, vals.length);
            ValueNodeDelegate valDel = new ValueNodeDelegate(nodeDel, vals, isCompressed);
            long nodeKey = nodeDel.getNodeKey();
            StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), nodeKey - Utils.getVarLong(source), nodeKey - Utils.getVarLong(source), 0L, 0L);
            return new TextNode(valDel, structDel);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            TextNode node = (TextNode)record;
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeValDelegate(node.getValNodeDelegate(), sink);
            StructNodeDelegate del = node.getStructNodeDelegate();
            long nodeKey = node.getNodeKey();
            Utils.putVarLong(sink, nodeKey - del.getRightSiblingKey());
            Utils.putVarLong(sink, nodeKey - del.getLeftSiblingKey());
        }
    }
    ,
    PROCESSING_INSTRUCTION(7, PINode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = NodeKind.deserializeStructDel(this, nodeDel, source, pageReadTrx.getResourceSession().getResourceConfig());
            NameNodeDelegate nameDel = NodeKind.deserializeNameDelegate(nodeDel, source);
            boolean isCompressed = source.readByte() == 1;
            byte[] vals = new byte[source.readInt()];
            source.read(vals, 0, vals.length);
            ValueNodeDelegate valDel = new ValueNodeDelegate(nodeDel, vals, isCompressed);
            return new PINode(structDel, nameDel, valDel, pageReadTrx);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            PINode node = (PINode)record;
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeStructDelegate(this, node.getStructNodeDelegate(), sink, pageReadTrx.getResourceSession().getResourceConfig());
            NodeKind.serializeNameDelegate(node.getNameNodeDelegate(), sink);
            NodeKind.serializeValDelegate(node.getValNodeDelegate(), sink);
        }
    }
    ,
    COMMENT(8, CommentNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            boolean isCompressed = source.readByte() == 1;
            byte[] vals = new byte[source.readInt()];
            source.read(vals, 0, vals.length);
            ValueNodeDelegate valDel = new ValueNodeDelegate(nodeDel, vals, isCompressed);
            long nodeKey = nodeDel.getNodeKey();
            StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), nodeKey - Utils.getVarLong(source), nodeKey - Utils.getVarLong(source), 0L, 0L);
            return new CommentNode(valDel, structDel);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            CommentNode node = (CommentNode)record;
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeValDelegate(node.getValNodeDelegate(), sink);
            StructNodeDelegate del = node.getStructNodeDelegate();
            long nodeKey = node.getNodeKey();
            Utils.putVarLong(sink, nodeKey - del.getRightSiblingKey());
            Utils.putVarLong(sink, nodeKey - del.getLeftSiblingKey());
        }
    }
    ,
    XML_DOCUMENT(9, XmlDocumentRootNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            int revisionNumber = pageReadTrx.getRevisionNumber();
            LongHashFunction hashFunction = pageReadTrx.getResourceSession().getResourceConfig().nodeHashFunction;
            NodeDelegate nodeDel = new NodeDelegate(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), hashFunction, -1, revisionNumber, SirixDeweyID.newRootID().toBytes());
            StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Utils.getVarLong(source), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), source.readByte() == 0 ? 0L : 1L, pageReadTrx.getResourceSession().getResourceConfig().hashType == HashType.NONE ? 0L : source.readLong());
            return new XmlDocumentRootNode(nodeDel, structDel);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            XmlDocumentRootNode node = (XmlDocumentRootNode)record;
            Utils.putVarLong(sink, node.getFirstChildKey());
            sink.writeByte(node.hasFirstChild() ? (byte)1 : 0);
            if (pageReadTrx.getResourceSession().getResourceConfig().hashType != HashType.NONE) {
                sink.writeLong(node.getDescendantCount());
            }
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            return null;
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
        }
    }
    ,
    WHITESPACE(4, null){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            return null;
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
        }
    }
    ,
    DELETE(5, DeletedNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            int revisionNumber = pageReadTrx.getRevisionNumber();
            LongHashFunction hashFunction = pageReadTrx.getResourceSession().getResourceConfig().nodeHashFunction;
            NodeDelegate delegate = new NodeDelegate(recordID, 0L, hashFunction, 0, revisionNumber, (SirixDeweyID)null);
            return new DeletedNode(delegate);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            return null;
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
        }
    }
    ,
    NULL(6, NullNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            return null;
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
        }
    }
    ,
    DUMB(20, DumbNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            return new DumbNode(recordID);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    ATOMIC(15, AtomicValue.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    PATH(16, PathNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegateWithoutIDs(source, recordID, pageReadTrx);
            StructNodeDelegate structDel = NodeKind.deserializeStructDel(this, nodeDel, source, pageReadTrx.getResourceSession().getResourceConfig());
            NameNodeDelegate nameDel = NodeKind.deserializeNameDelegate(nodeDel, source);
            NodeKind kind = NodeKind.getKind(source.readByte());
            return new PathNode(null, nodeDel, structDel, nameDel, kind, source.readInt(), source.readInt());
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            PathNode node = (PathNode)record;
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeStructDelegate(this, node.getStructNodeDelegate(), sink, pageReadTrx.getResourceSession().getResourceConfig());
            NodeKind.serializeNameDelegate(node.getNameNodeDelegate(), sink);
            sink.writeByte(node.getPathKind().getId());
            sink.writeInt(node.getReferences());
            sink.writeInt(node.getLevel());
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    CASRB(17, RBNodeKey.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            int valueSize = source.readInt();
            byte[] value = new byte[valueSize];
            source.read(value, 0, valueSize);
            int typeSize = source.readInt();
            byte[] type = new byte[typeSize];
            source.read(type, 0, typeSize);
            Type atomicType = this.resolveType(new String(type, Constants.DEFAULT_ENCODING));
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegateWithoutIDs(source, recordID, pageReadTrx);
            long leftChild = Utils.getVarLong(source);
            long rightChild = Utils.getVarLong(source);
            long pathNodeKey = Utils.getVarLong(source);
            boolean isChanged = source.readBoolean();
            long valueNodeKey = source.readLong();
            Atomic atomic = AtomicUtil.fromBytes(value, atomicType);
            RBNodeKey<CASValue> node = new RBNodeKey<CASValue>(new CASValue(atomic, atomicType, pathNodeKey), valueNodeKey, nodeDel);
            node.setLeftChildKey(leftChild);
            node.setRightChildKey(rightChild);
            node.setChanged(isChanged);
            return node;
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            RBNodeKey node = (RBNodeKey)record;
            CASValue key = (CASValue)node.getKey();
            byte[] textValue = key.getValue();
            assert (textValue != null);
            sink.writeInt(textValue.length);
            sink.write(textValue);
            byte[] type = key.getType().toString().getBytes(Constants.DEFAULT_ENCODING);
            sink.writeInt(type.length);
            sink.write(type);
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            Utils.putVarLong(sink, node.getLeftChildKey());
            Utils.putVarLong(sink, node.getRightChildKey());
            Utils.putVarLong(sink, key.getPathNodeKey());
            sink.writeBoolean(node.isChanged());
            sink.writeLong(node.getValueNodeKey());
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        private Type resolveType(String s) {
            QNm name = new QNm("http://www.w3.org/2001/XMLSchema", "xs", s.substring("xs".length() + 1));
            for (Type type : Type.builtInTypes) {
                if (!type.getName().getLocalName().equals(name.getLocalName())) continue;
                return type;
            }
            throw new IllegalStateException("Unknown content type: " + String.valueOf(name));
        }
    }
    ,
    PATHRB(18, RBNodeKey.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            long key = Utils.getVarLong(source);
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegateWithoutIDs(source, recordID, pageReadTrx);
            long leftChild = Utils.getVarLong(source);
            long rightChild = Utils.getVarLong(source);
            boolean isChanged = source.readBoolean();
            long valueNodeKey = source.readLong();
            RBNodeKey<Long> node = new RBNodeKey<Long>(key, valueNodeKey, nodeDel);
            node.setLeftChildKey(leftChild);
            node.setRightChildKey(rightChild);
            node.setChanged(isChanged);
            return node;
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            RBNodeKey node = (RBNodeKey)record;
            Utils.putVarLong(sink, (Long)node.getKey());
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            Utils.putVarLong(sink, node.getLeftChildKey());
            Utils.putVarLong(sink, node.getRightChildKey());
            sink.writeBoolean(node.isChanged());
            sink.writeLong(node.getValueNodeKey());
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    NAMERB(19, RBNodeKey.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            byte[] nspBytes = new byte[source.readInt()];
            source.read(nspBytes);
            byte[] prefixBytes = new byte[source.readInt()];
            source.read(prefixBytes);
            byte[] localNameBytes = new byte[source.readInt()];
            source.read(localNameBytes);
            QNm name = new QNm(new String(nspBytes, Constants.DEFAULT_ENCODING), new String(prefixBytes, Constants.DEFAULT_ENCODING), new String(localNameBytes, Constants.DEFAULT_ENCODING));
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegateWithoutIDs(source, recordID, pageReadTrx);
            long leftChild = Utils.getVarLong(source);
            long rightChild = Utils.getVarLong(source);
            boolean isChanged = source.readBoolean();
            long valueNodeKey = source.readLong();
            RBNodeKey<QNm> node = new RBNodeKey<QNm>(name, valueNodeKey, nodeDel);
            node.setLeftChildKey(leftChild);
            node.setRightChildKey(rightChild);
            node.setChanged(isChanged);
            return node;
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            RBNodeKey node = (RBNodeKey)record;
            byte[] nspBytes = ((QNm)node.getKey()).getNamespaceURI().getBytes();
            sink.writeInt(nspBytes.length);
            sink.write(nspBytes);
            byte[] prefixBytes = ((QNm)node.getKey()).getPrefix().getBytes();
            sink.writeInt(prefixBytes.length);
            sink.write(prefixBytes);
            byte[] localNameBytes = ((QNm)node.getKey()).getLocalName().getBytes();
            sink.writeInt(localNameBytes.length);
            sink.write(localNameBytes);
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            Utils.putVarLong(sink, node.getLeftChildKey());
            Utils.putVarLong(sink, node.getRightChildKey());
            sink.writeBoolean(node.isChanged());
            sink.writeLong(node.getValueNodeKey());
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    RB_NODE_VALUE(55, RBNodeValue.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            Roaring64Bitmap nodeKeys = NodeKind.deserializeNodeReferences(source);
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegateWithoutIDs(source, recordID, pageReadTrx);
            return new RBNodeValue<NodeReferences>(new NodeReferences(nodeKeys), nodeDel);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            RBNodeValue node = (RBNodeValue)record;
            NodeReferences value = (NodeReferences)node.getValue();
            Roaring64Bitmap nodeKeys = value.getNodeKeys();
            NodeKind.serializeNodeReferences(sink, nodeKeys);
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    DEWEYIDMAPPING(23, DeweyIDMappingNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    OBJECT(24, ObjectNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            ResourceConfiguration config = pageReadTrx.getResourceSession().getResourceConfig();
            long hashCode = NodeKind.getHash(source, pageReadTrx);
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = NodeKind.deserializeObjectOrArrayStructDelegate(source, config, nodeDel);
            return new ObjectNode(hashCode, structDel);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            ObjectNode node = (ObjectNode)record;
            ResourceConfiguration config = pageReadTrx.getResourceSession().getResourceConfig();
            if (config.hashType != HashType.NONE) {
                NodeKind.writeHash(sink, node.getHash());
            }
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeJsonObjectOrArrayStructDelegate(sink, node, config);
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    ARRAY(25, ArrayNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            ResourceConfiguration config = pageReadTrx.getResourceSession().getResourceConfig();
            long hashCode = NodeKind.getHash(source, pageReadTrx);
            long pathNodeKey = source.readLong();
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = NodeKind.deserializeObjectOrArrayStructDelegate(source, config, nodeDel);
            return new ArrayNode(hashCode, structDel, pathNodeKey);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            ArrayNode node = (ArrayNode)record;
            ResourceConfiguration config = pageReadTrx.getResourceSession().getResourceConfig();
            if (config.hashType != HashType.NONE) {
                NodeKind.writeHash(sink, node.getHash());
            }
            sink.writeLong(node.getPathNodeKey());
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeJsonObjectOrArrayStructDelegate(sink, node, config);
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    OBJECT_KEY(26, ObjectKeyNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            long hashCode = NodeKind.getHash(source, pageReadTrx);
            int nameKey = source.readInt();
            long pathNodeKey = Utils.getVarLong(source);
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            long currKey = nodeDel.getNodeKey();
            long rightSibling = currKey - Utils.getVarLong(source);
            long leftSibling = currKey - Utils.getVarLong(source);
            long firstChild = currKey - Utils.getVarLong(source);
            ResourceConfiguration config = pageReadTrx.getResourceSession().getResourceConfig();
            long descendantCount = config.hashType == HashType.NONE ? 0L : Utils.getVarLong(source) + 1L;
            StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, firstChild, rightSibling, leftSibling, config.storeChildCount() ? 1L : 0L, descendantCount);
            String name = nameKey == -1 ? "" : pageReadTrx.getName(nameKey, OBJECT_KEY);
            return new ObjectKeyNode(hashCode, structDel, nameKey, name, pathNodeKey);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            ObjectKeyNode node = (ObjectKeyNode)record;
            ResourceConfiguration config = pageReadTrx.getResourceSession().getResourceConfig();
            if (config.hashType != HashType.NONE) {
                NodeKind.writeHash(sink, node.getHash());
            }
            sink.writeInt(node.getNameKey());
            Utils.putVarLong(sink, node.getPathNodeKey());
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            long nodeKey = node.getNodeKey();
            Utils.putVarLong(sink, nodeKey - node.getRightSiblingKey());
            Utils.putVarLong(sink, nodeKey - node.getLeftSiblingKey());
            Utils.putVarLong(sink, nodeKey - node.getFirstChildKey());
            if (config.hashType != HashType.NONE) {
                Utils.putVarLong(sink, node.getDescendantCount() - node.getChildCount());
            }
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    OBJECT_STRING_VALUE(40, ObjectStringNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            boolean isCompressed = source.readByte() == 1;
            byte[] vals = new byte[source.readInt()];
            source.read(vals, 0, vals.length);
            ValueNodeDelegate valDel = new ValueNodeDelegate(nodeDel, vals, isCompressed);
            StructNodeDelegate structDelegate = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, 0L);
            return new ObjectStringNode(valDel, structDelegate);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            ObjectStringNode node = (ObjectStringNode)record;
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeValDelegate(node.getValNodeDelegate(), sink);
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    OBJECT_BOOLEAN_VALUE(41, ObjectBooleanNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            boolean boolValue = source.readBoolean();
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDelegate = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, 0L);
            return new ObjectBooleanNode(boolValue, structDelegate);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            ObjectBooleanNode node = (ObjectBooleanNode)record;
            sink.writeBoolean(node.getValue());
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    OBJECT_NUMBER_VALUE(42, ObjectNumberNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            byte valueType = source.readByte();
            Number number = switch (valueType) {
                case 0 -> Double.valueOf(source.readDouble());
                case 1 -> Float.valueOf(source.readFloat());
                case 2 -> Integer.valueOf(source.readInt());
                case 3 -> Long.valueOf(source.readLong());
                case 4 -> NodeKind.deserializeBigInteger(source);
                case 5 -> {
                    BigInteger bigInt = NodeKind.deserializeBigInteger(source);
                    int scale = source.readInt();
                    yield new BigDecimal(bigInt, scale);
                }
                default -> throw new AssertionError((Object)"Type not known.");
            };
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDelegate = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, 0L);
            return new ObjectNumberNode(number, structDelegate);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            Number number;
            ObjectNumberNode node = (ObjectNumberNode)record;
            Number number2 = number = node.getValue();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class, Float.class, Integer.class, Long.class, BigInteger.class, BigDecimal.class}, (Object)number2, n)) {
                case 0: {
                    Double ignored = (Double)number2;
                    sink.writeByte((byte)0);
                    sink.writeDouble(number.doubleValue());
                    break;
                }
                case 1: {
                    Float ignored = (Float)number2;
                    sink.writeByte((byte)1);
                    sink.writeFloat(number.floatValue());
                    break;
                }
                case 2: {
                    Integer ignored = (Integer)number2;
                    sink.writeByte((byte)2);
                    sink.writeInt(number.intValue());
                    break;
                }
                case 3: {
                    Long ignored = (Long)number2;
                    sink.writeByte((byte)3);
                    sink.writeLong(number.longValue());
                    break;
                }
                case 4: {
                    BigInteger bigInt = (BigInteger)number2;
                    sink.writeByte((byte)4);
                    sink.writeBigInteger(bigInt);
                    break;
                }
                case 5: {
                    BigDecimal value = (BigDecimal)number2;
                    sink.writeByte((byte)5);
                    BigInteger bigInt = value.unscaledValue();
                    int scale = value.scale();
                    sink.writeBigInteger(bigInt);
                    sink.writeInt(scale);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Type not known.");
                }
            }
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    OBJECT_NULL_VALUE(43, ObjectNullNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDelegate = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, 0L);
            return new ObjectNullNode(structDelegate);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            ObjectNullNode node = (ObjectNullNode)record;
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    STRING_VALUE(30, StringNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            boolean isCompressed = source.readByte() == 1;
            byte[] vals = new byte[source.readInt()];
            source.read(vals, 0, vals.length);
            ValueNodeDelegate valDel = new ValueNodeDelegate(nodeDel, vals, isCompressed);
            StructNodeDelegate structDel = NodeKind.deserializeStructNodeJsonValueNode(source, nodeDel);
            return new StringNode(valDel, structDel);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            StringNode node = (StringNode)record;
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeValDelegate(node.getValNodeDelegate(), sink);
            NodeKind.serializeStructNodeJsonValueNode(sink, node);
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    BOOLEAN_VALUE(27, BooleanNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            boolean boolValue = source.readBoolean();
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = NodeKind.deserializeStructNodeJsonValueNode(source, nodeDel);
            return new BooleanNode(boolValue, structDel);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            BooleanNode node = (BooleanNode)record;
            sink.writeBoolean(node.getValue());
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeStructNodeJsonValueNode(sink, node);
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    NUMBER_VALUE(28, NumberNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            byte valueType = source.readByte();
            Number number = switch (valueType) {
                case 0 -> Double.valueOf(source.readDouble());
                case 1 -> Float.valueOf(source.readFloat());
                case 2 -> Integer.valueOf(source.readInt());
                case 3 -> Long.valueOf(source.readLong());
                case 4 -> NodeKind.deserializeBigInteger(source);
                case 5 -> {
                    BigInteger bigInt = NodeKind.deserializeBigInteger(source);
                    int scale = source.readInt();
                    yield new BigDecimal(bigInt, scale);
                }
                default -> throw new AssertionError((Object)"Type not known.");
            };
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = NodeKind.deserializeStructNodeJsonValueNode(source, nodeDel);
            return new NumberNode(number, structDel);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            Number number;
            NumberNode node = (NumberNode)record;
            Number number2 = number = node.getValue();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class, Float.class, Integer.class, Long.class, BigInteger.class, BigDecimal.class}, (Object)number2, n)) {
                case 0: {
                    Double ignored = (Double)number2;
                    sink.writeByte((byte)0);
                    sink.writeDouble(number.doubleValue());
                    break;
                }
                case 1: {
                    Float ignored1 = (Float)number2;
                    sink.writeByte((byte)1);
                    sink.writeFloat(number.floatValue());
                    break;
                }
                case 2: {
                    Integer ignored2 = (Integer)number2;
                    sink.writeByte((byte)2);
                    sink.writeInt(number.intValue());
                    break;
                }
                case 3: {
                    Long ignored3 = (Long)number2;
                    sink.writeByte((byte)3);
                    sink.writeLong(number.longValue());
                    break;
                }
                case 4: {
                    BigInteger bigInteger = (BigInteger)number2;
                    sink.writeByte((byte)4);
                    NodeKind.serializeBigInteger(sink, bigInteger);
                    break;
                }
                case 5: {
                    BigDecimal value = (BigDecimal)number2;
                    sink.writeByte((byte)5);
                    BigInteger bigInt = value.unscaledValue();
                    int scale = value.scale();
                    NodeKind.serializeBigInteger(sink, bigInt);
                    sink.writeInt(scale);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Type not known.");
                }
            }
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeStructNodeJsonValueNode(sink, node);
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    NULL_VALUE(29, NullNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            NodeDelegate nodeDel = NodeKind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = NodeKind.deserializeStructNodeJsonValueNode(source, nodeDel);
            return new NullNode(structDel);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            NullNode node = (NullNode)record;
            NodeKind.serializeDelegate(node.getNodeDelegate(), sink);
            NodeKind.serializeStructNodeJsonValueNode(sink, node);
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    JSON_DOCUMENT(31, JsonDocumentRootNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            int revisionNumber = pageReadTrx.getRevisionNumber();
            LongHashFunction hashFunction = pageReadTrx.getResourceSession().getResourceConfig().nodeHashFunction;
            NodeDelegate nodeDel = new NodeDelegate(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), hashFunction, -1, revisionNumber, SirixDeweyID.newRootID().toBytes());
            long firstChildKey = Utils.getVarLong(source);
            StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, firstChildKey, firstChildKey, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), firstChildKey == Fixed.NULL_NODE_KEY.getStandardProperty() ? 0L : 1L, source.readLong());
            return new JsonDocumentRootNode(nodeDel, structDel);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            JsonDocumentRootNode node = (JsonDocumentRootNode)record;
            Utils.putVarLong(sink, node.getFirstChildKey());
            sink.writeLong(node.getDescendantCount());
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            return null;
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
        }
    }
    ,
    HASH_ENTRY(32, HashEntryNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            return new HashEntryNode(recordID, source.readInt(), source.readUtf8());
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            HashEntryNode node = (HashEntryNode)record;
            sink.writeInt(node.getKey());
            sink.writeUtf8(node.getValue());
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            return null;
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
        }
    }
    ,
    HASH_NAME_COUNT_TO_NAME_ENTRY(33, HashCountEntryNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            return new HashCountEntryNode(recordID, source.readInt());
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            HashCountEntryNode node = (HashCountEntryNode)record;
            sink.writeInt(node.getValue());
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            return null;
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
        }
    }
    ,
    DEWEY_ID_NODE(34, DeweyIDNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            return new DeweyIDNode(recordID, new SirixDeweyID(deweyID));
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            return null;
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
        }
    }
    ,
    REVISION_REFERENCES_NODE(35, RevisionReferencesNode.class){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            boolean isCompressed = source.readBoolean();
            int length = source.readByte();
            int[] revisions = new int[length];
            for (int i = 0; i < length; ++i) {
                revisions[i] = source.readInt();
            }
            int[] uncompressedRevisions = isCompressed ? INTEGRATED_INT_COMPRESSOR.uncompress(revisions) : revisions;
            return new RevisionReferencesNode(recordID, uncompressedRevisions);
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            int[] compressedRevisions;
            RevisionReferencesNode revisionRefNode = (RevisionReferencesNode)record;
            int[] revisions = revisionRefNode.getRevisions();
            if (revisions.length > 10) {
                compressedRevisions = INTEGRATED_INT_COMPRESSOR.compress(revisions);
                sink.writeBoolean(true);
            } else {
                compressedRevisions = revisions;
                sink.writeBoolean(false);
            }
            sink.writeByte((byte)compressedRevisions.length);
            for (int compressedRevision : compressedRevisions) {
                sink.writeInt(compressedRevision);
            }
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            return null;
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
        }
    }
    ,
    UNKNOWN(22, null){

        @Override
        public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
            throw new UnsupportedOperationException();
        }
    };

    private final byte id;
    private final Class<? extends DataRecord> clazz;
    private static final Map<Byte, NodeKind> INSTANCEFORID;
    private static final Map<Class<? extends DataRecord>, NodeKind> INSTANCEFORCLASS;

    private static void serializeNodeReferences(BytesOut<ByteBuffer> sink, Roaring64Bitmap nodeKeys) {
        try (DataOutputStream outputStream = new DataOutputStream(sink.outputStream());){
            nodeKeys.serialize((DataOutput)outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    private static @NonNull Roaring64Bitmap deserializeNodeReferences(BytesIn<?> source) {
        Roaring64Bitmap nodeKeys = new Roaring64Bitmap();
        try (DataInputStream inputStream = new DataInputStream(source.inputStream());){
            nodeKeys.deserialize((DataInput)inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
        return nodeKeys;
    }

    private NodeKind(byte id, Class<? extends DataRecord> clazz) {
        this.id = id;
        this.clazz = clazz;
    }

    public byte getId() {
        return this.id;
    }

    public static NodeKind getKind(byte id) {
        return INSTANCEFORID.get(id);
    }

    public static NodeKind getKind(Class<? extends DataRecord> clazz) {
        return INSTANCEFORCLASS.get(clazz);
    }

    @Override
    public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
        return null;
    }

    @Override
    public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
    }

    private static long getHash(BytesIn<?> source, PageReadOnlyTrx pageReadTrx) {
        long hashCode = pageReadTrx.getResourceSession().getResourceConfig().hashType == HashType.NONE ? 0L : source.readLong();
        return hashCode;
    }

    private static void serializeStructNodeJsonValueNode(BytesOut<ByteBuffer> sink, StructNode node) {
        Utils.putVarLong(sink, node.getNodeKey() - node.getRightSiblingKey());
        Utils.putVarLong(sink, node.getNodeKey() - node.getLeftSiblingKey());
    }

    private static @NonNull StructNodeDelegate deserializeStructNodeJsonValueNode(BytesIn<?> source, NodeDelegate nodeDel) {
        long nodeKey = nodeDel.getNodeKey();
        long rightSibling = nodeKey - Utils.getVarLong(source);
        long leftSibling = nodeKey - Utils.getVarLong(source);
        long firstChild = Fixed.NULL_NODE_KEY.getStandardProperty();
        long lastChild = Fixed.NULL_NODE_KEY.getStandardProperty();
        long childCount = 0L;
        long descendantCount = 0L;
        return new StructNodeDelegate(nodeDel, firstChild, lastChild, rightSibling, leftSibling, 0L, 0L);
    }

    private static @NonNull StructNodeDelegate deserializeObjectOrArrayStructDelegate(BytesIn<?> source, ResourceConfiguration config, NodeDelegate nodeDel) {
        long nodeKey = nodeDel.getNodeKey();
        long rightSibling = nodeKey - Utils.getVarLong(source);
        long leftSibling = nodeKey - Utils.getVarLong(source);
        long firstChild = nodeKey - Utils.getVarLong(source);
        long lastChild = nodeKey - Utils.getVarLong(source);
        long childCount = !config.storeChildCount() ? 0L : nodeKey - Utils.getVarLong(source);
        long descendantCount = config.hashType == HashType.NONE ? 0L : Utils.getVarLong(source) + childCount;
        return new StructNodeDelegate(nodeDel, firstChild, lastChild, rightSibling, leftSibling, childCount, descendantCount);
    }

    private static void serializeJsonObjectOrArrayStructDelegate(BytesOut<ByteBuffer> sink, StructNode node, ResourceConfiguration config) {
        boolean storeChildCount = config.storeChildCount();
        Utils.putVarLong(sink, node.getNodeKey() - node.getRightSiblingKey());
        Utils.putVarLong(sink, node.getNodeKey() - node.getLeftSiblingKey());
        Utils.putVarLong(sink, node.getNodeKey() - node.getFirstChildKey());
        Utils.putVarLong(sink, node.getNodeKey() - node.getLastChildKey());
        if (storeChildCount) {
            Utils.putVarLong(sink, node.getNodeKey() - node.getChildCount());
        }
        if (config.hashType != HashType.NONE) {
            Utils.putVarLong(sink, node.getDescendantCount() - node.getChildCount());
        }
    }

    private static NodeDelegate deserializeNodeDelegateWithoutIDs(BytesIn<?> source, @NonNegative long recordID, PageReadOnlyTrx pageReadTrx) {
        long parentKey = recordID - Utils.getVarLong(source);
        int previousRevision = source.readInt();
        int lastModifiedRevision = source.readInt();
        LongHashFunction hashFunction = pageReadTrx.getResourceSession().getResourceConfig().nodeHashFunction;
        return new NodeDelegate(recordID, parentKey, hashFunction, previousRevision, lastModifiedRevision, (SirixDeweyID)null);
    }

    private static NodeDelegate deserializeNodeDelegate(BytesIn<?> source, @NonNegative long recordID, byte[] id, PageReadOnlyTrx pageReadTrx) {
        long parentKey = recordID - Utils.getVarLong(source);
        int previousRevision = source.readInt();
        int lastModifiedRevision = source.readInt();
        LongHashFunction hashFunction = pageReadTrx.getResourceSession().getResourceConfig().nodeHashFunction;
        return new NodeDelegate(recordID, parentKey, hashFunction, previousRevision, lastModifiedRevision, id);
    }

    private static void serializeDelegate(NodeDelegate nodeDel, BytesOut<ByteBuffer> sink) {
        Utils.putVarLong(sink, nodeDel.getNodeKey() - nodeDel.getParentKey());
        sink.writeInt(nodeDel.getPreviousRevisionNumber());
        sink.writeInt(nodeDel.getLastModifiedRevisionNumber());
    }

    private static void serializeStructDelegate(NodeKind kind, StructNodeDelegate nodeDel, BytesOut<ByteBuffer> sink, ResourceConfiguration config) {
        boolean isValueNode = kind == NUMBER_VALUE || kind == STRING_VALUE || kind == BOOLEAN_VALUE || kind == NULL_VALUE;
        boolean storeChildCount = config.storeChildCount();
        Utils.putVarLong(sink, nodeDel.getNodeKey() - nodeDel.getRightSiblingKey());
        Utils.putVarLong(sink, nodeDel.getNodeKey() - nodeDel.getLeftSiblingKey());
        if (!isValueNode) {
            Utils.putVarLong(sink, nodeDel.getNodeKey() - nodeDel.getFirstChildKey());
            Utils.putVarLong(sink, nodeDel.getNodeKey() - nodeDel.getLastChildKey());
            if (storeChildCount) {
                Utils.putVarLong(sink, nodeDel.getNodeKey() - nodeDel.getChildCount());
            }
            if (config.hashType != HashType.NONE) {
                Utils.putVarLong(sink, nodeDel.getDescendantCount() - nodeDel.getChildCount());
            }
        }
    }

    private static StructNodeDelegate deserializeStructDel(NodeKind kind, NodeDelegate nodeDel, BytesIn<?> source, ResourceConfiguration config) {
        long childCount;
        long lastChild;
        long firstChild;
        long currKey = nodeDel.getNodeKey();
        boolean storeChildNodes = config.storeChildCount();
        boolean isValueNode = kind == NUMBER_VALUE || kind == STRING_VALUE || kind == BOOLEAN_VALUE || kind == NULL_VALUE;
        long rightSibling = currKey - Utils.getVarLong(source);
        long leftSibling = currKey - Utils.getVarLong(source);
        if (isValueNode) {
            firstChild = Fixed.NULL_NODE_KEY.getStandardProperty();
            lastChild = Fixed.NULL_NODE_KEY.getStandardProperty();
            childCount = 0L;
        } else {
            firstChild = currKey - Utils.getVarLong(source);
            lastChild = currKey - Utils.getVarLong(source);
            childCount = !storeChildNodes ? 0L : currKey - Utils.getVarLong(source);
        }
        long descendantCount = config.hashType == HashType.NONE || isValueNode ? 0L : Utils.getVarLong(source) + childCount;
        if (isValueNode) {
            return new StructNodeDelegate(nodeDel, firstChild, lastChild, rightSibling, leftSibling, childCount, descendantCount);
        }
        return new StructNodeDelegate(nodeDel, firstChild, rightSibling, leftSibling, childCount, descendantCount);
    }

    private static NameNodeDelegate deserializeNameDelegate(NodeDelegate nodeDel, BytesIn<?> source) {
        int uriKey = source.readInt();
        int prefixKey = source.readInt();
        int localNameKey = source.readInt();
        return new NameNodeDelegate(nodeDel, uriKey, prefixKey, localNameKey, Utils.getVarLong(source));
    }

    private static void serializeNameDelegate(NameNodeDelegate nameDel, BytesOut<ByteBuffer> sink) {
        sink.writeInt(nameDel.getURIKey());
        sink.writeInt(nameDel.getPrefixKey());
        sink.writeInt(nameDel.getLocalNameKey());
        Utils.putVarLong(sink, nameDel.getPathNodeKey());
    }

    private static void serializeValDelegate(ValueNodeDelegate valueDel, BytesOut<ByteBuffer> sink) {
        boolean isCompressed = valueDel.isCompressed();
        sink.writeByte(isCompressed ? (byte)1 : 0);
        byte[] value = isCompressed ? valueDel.getCompressed() : valueDel.getRawValue();
        sink.writeInt(value.length);
        sink.write(value);
    }

    private static void writeHash(BytesOut<ByteBuffer> sink, long hashCode) {
        sink.writeLong(hashCode);
    }

    private static void serializeBigInteger(BytesOut<ByteBuffer> sink, BigInteger bigInteger) {
        byte[] bytes = bigInteger.toByteArray();
        sink.writeStopBit((long)bytes.length);
        sink.write(bytes);
    }

    private static BigInteger deserializeBigInteger(BytesIn<?> source) {
        byte[] bytes = new byte[(int)source.readStopBit()];
        source.read(bytes);
        return new BigInteger(bytes);
    }

    static {
        INSTANCEFORID = new HashMap<Byte, NodeKind>();
        INSTANCEFORCLASS = new HashMap<Class<? extends DataRecord>, NodeKind>();
        for (NodeKind node : NodeKind.values()) {
            INSTANCEFORID.put(node.id, node);
            INSTANCEFORCLASS.put(node.clazz, node);
        }
    }

    public record DumbNode(long nodeKey) implements DataRecord
    {
        @Override
        public NodeKind getKind() {
            return NULL;
        }

        @Override
        public long getNodeKey() {
            return this.nodeKey;
        }

        @Override
        public SirixDeweyID getDeweyID() {
            return null;
        }

        @Override
        public byte[] getDeweyIDAsBytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLastModifiedRevisionNumber() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPreviousRevisionNumber() {
            throw new UnsupportedOperationException();
        }
    }
}

