/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node;

import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.interfaces.Node;
import io.sirix.node.interfaces.StructNode;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.settings.Fixed;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NullNode
implements StructNode {
    private final ImmutableNode node;

    public NullNode(ImmutableNode node) {
        this.node = Objects.requireNonNull(node);
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getFirstChildKey() {
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public void setFirstChildKey(long firstChildKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastChildKey() {
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public void setLastChildKey(long nodeKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decrementChildCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void incrementChildCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHash(long hash) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getHash() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getNodeKey() {
        return this.node.getNodeKey();
    }

    @Override
    public long getParentKey() {
        return this.node.getParentKey();
    }

    @Override
    public boolean hasParent() {
        return this.node.hasParent();
    }

    @Override
    public NodeKind getKind() {
        return this.node.getKind();
    }

    @Override
    public void setParentKey(long nodeKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTypeKey(int typeKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasFirstChild() {
        return false;
    }

    @Override
    public boolean hasLastChild() {
        return false;
    }

    @Override
    public boolean hasLeftSibling() {
        return false;
    }

    @Override
    public boolean hasRightSibling() {
        return false;
    }

    @Override
    public long getChildCount() {
        return 0L;
    }

    @Override
    public long getLeftSiblingKey() {
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public long getRightSiblingKey() {
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public void setRightSiblingKey(long nodeKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLeftSiblingKey(long nodeKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getDescendantCount() {
        return 0L;
    }

    @Override
    public void decrementDescendantCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void incrementDescendantCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDescendantCount(long descendantCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameItem(@Nullable Node other) {
        return this.node.isSameItem(other);
    }

    @Override
    public int getPreviousRevisionNumber() {
        return this.node.getPreviousRevisionNumber();
    }

    @Override
    public int getLastModifiedRevisionNumber() {
        return this.node.getLastModifiedRevisionNumber();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof NullNode) {
            NullNode other = (NullNode)obj;
            return com.google.common.base.Objects.equal((Object)this.node, (Object)other.node);
        }
        return false;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.node});
    }

    @Override
    public void setDeweyID(SirixDeweyID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SirixDeweyID getDeweyID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPreviousRevision(int revision) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLastModifiedRevision(int revision) {
        throw new UnsupportedOperationException();
    }
}

