/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node;

import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.interfaces.DataRecord;
import io.sirix.node.interfaces.RecordSerializer;
import java.util.Arrays;
import java.util.Objects;

public final class RevisionReferencesNode
implements DataRecord {
    private final long nodeKey;
    private int[] revisions;

    public RevisionReferencesNode(long nodeKey, int[] revisions) {
        this.nodeKey = nodeKey;
        this.revisions = revisions;
    }

    @Override
    public long getNodeKey() {
        return this.nodeKey;
    }

    @Override
    public SirixDeweyID getDeweyID() {
        return null;
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return null;
    }

    @Override
    public RecordSerializer getKind() {
        return NodeKind.REVISION_REFERENCES_NODE;
    }

    @Override
    public int getPreviousRevisionNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLastModifiedRevisionNumber() {
        throw new UnsupportedOperationException();
    }

    public RevisionReferencesNode addRevision(int revision) {
        int[] copy = new int[this.revisions.length + 1];
        System.arraycopy(this.revisions, 0, copy, 0, this.revisions.length);
        copy[copy.length - 1] = revision;
        this.revisions = copy;
        return this;
    }

    public int hashCode() {
        int result = Objects.hash(this.nodeKey);
        result = 31 * result + Arrays.hashCode(this.revisions);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevisionReferencesNode that = (RevisionReferencesNode)o;
        return this.nodeKey == that.nodeKey && Arrays.equals(this.revisions, that.revisions);
    }

    public int[] getRevisions() {
        return this.revisions;
    }
}

