/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.delegates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.brackit.query.atomic.QNm;
import io.sirix.node.AbstractForwardingNode;
import io.sirix.node.NodeKind;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.interfaces.NameNode;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NameNodeDelegate
extends AbstractForwardingNode
implements NameNode {
    private final NodeDelegate nodeDelegate;
    private int prefixKey;
    private int localNameKey;
    private int uriKey;
    private long pathNodeKey;

    public NameNodeDelegate(NodeDelegate delegate, int uriKey, int prefixKey, int localNameKey, @NonNegative long pathNodeKey) {
        assert (delegate != null) : "delegate must not be null!";
        this.nodeDelegate = delegate;
        this.prefixKey = prefixKey;
        this.localNameKey = localNameKey;
        this.uriKey = uriKey;
        this.pathNodeKey = pathNodeKey;
    }

    public NameNodeDelegate(NameNodeDelegate nameDel) {
        this.nodeDelegate = nameDel.nodeDelegate;
        this.prefixKey = nameDel.prefixKey;
        this.localNameKey = nameDel.localNameKey;
        this.uriKey = nameDel.uriKey;
        this.pathNodeKey = nameDel.pathNodeKey;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.UNKNOWN;
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getHash() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHash(long hash) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLocalNameKey() {
        return this.localNameKey;
    }

    @Override
    public int getURIKey() {
        return this.uriKey;
    }

    @Override
    public void setLocalNameKey(int localNameKey) {
        this.localNameKey = localNameKey;
    }

    @Override
    public void setURIKey(int uriKey) {
        this.uriKey = uriKey;
    }

    @Override
    public void setPathNodeKey(@NonNegative long pathNodeKey) {
        this.pathNodeKey = pathNodeKey;
    }

    @Override
    public long getPathNodeKey() {
        return this.pathNodeKey;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uriKey, this.prefixKey, this.localNameKey});
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof NameNodeDelegate)) {
            return false;
        }
        NameNodeDelegate other = (NameNodeDelegate)obj;
        return Objects.equal((Object)this.uriKey, (Object)other.uriKey) && Objects.equal((Object)this.prefixKey, (Object)other.prefixKey) && Objects.equal((Object)this.localNameKey, (Object)other.localNameKey);
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node delegate", (Object)this.nodeDelegate).add("uriKey", this.uriKey).add("prefixKey", this.prefixKey).add("localNameKey", this.localNameKey).add("pathNodeKey", this.pathNodeKey).toString();
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.nodeDelegate;
    }

    @Override
    public int getPrefixKey() {
        return this.prefixKey;
    }

    @Override
    public void setPrefixKey(int prefixKey) {
        this.prefixKey = prefixKey;
    }

    @Override
    public QNm getName() {
        return null;
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return this.nodeDelegate.getDeweyIDAsBytes();
    }
}

