/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.delegates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.sirix.node.AbstractForwardingNode;
import io.sirix.node.NodeKind;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.interfaces.Node;
import io.sirix.node.interfaces.ValueNode;
import io.sirix.settings.Constants;
import io.sirix.utils.Compression;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ValueNodeDelegate
extends AbstractForwardingNode
implements ValueNode {
    private final NodeDelegate nodeDelegate;
    private byte[] value;
    private boolean compressed;

    public ValueNodeDelegate(NodeDelegate nodeDel, byte[] val, boolean compressed) {
        assert (nodeDel != null) : "nodeDel must not be null!";
        assert (val != null) : "val must not be null!";
        this.nodeDelegate = nodeDel;
        this.value = val;
        this.compressed = compressed;
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getHash() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHash(long hash) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getRawValue() {
        return this.compressed ? Compression.decompress(this.value) : this.value;
    }

    @Override
    public String getValue() {
        return new String(this.getRawValue(), Constants.DEFAULT_ENCODING);
    }

    public byte[] getCompressed() {
        return this.value;
    }

    @Override
    public void setRawValue(byte[] value) {
        this.compressed = new String(value).length() > 10;
        this.value = this.compressed ? Compression.compress(value, -1) : value;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nodeDelegate, this.value});
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ValueNodeDelegate)) {
            return false;
        }
        ValueNodeDelegate other = (ValueNodeDelegate)obj;
        return Objects.equal((Object)this.nodeDelegate, (Object)other.nodeDelegate) && Arrays.equals(this.value, other.value);
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)new String(this.value)).toString();
    }

    @Override
    public boolean isSameItem(@Nullable Node other) {
        return this.nodeDelegate.isSameItem(other);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.UNKNOWN;
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.nodeDelegate;
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return this.nodeDelegate.getDeweyIDAsBytes();
    }
}

