/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.json;

import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.interfaces.immutable.ImmutableJsonNode;
import io.sirix.node.xml.AbstractStructForwardingNode;
import io.sirix.settings.Fixed;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractNumberNode
extends AbstractStructForwardingNode
implements ImmutableJsonNode {
    private final StructNodeDelegate structNodeDelegate;
    private Number number;
    private long hashCode;

    public AbstractNumberNode(StructNodeDelegate structNodeDel, Number number) {
        this.structNodeDelegate = structNodeDel;
        this.number = number;
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        NodeDelegate nodeDelegate = this.structNodeDelegate.getNodeDelegate();
        bytes.clear();
        ((Bytes)((Bytes)bytes.writeLong(nodeDelegate.getNodeKey())).writeLong(nodeDelegate.getParentKey())).writeByte(nodeDelegate.getKind().getId());
        ((Bytes)((Bytes)((Bytes)((Bytes)bytes.writeLong(this.structNodeDelegate.getChildCount())).writeLong(this.structNodeDelegate.getDescendantCount())).writeLong(this.structNodeDelegate.getLeftSiblingKey())).writeLong(this.structNodeDelegate.getRightSiblingKey())).writeLong(this.structNodeDelegate.getFirstChildKey());
        if (this.structNodeDelegate.getLastChildKey() != Fixed.INVALID_KEY_FOR_TYPE_CHECK.getStandardProperty()) {
            bytes.writeLong(this.structNodeDelegate.getLastChildKey());
        }
        Number number = this.number;
        Objects.requireNonNull(number);
        Number number2 = number;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Float.class, Double.class, BigDecimal.class, Integer.class, Long.class, BigInteger.class}, (Object)number2, n)) {
            case 0: {
                Float floatVal = (Float)number2;
                bytes.writeFloat(floatVal.floatValue());
                break;
            }
            case 1: {
                Double doubleVal = (Double)number2;
                bytes.writeDouble(doubleVal.doubleValue());
                break;
            }
            case 2: {
                BigDecimal bigDecimalVal = (BigDecimal)number2;
                bytes.writeBigDecimal(bigDecimalVal);
                break;
            }
            case 3: {
                Integer intVal = (Integer)number2;
                bytes.writeInt(intVal.intValue());
                break;
            }
            case 4: {
                Long longVal = (Long)number2;
                bytes.writeLong(longVal.longValue());
                break;
            }
            case 5: {
                BigInteger bigIntegerVal = (BigInteger)number2;
                bytes.writeBigInteger(bigIntegerVal);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(this.number));
            }
        }
        ByteBuffer buffer = ((ByteBuffer)bytes.underlyingObject()).rewind();
        buffer.limit((int)bytes.readLimit());
        return nodeDelegate.getHashFunction().hashBytes(buffer);
    }

    @Override
    public void setHash(long hash) {
        this.hashCode = hash;
    }

    @Override
    public long getHash() {
        if (this.hashCode == 0L) {
            this.hashCode = this.computeHash((Bytes<ByteBuffer>)Bytes.elasticHeapByteBuffer());
        }
        return this.hashCode;
    }

    public void setValue(Number number) {
        this.hashCode = 0L;
        this.number = number;
    }

    public Number getValue() {
        return this.number;
    }

    @Override
    public StructNodeDelegate getStructNodeDelegate() {
        return this.structNodeDelegate;
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.structNodeDelegate;
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.structNodeDelegate.getNodeDelegate();
    }
}

