/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.xml;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.brackit.query.atomic.QNm;
import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.delegates.NameNodeDelegate;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.immutable.xml.ImmutableElement;
import io.sirix.node.interfaces.NameNode;
import io.sirix.node.interfaces.immutable.ImmutableXmlNode;
import io.sirix.node.xml.AbstractStructForwardingNode;
import io.sirix.settings.Fixed;
import it.unimi.dsi.fastutil.longs.LongList;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ElementNode
extends AbstractStructForwardingNode
implements NameNode,
ImmutableXmlNode {
    private final NameNodeDelegate nameNodeDelegate;
    private final LongList attributeKeys;
    private final LongList namespaceKeys;
    private final StructNodeDelegate structNodeDelegate;
    private final QNm qNm;
    private long hash;

    public ElementNode(long hashCode, StructNodeDelegate structDel, NameNodeDelegate nameNodeDelegate, LongList attributeKeys, LongList namespaceKeys, QNm qNm) {
        this.hash = hashCode;
        assert (structDel != null);
        this.structNodeDelegate = structDel;
        assert (nameNodeDelegate != null);
        this.nameNodeDelegate = nameNodeDelegate;
        assert (attributeKeys != null);
        this.attributeKeys = attributeKeys;
        assert (namespaceKeys != null);
        this.namespaceKeys = namespaceKeys;
        assert (qNm != null);
        this.qNm = qNm;
    }

    public ElementNode(StructNodeDelegate structDel, NameNodeDelegate nameNodeDelegate, LongList attributeKeys, LongList namespaceKeys, QNm qNm) {
        assert (structDel != null);
        this.structNodeDelegate = structDel;
        assert (nameNodeDelegate != null);
        this.nameNodeDelegate = nameNodeDelegate;
        assert (attributeKeys != null);
        this.attributeKeys = attributeKeys;
        assert (namespaceKeys != null);
        this.namespaceKeys = namespaceKeys;
        assert (qNm != null);
        this.qNm = qNm;
    }

    public int getAttributeCount() {
        return this.attributeKeys.size();
    }

    public long getAttributeKey(@NonNegative int index) {
        if (this.attributeKeys.size() <= index) {
            return Fixed.NULL_NODE_KEY.getStandardProperty();
        }
        return this.attributeKeys.getLong(index);
    }

    public void insertAttribute(@NonNegative long attrKey) {
        this.attributeKeys.add(attrKey);
    }

    public void removeAttribute(@NonNegative long attrNodeKey) {
        this.attributeKeys.removeIf(key -> key == attrNodeKey);
    }

    public int getNamespaceCount() {
        return this.namespaceKeys.size();
    }

    public long getNamespaceKey(@NonNegative int namespaceKey) {
        if (this.namespaceKeys.size() <= namespaceKey) {
            return Fixed.NULL_NODE_KEY.getStandardProperty();
        }
        return this.namespaceKeys.getLong(namespaceKey);
    }

    public void insertNamespace(long namespaceKey) {
        this.namespaceKeys.add(namespaceKey);
    }

    public void removeNamespace(long namespaceKey) {
        this.namespaceKeys.removeIf(key -> key == namespaceKey);
    }

    @Override
    public int getPrefixKey() {
        return this.nameNodeDelegate.getPrefixKey();
    }

    @Override
    public int getLocalNameKey() {
        return this.nameNodeDelegate.getLocalNameKey();
    }

    @Override
    public int getURIKey() {
        return this.nameNodeDelegate.getURIKey();
    }

    @Override
    public void setPrefixKey(int prefixKey) {
        this.nameNodeDelegate.setPrefixKey(prefixKey);
    }

    @Override
    public void setLocalNameKey(int localNameKey) {
        this.nameNodeDelegate.setLocalNameKey(localNameKey);
    }

    @Override
    public void setURIKey(int uriKey) {
        this.nameNodeDelegate.setURIKey(uriKey);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ELEMENT;
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nameDelegate", (Object)this.nameNodeDelegate).add("nameSpaceKeys", (Object)this.namespaceKeys).add("attributeKeys", (Object)this.attributeKeys).add("structDelegate", (Object)this.structNodeDelegate).toString();
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        return visitor.visit(ImmutableElement.of(this));
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        NodeDelegate nodeDelegate = this.structNodeDelegate.getNodeDelegate();
        bytes.clear();
        ((Bytes)((Bytes)bytes.writeLong(nodeDelegate.getNodeKey())).writeLong(nodeDelegate.getParentKey())).writeByte(nodeDelegate.getKind().getId());
        ((Bytes)((Bytes)((Bytes)((Bytes)bytes.writeLong(this.structNodeDelegate.getChildCount())).writeLong(this.structNodeDelegate.getDescendantCount())).writeLong(this.structNodeDelegate.getLeftSiblingKey())).writeLong(this.structNodeDelegate.getRightSiblingKey())).writeLong(this.structNodeDelegate.getFirstChildKey());
        if (this.structNodeDelegate.getLastChildKey() != Fixed.INVALID_KEY_FOR_TYPE_CHECK.getStandardProperty()) {
            bytes.writeLong(this.structNodeDelegate.getLastChildKey());
        }
        ((Bytes)((Bytes)bytes.writeInt(this.nameNodeDelegate.getPrefixKey())).writeInt(this.nameNodeDelegate.getLocalNameKey())).writeInt(this.nameNodeDelegate.getURIKey());
        ByteBuffer buffer = ((ByteBuffer)bytes.underlyingObject()).rewind();
        buffer.limit((int)bytes.readLimit());
        return nodeDelegate.getHashFunction().hashBytes(buffer);
    }

    @Override
    public void setHash(long hash) {
        this.hash = hash;
    }

    @Override
    public long getHash() {
        if (this.hash == 0L) {
            this.hash = this.computeHash((Bytes<ByteBuffer>)Bytes.elasticHeapByteBuffer());
        }
        return this.hash;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.delegate(), this.nameNodeDelegate});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ElementNode)) return false;
        ElementNode other = (ElementNode)obj;
        if (!Objects.equal((Object)this.delegate(), (Object)other.delegate())) return false;
        if (!Objects.equal((Object)this.nameNodeDelegate, (Object)other.nameNodeDelegate)) return false;
        return true;
    }

    public List<Long> getAttributeKeys() {
        return Collections.unmodifiableList(this.attributeKeys);
    }

    public List<Long> getNamespaceKeys() {
        return Collections.unmodifiableList(this.namespaceKeys);
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.structNodeDelegate.getNodeDelegate();
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.structNodeDelegate;
    }

    public @NonNull NameNodeDelegate getNameNodeDelegate() {
        return new NameNodeDelegate(this.nameNodeDelegate);
    }

    @Override
    public void setPathNodeKey(@NonNegative long pathNodeKey) {
        this.nameNodeDelegate.setPathNodeKey(pathNodeKey);
    }

    @Override
    public long getPathNodeKey() {
        return this.nameNodeDelegate.getPathNodeKey();
    }

    @Override
    public QNm getName() {
        return this.qNm;
    }

    @Override
    public SirixDeweyID getDeweyID() {
        return this.structNodeDelegate.getNodeDelegate().getDeweyID();
    }

    @Override
    public int getTypeKey() {
        return this.structNodeDelegate.getNodeDelegate().getTypeKey();
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return this.structNodeDelegate.getDeweyIDAsBytes();
    }
}

