/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.xml;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.brackit.query.atomic.QNm;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.delegates.NameNodeDelegate;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.delegates.ValueNodeDelegate;
import io.sirix.node.immutable.xml.ImmutablePI;
import io.sirix.node.interfaces.NameNode;
import io.sirix.node.interfaces.ValueNode;
import io.sirix.node.interfaces.immutable.ImmutableXmlNode;
import io.sirix.node.xml.AbstractStructForwardingNode;
import io.sirix.settings.Constants;
import io.sirix.settings.Fixed;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PINode
extends AbstractStructForwardingNode
implements ValueNode,
NameNode,
ImmutableXmlNode {
    private final NameNodeDelegate nameNodeDelegate;
    private final ValueNodeDelegate valueNodeDelegate;
    private final StructNodeDelegate structNodeDelegate;
    private final PageReadOnlyTrx pageReadTrx;
    private long hash;

    public PINode(long hashCode, StructNodeDelegate structNodeDelegate, NameNodeDelegate nameNodeDelegate, ValueNodeDelegate valueNodeDelegate, PageReadOnlyTrx pageReadTrx) {
        this.hash = hashCode;
        assert (structNodeDelegate != null) : "structNodeDelegate must not be null!";
        this.structNodeDelegate = structNodeDelegate;
        assert (nameNodeDelegate != null) : "nameDel must not be null!";
        this.nameNodeDelegate = nameNodeDelegate;
        assert (valueNodeDelegate != null) : "valDel must not be null!";
        this.valueNodeDelegate = valueNodeDelegate;
        assert (pageReadTrx != null) : "pageReadTrx must not be null!";
        this.pageReadTrx = pageReadTrx;
    }

    public PINode(StructNodeDelegate structNodeDelegate, NameNodeDelegate nameNodeDelegate, ValueNodeDelegate valueNodeDelegate, PageReadOnlyTrx pageReadTrx) {
        assert (structNodeDelegate != null) : "structNodeDelegate must not be null!";
        this.structNodeDelegate = structNodeDelegate;
        assert (nameNodeDelegate != null) : "nameDel must not be null!";
        this.nameNodeDelegate = nameNodeDelegate;
        assert (valueNodeDelegate != null) : "valDel must not be null!";
        this.valueNodeDelegate = valueNodeDelegate;
        assert (pageReadTrx != null) : "pageReadTrx must not be null!";
        this.pageReadTrx = pageReadTrx;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.PROCESSING_INSTRUCTION;
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        NodeDelegate nodeDelegate = this.structNodeDelegate.getNodeDelegate();
        bytes.clear();
        ((Bytes)((Bytes)bytes.writeLong(nodeDelegate.getNodeKey())).writeLong(nodeDelegate.getParentKey())).writeByte(nodeDelegate.getKind().getId());
        ((Bytes)((Bytes)((Bytes)((Bytes)bytes.writeLong(this.structNodeDelegate.getChildCount())).writeLong(this.structNodeDelegate.getDescendantCount())).writeLong(this.structNodeDelegate.getLeftSiblingKey())).writeLong(this.structNodeDelegate.getRightSiblingKey())).writeLong(this.structNodeDelegate.getFirstChildKey());
        if (this.structNodeDelegate.getLastChildKey() != Fixed.INVALID_KEY_FOR_TYPE_CHECK.getStandardProperty()) {
            bytes.writeLong(this.structNodeDelegate.getLastChildKey());
        }
        ((Bytes)((Bytes)bytes.writeLong((long)this.nameNodeDelegate.getPrefixKey())).writeLong((long)this.nameNodeDelegate.getLocalNameKey())).writeLong((long)this.nameNodeDelegate.getURIKey());
        bytes.writeUtf8(new String(this.valueNodeDelegate.getRawValue(), Constants.DEFAULT_ENCODING));
        ByteBuffer buffer = ((ByteBuffer)bytes.underlyingObject()).rewind();
        buffer.limit((int)bytes.readLimit());
        return nodeDelegate.getHashFunction().hashBytes(buffer);
    }

    @Override
    public void setHash(long hash) {
        this.hash = hash;
    }

    @Override
    public long getHash() {
        if (this.hash == 0L) {
            this.hash = this.computeHash((Bytes<ByteBuffer>)Bytes.elasticHeapByteBuffer());
        }
        return this.hash;
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        return visitor.visit(ImmutablePI.of(this));
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("structDel", (Object)this.structNodeDelegate).add("nameDel", (Object)this.nameNodeDelegate).add("valDel", (Object)this.valueNodeDelegate).toString();
    }

    @Override
    public int getPrefixKey() {
        return this.nameNodeDelegate.getPrefixKey();
    }

    @Override
    public int getLocalNameKey() {
        return this.nameNodeDelegate.getLocalNameKey();
    }

    @Override
    public int getURIKey() {
        return this.nameNodeDelegate.getURIKey();
    }

    @Override
    public void setPrefixKey(int prefixKey) {
        this.hash = 0L;
        this.nameNodeDelegate.setPrefixKey(prefixKey);
    }

    @Override
    public void setLocalNameKey(int localNameKey) {
        this.hash = 0L;
        this.nameNodeDelegate.setLocalNameKey(localNameKey);
    }

    @Override
    public void setURIKey(int uriKey) {
        this.hash = 0L;
        this.nameNodeDelegate.setURIKey(uriKey);
    }

    @Override
    public byte[] getRawValue() {
        return this.valueNodeDelegate.getRawValue();
    }

    @Override
    public void setRawValue(byte[] value) {
        this.hash = 0L;
        this.valueNodeDelegate.setRawValue(value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nameNodeDelegate, this.valueNodeDelegate});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof PINode) {
            PINode other = (PINode)obj;
            return Objects.equal((Object)this.nameNodeDelegate, (Object)other.nameNodeDelegate) && Objects.equal((Object)this.valueNodeDelegate, (Object)other.valueNodeDelegate);
        }
        return false;
    }

    @Override
    public void setPathNodeKey(@NonNegative long pathNodeKey) {
        this.hash = 0L;
        this.nameNodeDelegate.setPathNodeKey(pathNodeKey);
    }

    @Override
    public long getPathNodeKey() {
        return this.nameNodeDelegate.getPathNodeKey();
    }

    public NameNodeDelegate getNameNodeDelegate() {
        return this.nameNodeDelegate;
    }

    public ValueNodeDelegate getValNodeDelegate() {
        return this.valueNodeDelegate;
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.structNodeDelegate.getNodeDelegate();
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.structNodeDelegate;
    }

    @Override
    public QNm getName() {
        String uri = this.pageReadTrx.getName(this.nameNodeDelegate.getURIKey(), NodeKind.NAMESPACE);
        int prefixKey = this.nameNodeDelegate.getPrefixKey();
        String prefix = prefixKey == -1 ? "" : this.pageReadTrx.getName(prefixKey, NodeKind.PROCESSING_INSTRUCTION);
        int localNameKey = this.nameNodeDelegate.getLocalNameKey();
        String localName = localNameKey == -1 ? "" : this.pageReadTrx.getName(localNameKey, NodeKind.PROCESSING_INSTRUCTION);
        return new QNm(uri, prefix, localName);
    }

    @Override
    public String getValue() {
        return new String(this.valueNodeDelegate.getRawValue(), Constants.DEFAULT_ENCODING);
    }

    @Override
    public SirixDeweyID getDeweyID() {
        return this.structNodeDelegate.getNodeDelegate().getDeweyID();
    }

    @Override
    public int getTypeKey() {
        return this.structNodeDelegate.getNodeDelegate().getTypeKey();
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return this.structNodeDelegate.getDeweyIDAsBytes();
    }
}

