/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.xml;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.delegates.ValueNodeDelegate;
import io.sirix.node.immutable.xml.ImmutableText;
import io.sirix.node.interfaces.ValueNode;
import io.sirix.node.interfaces.immutable.ImmutableXmlNode;
import io.sirix.node.xml.AbstractStructForwardingNode;
import io.sirix.settings.Constants;
import io.sirix.settings.Fixed;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TextNode
extends AbstractStructForwardingNode
implements ValueNode,
ImmutableXmlNode {
    private final ValueNodeDelegate valueNodeDelegate;
    private final StructNodeDelegate structNodeDelegate;
    private byte[] value;
    private long hash;

    public TextNode(long hashCode, ValueNodeDelegate valDel, StructNodeDelegate structDel) {
        this.hash = hashCode;
        assert (structDel != null);
        this.structNodeDelegate = structDel;
        assert (valDel != null);
        this.valueNodeDelegate = valDel;
    }

    public TextNode(ValueNodeDelegate valDel, StructNodeDelegate structDel) {
        assert (structDel != null);
        this.structNodeDelegate = structDel;
        assert (valDel != null);
        this.valueNodeDelegate = valDel;
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        NodeDelegate nodeDelegate = this.structNodeDelegate.getNodeDelegate();
        byte[] rawValue = this.valueNodeDelegate.getRawValue();
        bytes.clear();
        ((Bytes)((Bytes)bytes.writeLong(nodeDelegate.getNodeKey())).writeLong(nodeDelegate.getParentKey())).writeByte(nodeDelegate.getKind().getId());
        ((Bytes)bytes.writeLong(this.structNodeDelegate.getLeftSiblingKey())).writeLong(this.structNodeDelegate.getRightSiblingKey());
        bytes.write(rawValue);
        ByteBuffer buffer = ((ByteBuffer)bytes.underlyingObject()).rewind();
        buffer.limit((int)bytes.readLimit());
        return nodeDelegate.getHashFunction().hashBytes(buffer);
    }

    @Override
    public void setHash(long hash) {
        this.hash = hash;
    }

    @Override
    public long getHash() {
        if (this.hash == 0L) {
            this.hash = this.computeHash((Bytes<ByteBuffer>)Bytes.elasticHeapByteBuffer());
        }
        return this.hash;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.TEXT;
    }

    @Override
    public byte[] getRawValue() {
        if (this.value == null) {
            this.value = this.valueNodeDelegate.getRawValue();
        }
        return this.value;
    }

    @Override
    public void setRawValue(byte[] value) {
        this.value = null;
        this.hash = 0L;
        this.valueNodeDelegate.setRawValue(value);
    }

    @Override
    public long getFirstChildKey() {
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        return visitor.visit(ImmutableText.of(this));
    }

    @Override
    public void decrementChildCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void incrementChildCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getDescendantCount() {
        return 0L;
    }

    @Override
    public void decrementDescendantCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void incrementDescendantCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDescendantCount(long descendantCount) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.structNodeDelegate.getNodeDelegate(), this.valueNodeDelegate});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof TextNode) {
            TextNode other = (TextNode)obj;
            return Objects.equal((Object)this.structNodeDelegate.getNodeDelegate(), (Object)other.getNodeDelegate()) && this.valueNodeDelegate.equals(other.valueNodeDelegate);
        }
        return false;
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node delegate", (Object)this.structNodeDelegate.getNodeDelegate()).add("struct delegate", (Object)this.structNodeDelegate).add("value delegate", (Object)this.valueNodeDelegate).toString();
    }

    public ValueNodeDelegate getValNodeDelegate() {
        return this.valueNodeDelegate;
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.structNodeDelegate.getNodeDelegate();
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.structNodeDelegate;
    }

    @Override
    public String getValue() {
        return new String(this.valueNodeDelegate.getRawValue(), Constants.DEFAULT_ENCODING);
    }

    @Override
    public SirixDeweyID getDeweyID() {
        return this.structNodeDelegate.getNodeDelegate().getDeweyID();
    }

    @Override
    public int getTypeKey() {
        return this.structNodeDelegate.getNodeDelegate().getTypeKey();
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return this.structNodeDelegate.getDeweyIDAsBytes();
    }
}

