/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page;

import com.google.common.base.MoreObjects;
import io.sirix.access.DatabaseType;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.cache.TransactionIntentLog;
import io.sirix.index.IndexType;
import io.sirix.node.DeweyIDNode;
import io.sirix.node.SirixDeweyID;
import io.sirix.page.AbstractForwardingPage;
import io.sirix.page.PageReference;
import io.sirix.page.PageUtils;
import io.sirix.page.delegates.ReferencesPage4;
import io.sirix.page.interfaces.Page;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DeweyIDPage
extends AbstractForwardingPage {
    public static final int REFERENCE_OFFSET = 0;
    private Page delegate;
    private long maxNodeKey;
    private int currentMaxLevelOfIndirectPages;
    private Map<SirixDeweyID, Long> deweyIDsToNodeKeys;

    public DeweyIDPage() {
        this.delegate = new ReferencesPage4();
        this.currentMaxLevelOfIndirectPages = 1;
    }

    public DeweyIDPage(Page delegate, long maxNodeKey, int currentMaxLevelOfIndirectPages) {
        this.delegate = delegate;
        this.maxNodeKey = maxNodeKey;
        this.currentMaxLevelOfIndirectPages = currentMaxLevelOfIndirectPages;
    }

    public int getCurrentMaxLevelOfIndirectPages() {
        return this.currentMaxLevelOfIndirectPages;
    }

    public int incrementAndGetCurrentMaxLevelOfIndirectPages() {
        return this.currentMaxLevelOfIndirectPages++;
    }

    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("currMaxLevelOfIndirectPages", this.currentMaxLevelOfIndirectPages).add("maxNodeKey", this.maxNodeKey).toString();
    }

    public void createIndexTree(DatabaseType databaseType, PageReadOnlyTrx pageReadTrx, TransactionIntentLog log) {
        PageReference reference = this.getIndirectPageReference();
        if (reference.getPage() == null && reference.getKey() == -15L && reference.getLogKey() == -15) {
            PageUtils.createTree(databaseType, reference, IndexType.DEWEYID_TO_RECORDID, pageReadTrx, log);
            this.incrementAndGetMaxNodeKey();
        }
    }

    public PageReference getIndirectPageReference() {
        return this.getOrCreateReference(0);
    }

    public long getMaxNodeKey() {
        return this.maxNodeKey;
    }

    public long incrementAndGetMaxNodeKey() {
        return ++this.maxNodeKey;
    }

    @Override
    protected Page delegate() {
        return this.delegate;
    }

    @Override
    public boolean setOrCreateReference(int offset, PageReference pageReference) {
        this.delegate = PageUtils.setReference(this.delegate, offset, pageReference);
        return false;
    }

    public SirixDeweyID getDeweyIdForNodeKey(long nodeKey, PageReadOnlyTrx pageReadOnlyTrx) {
        DeweyIDNode node = (DeweyIDNode)pageReadOnlyTrx.getRecord(nodeKey, IndexType.DEWEYID_TO_RECORDID, 0);
        if (node == null) {
            return null;
        }
        return node.getDeweyID();
    }

    public long getNodeKeyForDeweyId(SirixDeweyID deweyId, PageReadOnlyTrx pageReadOnlyTrx) {
        if (this.deweyIDsToNodeKeys == null) {
            // empty if block
        }
        return this.deweyIDsToNodeKeys.get(deweyId);
    }

    public void setDeweyID(SirixDeweyID deweyId, PageTrx pageTrx) {
        long nodeKey = this.maxNodeKey;
        DeweyIDNode node = new DeweyIDNode(this.maxNodeKey++, deweyId);
        pageTrx.createRecord(node, IndexType.DEWEYID_TO_RECORDID, 0);
        this.deweyIDsToNodeKeys.put(deweyId, nodeKey);
    }
}

