/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page;

import io.sirix.api.PageReadOnlyTrx;
import io.sirix.cache.PageContainer;
import io.sirix.cache.TransactionIntentLog;
import io.sirix.page.PageReference;
import io.sirix.page.interfaces.Page;
import java.util.ArrayList;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;

public class ForEach
extends RecursiveAction {
    private static final int TASK_LEN = 128;
    private final TransactionIntentLog log;
    private final PageReadOnlyTrx pageTrx;
    private final PageReference[] array;
    private final int from;
    private final int to;

    public ForEach(TransactionIntentLog log, PageReadOnlyTrx pageTrx, PageReference[] array, int from, int to) {
        this.log = log;
        this.pageTrx = pageTrx;
        this.array = array;
        this.from = from;
        this.to = to;
    }

    @Override
    protected void compute() {
        int len = this.to - this.from;
        if (len < 128) {
            this.work(this.log, this.pageTrx, this.array, this.from, this.to);
        } else {
            int mid = this.from + this.to >>> 1;
            ArrayList<ForEach> dividedTasks = new ArrayList<ForEach>();
            dividedTasks.add(new ForEach(this.log, this.pageTrx, this.array, this.from, mid));
            dividedTasks.add(new ForEach(this.log, this.pageTrx, this.array, mid, this.to));
            ForkJoinTask.invokeAll(dividedTasks).forEach(ForkJoinTask::join);
        }
    }

    private void work(TransactionIntentLog log, PageReadOnlyTrx pageTrx, PageReference[] references, int from, int to) {
        for (int j = from; j < to; ++j) {
            PageReference reference = references[j];
            if (reference == null || reference.getLogKey() == -15) continue;
            PageContainer container = log.get(reference);
            Page page = container.getModified();
        }
    }
}

