/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page;

import io.sirix.page.AbstractForwardingPage;
import io.sirix.page.PageReference;
import io.sirix.page.PageUtils;
import io.sirix.page.delegates.BitmapReferencesPage;
import io.sirix.page.delegates.FullReferencesPage;
import io.sirix.page.delegates.ReferencesPage4;
import io.sirix.page.interfaces.Page;

public final class IndirectPage
extends AbstractForwardingPage {
    private Page delegate;

    public IndirectPage() {
        this.delegate = new ReferencesPage4();
    }

    public IndirectPage(Page delegate) {
        this.delegate = delegate;
    }

    public IndirectPage(IndirectPage page) {
        Page pageDelegate = page.delegate();
        if (pageDelegate instanceof ReferencesPage4) {
            this.delegate = new ReferencesPage4((ReferencesPage4)pageDelegate);
        } else if (pageDelegate instanceof BitmapReferencesPage) {
            this.delegate = new BitmapReferencesPage(pageDelegate, ((BitmapReferencesPage)pageDelegate).getBitmap());
        } else if (pageDelegate instanceof FullReferencesPage) {
            this.delegate = new FullReferencesPage((FullReferencesPage)pageDelegate);
        }
    }

    @Override
    protected Page delegate() {
        return this.delegate;
    }

    @Override
    public boolean setOrCreateReference(int offset, PageReference pageReference) {
        this.delegate = PageUtils.setReference(this.delegate, offset, pageReference);
        return false;
    }

    @Override
    public PageReference getOrCreateReference(int offset) {
        PageReference reference = super.getOrCreateReference(offset);
        if (reference == null) {
            if (this.delegate instanceof ReferencesPage4) {
                this.delegate = new BitmapReferencesPage(1024, (ReferencesPage4)this.delegate());
                reference = this.delegate.getOrCreateReference(offset);
            } else if (this.delegate instanceof BitmapReferencesPage) {
                this.delegate = new FullReferencesPage((BitmapReferencesPage)this.delegate());
                reference = this.delegate.getOrCreateReference(offset);
            }
        }
        return reference;
    }
}

