/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.sirix.access.ResourceConfiguration;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.index.IndexType;
import io.sirix.node.interfaces.DataRecord;
import io.sirix.node.interfaces.DeweyIdSerializer;
import io.sirix.node.interfaces.RecordSerializer;
import io.sirix.page.OverflowPage;
import io.sirix.page.PageReference;
import io.sirix.page.interfaces.KeyValuePage;
import io.sirix.utils.ArrayIterator;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class KeyValueLeafPage
implements KeyValuePage<DataRecord> {
    private final int revision;
    private final boolean areDeweyIDsStored;
    private boolean addedReferences;
    private final Map<Long, PageReference> references;
    private final long recordPageKey;
    private final DataRecord[] records;
    private final byte[][] slots;
    private final byte[][] deweyIds;
    private final IndexType indexType;
    private final RecordSerializer recordPersister;
    private final ResourceConfiguration resourceConfig;
    private volatile BytesOut<?> bytes;
    private volatile byte[] hashCode;
    private int hash;

    public KeyValueLeafPage(KeyValueLeafPage pageToClone) {
        this.addedReferences = false;
        this.references = pageToClone.references;
        this.recordPageKey = pageToClone.recordPageKey;
        this.records = Arrays.copyOf(pageToClone.records, pageToClone.records.length);
        this.slots = (byte[][])Arrays.copyOf(pageToClone.slots, pageToClone.slots.length);
        this.deweyIds = (byte[][])Arrays.copyOf(pageToClone.deweyIds, pageToClone.deweyIds.length);
        this.indexType = pageToClone.indexType;
        this.recordPersister = pageToClone.recordPersister;
        this.resourceConfig = pageToClone.resourceConfig;
        this.revision = pageToClone.revision;
        this.areDeweyIDsStored = pageToClone.areDeweyIDsStored;
    }

    public KeyValueLeafPage(@NonNegative long recordPageKey, IndexType indexType, PageReadOnlyTrx pageReadOnlyTrx) {
        assert (pageReadOnlyTrx != null) : "The page reading trx must not be null!";
        this.references = new ConcurrentHashMap<Long, PageReference>();
        this.recordPageKey = recordPageKey;
        this.records = new DataRecord[1024];
        this.slots = new byte[1024][];
        this.indexType = indexType;
        this.resourceConfig = pageReadOnlyTrx.getResourceSession().getResourceConfig();
        this.recordPersister = this.resourceConfig.recordPersister;
        this.deweyIds = new byte[1024][];
        this.revision = pageReadOnlyTrx.getRevisionNumber();
        this.areDeweyIDsStored = this.resourceConfig.areDeweyIDsStored;
    }

    KeyValueLeafPage(long recordPageKey, int revision, IndexType indexType, ResourceConfiguration resourceConfig, boolean areDeweyIDsStored, RecordSerializer recordPersister, byte[][] slots, byte[][] deweyIds, Map<Long, PageReference> references) {
        this.recordPageKey = recordPageKey;
        this.revision = revision;
        this.indexType = indexType;
        this.resourceConfig = resourceConfig;
        this.areDeweyIDsStored = areDeweyIDsStored;
        this.recordPersister = recordPersister;
        this.slots = slots;
        this.deweyIds = deweyIds;
        this.references = references;
        this.records = new DataRecord[1024];
    }

    @Override
    public long getPageKey() {
        return this.recordPageKey;
    }

    @Override
    public DataRecord getRecord(long key) {
        int offset = PageReadOnlyTrx.recordPageOffset(key);
        return this.records[offset];
    }

    @Override
    public byte[] getSlot(int slotNumber) {
        return this.slots[slotNumber];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecord(@NonNull DataRecord record) {
        this.addedReferences = false;
        int offset = PageReadOnlyTrx.recordPageOffset(record.getNodeKey());
        DataRecord[] dataRecordArray = this.records;
        synchronized (this.records) {
            this.records[offset] = record;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public BytesOut<?> getBytes() {
        return this.bytes;
    }

    public void setBytes(BytesOut<?> bytes) {
        this.bytes = bytes;
    }

    public byte[][] getSlots() {
        return this.slots;
    }

    public byte[][] getDeweyIds() {
        return this.deweyIds;
    }

    public ResourceConfiguration getResourceConfig() {
        return this.resourceConfig;
    }

    @Override
    public <C extends KeyValuePage<DataRecord>> C copy() {
        return (C)new KeyValueLeafPage(this);
    }

    public DataRecord[] records() {
        return this.records;
    }

    public byte[] getHashCode() {
        return this.hashCode;
    }

    public void setHashCode(byte[] hashCode) {
        this.hashCode = hashCode;
    }

    @Override
    public <I extends Iterable<DataRecord>> I values() {
        return (I)new ArrayIterator(this.records, this.records.length);
    }

    @Override
    public byte[][] slots() {
        return this.slots;
    }

    @Override
    public synchronized void setSlot(byte[] recordData, int offset) {
        this.slots[offset] = recordData;
    }

    @Override
    public byte[] getDeweyId(int offset) {
        return this.deweyIds[offset];
    }

    @Override
    public void setDeweyId(byte[] deweyId, int offset) {
        this.deweyIds[offset] = deweyId;
    }

    @Override
    public byte[][] deweyIds() {
        return this.deweyIds;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("pagekey", this.recordPageKey);
        for (DataRecord record : this.records) {
            helper.add("record", (Object)record);
        }
        for (PageReference reference : this.references.values()) {
            helper.add("reference", (Object)reference);
        }
        return helper.toString();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hashCode((Object[])new Object[]{this.recordPageKey, this.revision});
        }
        return this.hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof KeyValueLeafPage) {
            KeyValueLeafPage other = (KeyValueLeafPage)obj;
            return this.recordPageKey == other.recordPageKey && this.revision == other.revision;
        }
        return false;
    }

    @Override
    public List<PageReference> getReferences() {
        throw new UnsupportedOperationException();
    }

    public Map<Long, PageReference> getReferencesMap() {
        return this.references;
    }

    @Override
    public void commit(@NonNull PageTrx pageWriteTrx) {
        this.addReferences(pageWriteTrx);
        for (PageReference reference : this.references.values()) {
            if (reference.getPage() == null && reference.getKey() == -15L && (long)reference.getLogKey() == -15L) continue;
            pageWriteTrx.commit(reference);
        }
    }

    public void addReferences(PageReadOnlyTrx pageReadOnlyTrx) {
        if (!this.addedReferences) {
            if (this.areDeweyIDsStored && this.recordPersister instanceof DeweyIdSerializer) {
                this.processEntries(pageReadOnlyTrx, this.records);
                for (int i = 0; i < this.records.length; ++i) {
                    DataRecord record = this.records[i];
                    if (record == null || record.getDeweyID() == null || record.getNodeKey() == 0L) continue;
                    this.deweyIds[i] = record.getDeweyID().toBytes();
                }
            } else {
                this.processEntries(pageReadOnlyTrx, this.records);
            }
            this.addedReferences = true;
        }
    }

    private void processEntries(PageReadOnlyTrx pageReadOnlyTrx, DataRecord[] records) {
        Bytes out = Bytes.elasticHeapByteBuffer((int)30);
        for (DataRecord record : records) {
            if (record == null) continue;
            long recordID = record.getNodeKey();
            int offset = PageReadOnlyTrx.recordPageOffset(recordID);
            this.recordPersister.serialize((BytesOut<ByteBuffer>)out, record, pageReadOnlyTrx);
            byte[] data = out.toByteArray();
            out.clear();
            if (data.length > 150000) {
                PageReference reference = new PageReference();
                reference.setPage(new OverflowPage(data));
                this.references.put(recordID, reference);
                continue;
            }
            this.slots[offset] = data;
        }
    }

    @Override
    public PageReference getOrCreateReference(int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setOrCreateReference(int offset, PageReference pageReference) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <C extends KeyValuePage<DataRecord>> C newInstance(long recordPageKey, @NonNull IndexType indexType, @NonNull PageReadOnlyTrx pageReadTrx) {
        return (C)new KeyValueLeafPage(recordPageKey, indexType, pageReadTrx);
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public int size() {
        return KeyValueLeafPage.getNumberOfNonNullEntries(this.records, this.slots) + this.references.size();
    }

    @Override
    public void setPageReference(long key, @NonNull PageReference reference) {
        this.references.put(key, reference);
    }

    @Override
    public Set<Map.Entry<Long, PageReference>> referenceEntrySet() {
        return this.references.entrySet();
    }

    @Override
    public PageReference getPageReference(long key) {
        return this.references.get(key);
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public KeyValuePage<DataRecord> clearPage() {
        if (this.bytes != null) {
            this.bytes.clear();
            this.bytes = null;
        }
        this.hashCode = null;
        Arrays.fill(this.records, null);
        Arrays.fill((Object[])this.slots, null);
        Arrays.fill((Object[])this.deweyIds, null);
        this.references.clear();
        return this;
    }

    public static int getNumberOfNonNullEntries(DataRecord[] entries, byte[][] slots) {
        int count = 0;
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i] == null && slots[i] == null) continue;
            ++count;
        }
        return count;
    }
}

