/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page;

import com.google.common.base.MoreObjects;
import io.sirix.page.interfaces.Page;
import io.sirix.page.interfaces.PageFragmentKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PageReference {
    private volatile Page page;
    private long key = -15L;
    private int logKey = -15;
    private byte[] hashInBytes;
    private List<PageFragmentKey> pageFragments;
    private int hash;

    public PageReference() {
        this.pageFragments = new ArrayList<PageFragmentKey>();
    }

    public PageReference(PageReference reference) {
        this.logKey = reference.logKey;
        this.page = reference.page;
        this.key = reference.key;
        this.hashInBytes = reference.hashInBytes;
        this.pageFragments = reference.pageFragments;
        this.hash = reference.hash;
    }

    public void setPage(@Nullable Page page) {
        this.page = page;
    }

    public Page getPage() {
        return this.page;
    }

    public long getKey() {
        return this.key;
    }

    public PageReference setKey(long key) {
        this.hash = 0;
        this.key = key;
        return this;
    }

    public PageReference addPageFragment(PageFragmentKey key) {
        this.pageFragments.add(key);
        return this;
    }

    public List<PageFragmentKey> getPageFragments() {
        return this.pageFragments;
    }

    public PageReference setPageFragments(List<PageFragmentKey> previousPageFragmentKeys) {
        this.pageFragments = previousPageFragmentKeys;
        return this;
    }

    public int getLogKey() {
        return this.logKey;
    }

    public PageReference setLogKey(int key) {
        this.hash = 0;
        this.logKey = key;
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("logKey", this.logKey).add("key", this.key).add("page", (Object)this.page).add("pageFragments", this.pageFragments).toString();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.logKey, this.key);
        }
        return this.hash;
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof PageReference) {
            PageReference otherPageRef = (PageReference)other;
            return otherPageRef.logKey == this.logKey && otherPageRef.key == this.key;
        }
        return false;
    }

    public void setHash(byte[] hashInBytes) {
        this.hashInBytes = hashInBytes;
    }

    public byte[] getHash() {
        return this.hashInBytes;
    }
}

