/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page;

import io.sirix.exception.SirixIOException;
import io.sirix.page.DeserializedBitmapReferencesPageTuple;
import io.sirix.page.DeserializedReferencesPage4Tuple;
import io.sirix.page.PageFragmentKeyImpl;
import io.sirix.page.PageReference;
import io.sirix.page.interfaces.PageFragmentKey;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.magicwerk.brownies.collections.GapList;

public enum SerializationType {
    DATA{

        @Override
        public void serializeBitmapReferencesPage(BytesOut<?> out, List<PageReference> pageReferences, BitSet bitmap) {
            assert (out != null);
            assert (pageReferences != null);
            try {
                1.serializeBitSet(out, bitmap);
                for (PageReference pageReference : pageReferences) {
                    SerializationType.writePageFragments(out, pageReference);
                    SerializationType.writeHash(out, pageReference);
                }
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }

        @Override
        public void serializeReferencesPage4(BytesOut<?> out, List<PageReference> pageReferences, List<Short> offsets) {
            try {
                out.writeByte((byte)pageReferences.size());
                for (PageReference pageReference : pageReferences) {
                    SerializationType.writePageFragments(out, pageReference);
                    SerializationType.writeHash(out, pageReference);
                }
                Iterator<Object> iterator = offsets.iterator();
                while (iterator.hasNext()) {
                    short offset = (Short)iterator.next();
                    out.writeShort(offset);
                }
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }

        @Override
        public DeserializedBitmapReferencesPageTuple deserializeBitmapReferencesPage(@NonNegative int referenceCount, BytesIn<?> in) {
            assert (in != null);
            try {
                BitSet bitmap = 1.deserializeBitSet(in);
                int length = bitmap.cardinality();
                GapList references = new GapList(length);
                for (int offset = 0; offset < length; ++offset) {
                    PageReference reference = new PageReference();
                    SerializationType.readPageFragments(in, reference);
                    SerializationType.readHash(in, reference);
                    references.add(offset, (Object)reference);
                }
                return new DeserializedBitmapReferencesPageTuple((List<PageReference>)references, bitmap);
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }

        @Override
        public DeserializedReferencesPage4Tuple deserializeReferencesPage4(BytesIn<?> in) {
            try {
                int i;
                int size = in.readByte();
                ArrayList<PageReference> pageReferences = new ArrayList<PageReference>(4);
                ShortArrayList offsets = new ShortArrayList(4);
                for (i = 0; i < size; ++i) {
                    PageReference reference = new PageReference();
                    SerializationType.readPageFragments(in, reference);
                    SerializationType.readHash(in, reference);
                    pageReferences.add(reference);
                }
                for (i = 0; i < size; ++i) {
                    offsets.add(in.readShort());
                }
                return new DeserializedReferencesPage4Tuple(pageReferences, (ShortList)offsets);
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }

        @Override
        public void serializeFullReferencesPage(BytesOut<?> out, PageReference[] pageReferences) {
            try {
                BitSet bitSet = new BitSet(1024);
                int size = pageReferences.length;
                for (int i = 0; i < size; ++i) {
                    if (pageReferences[i] == null) continue;
                    bitSet.set(i, true);
                }
                1.serializeBitSet(out, bitSet);
                for (PageReference pageReference : pageReferences) {
                    if (pageReference == null) continue;
                    out.writeLong(pageReference.getKey());
                    SerializationType.writePageFragments(out, pageReference);
                    SerializationType.writeHash(out, pageReference);
                }
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }

        @Override
        public PageReference[] deserializeFullReferencesPage(BytesIn<?> in) {
            try {
                PageReference[] references = new PageReference[1024];
                BitSet bitSet = 1.deserializeBitSet(in);
                int i = bitSet.nextSetBit(0);
                while (i >= 0) {
                    PageReference pageReference = new PageReference();
                    pageReference.setKey(in.readLong());
                    SerializationType.readPageFragments(in, pageReference);
                    SerializationType.readHash(in, pageReference);
                    references[i] = pageReference;
                    i = bitSet.nextSetBit(i + 1);
                }
                return references;
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }
    };


    private static void writeHash(BytesOut<?> out, PageReference pageReference) throws IOException {
        if (pageReference.getHash() == null) {
            out.writeInt(-1);
        } else {
            byte[] hash = pageReference.getHash();
            out.writeInt(hash.length);
            out.write(pageReference.getHash());
        }
    }

    private static void readHash(BytesIn<?> in, PageReference reference) throws IOException {
        int hashLength = in.readInt();
        if (hashLength != -1) {
            byte[] hash = new byte[hashLength];
            in.read(hash);
            reference.setHash(hash);
        }
    }

    private static void readPageFragments(BytesIn<?> in, PageReference reference) throws IOException {
        int keysSize = in.readByte() & 0xFF;
        if (keysSize > 0) {
            for (int i = 0; i < keysSize; ++i) {
                int revision = in.readInt();
                long key = in.readLong();
                reference.addPageFragment(new PageFragmentKeyImpl(revision, key));
            }
        }
        long key = in.readLong();
        reference.setKey(key);
    }

    private static void writePageFragments(BytesOut<?> out, PageReference pageReference) throws IOException {
        List<PageFragmentKey> keys = pageReference.getPageFragments();
        out.writeByte((byte)keys.size());
        for (PageFragmentKey key : keys) {
            out.writeInt(key.revision());
            out.writeLong(key.key());
        }
        out.writeLong(pageReference.getKey());
    }

    public static void serializeBitSet(BytesOut<?> out, @NonNull BitSet bitmap) {
        byte[] bytes = bitmap.toByteArray();
        int len = bytes.length;
        out.writeShort((short)len);
        out.write(bytes);
    }

    public static BitSet deserializeBitSet(BytesIn<?> in) {
        short len = in.readShort();
        byte[] bytes = new byte[len];
        in.read(bytes);
        return BitSet.valueOf(bytes);
    }

    public abstract void serializeBitmapReferencesPage(BytesOut<?> var1, List<PageReference> var2, BitSet var3);

    public abstract void serializeReferencesPage4(BytesOut<?> var1, List<PageReference> var2, List<Short> var3);

    public abstract DeserializedBitmapReferencesPageTuple deserializeBitmapReferencesPage(@NonNegative int var1, BytesIn<?> var2);

    public abstract DeserializedReferencesPage4Tuple deserializeReferencesPage4(BytesIn<?> var1);

    public abstract void serializeFullReferencesPage(BytesOut<?> var1, PageReference[] var2);

    public abstract PageReference[] deserializeFullReferencesPage(BytesIn<?> var1);
}

