/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page.delegates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.sirix.page.DeserializedBitmapReferencesPageTuple;
import io.sirix.page.PageReference;
import io.sirix.page.SerializationType;
import io.sirix.page.delegates.ReferencesPage4;
import io.sirix.page.interfaces.Page;
import io.sirix.page.interfaces.PageFragmentKey;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.openhft.chronicle.bytes.BytesIn;
import org.checkerframework.checker.index.qual.NonNegative;
import org.magicwerk.brownies.collections.GapList;

public final class BitmapReferencesPage
implements Page {
    public static final int THRESHOLD = 1008;
    private final List<PageReference> references;
    private final BitSet bitmap;
    private final BitSet offsetBitmap;

    public BitmapReferencesPage(int numberOfEntriesAtMax, ReferencesPage4 pageToCopy) {
        Preconditions.checkArgument((numberOfEntriesAtMax >= 0 ? 1 : 0) != 0);
        this.references = new GapList(8);
        this.bitmap = new BitSet(numberOfEntriesAtMax);
        this.offsetBitmap = new BitSet(this.bitmap.size());
        ShortList offsets = pageToCopy.getOffsets();
        List<PageReference> pageReferences = pageToCopy.getReferences();
        int size = offsets.size();
        for (int i = 0; i < size; ++i) {
            this.setOrCreateReference(offsets.getShort(i), pageReferences.get(i));
        }
    }

    public BitmapReferencesPage(@NonNegative int referenceCount) {
        Preconditions.checkArgument((referenceCount >= 0 ? 1 : 0) != 0);
        int initialSize = referenceCount == 1024 ? referenceCount >> 6 : referenceCount;
        this.references = new GapList(initialSize);
        this.bitmap = new BitSet(referenceCount);
        this.offsetBitmap = new BitSet(this.bitmap.size());
    }

    public BitmapReferencesPage(@NonNegative int referenceCount, BytesIn<?> in, SerializationType type) {
        DeserializedBitmapReferencesPageTuple tuple = type.deserializeBitmapReferencesPage(referenceCount, in);
        this.references = tuple.getReferences();
        this.bitmap = tuple.getBitmap();
        this.offsetBitmap = new BitSet(this.bitmap.size());
    }

    public BitmapReferencesPage(Page pageToClone, BitSet bitSet) {
        this.bitmap = (BitSet)bitSet.clone();
        this.offsetBitmap = new BitSet(this.bitmap.size());
        int length = pageToClone.getReferences().size();
        this.references = new GapList(length);
        for (int offset = 0; offset < length; ++offset) {
            PageReference pageReference = new PageReference();
            PageReference pageReferenceToClone = pageToClone.getReferences().get(offset);
            pageReference.setKey(pageReferenceToClone.getKey());
            pageReference.setLogKey(pageReferenceToClone.getLogKey());
            pageReference.setPageFragments(new ArrayList<PageFragmentKey>(pageReferenceToClone.getPageFragments()));
            this.references.add(offset, pageReference);
        }
    }

    @Override
    public List<PageReference> getReferences() {
        return this.references;
    }

    public BitSet getBitmap() {
        return (BitSet)this.bitmap.clone();
    }

    @Override
    public PageReference getOrCreateReference(@NonNegative int offset) {
        if (this.bitmap.get(offset)) {
            int index = this.index(offset);
            return this.references.get(index);
        }
        return this.createNewReference(offset);
    }

    @Override
    public boolean setOrCreateReference(int offset, PageReference pageReference) {
        int index = this.index(offset);
        if (!this.bitmap.get(offset)) {
            this.references.add(index, pageReference);
        } else {
            this.references.set(index, pageReference);
        }
        this.bitmap.set(index, true);
        return this.bitmap.cardinality() == 1008;
    }

    private PageReference createNewReference(int offset) {
        int index = this.index(offset);
        PageReference pageReference = new PageReference();
        this.references.add(index, pageReference);
        this.bitmap.set(offset, true);
        if (this.bitmap.cardinality() == 1008) {
            return null;
        }
        return pageReference;
    }

    private int index(int offset) {
        this.offsetBitmap.clear();
        this.offsetBitmap.set(offset);
        this.offsetBitmap.flip(0, offset + 1);
        this.offsetBitmap.and(this.bitmap);
        return this.offsetBitmap.cardinality();
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        for (PageReference ref : this.references) {
            helper.add("reference", (Object)ref);
        }
        helper.add("bitmap", (Object)BitmapReferencesPage.dumpBitmap(this.bitmap));
        return helper.toString();
    }

    private static String dumpBitmap(BitSet bitmap) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < bitmap.length(); ++i) {
            s.append(bitmap.get(i) ? 1 : 0);
        }
        return s.toString();
    }

    @Override
    public Page clearPage() {
        this.references.clear();
        this.bitmap.clear();
        return this;
    }
}

