/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page.delegates;

import com.google.common.base.MoreObjects;
import io.sirix.api.PageTrx;
import io.sirix.page.PageReference;
import io.sirix.page.SerializationType;
import io.sirix.page.delegates.BitmapReferencesPage;
import io.sirix.page.interfaces.Page;
import io.sirix.page.interfaces.PageFragmentKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import net.openhft.chronicle.bytes.BytesIn;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class FullReferencesPage
implements Page {
    private final PageReference[] references;

    public FullReferencesPage(BytesIn<?> in, SerializationType type) {
        this.references = type.deserializeFullReferencesPage(in);
    }

    public FullReferencesPage(BitmapReferencesPage pageToClone) {
        this.references = new PageReference[1024];
        BitSet bitSet = pageToClone.getBitmap();
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            PageReference newPageReference;
            PageReference pageReferenceToClone = pageToClone.getReferences().get(i);
            this.references[i] = newPageReference = new PageReference(pageReferenceToClone);
            i = bitSet.nextSetBit(i + 1);
        }
    }

    public FullReferencesPage(FullReferencesPage pageToClone) {
        this.references = new PageReference[1024];
        int size = pageToClone.references.length;
        for (int index = 0; index < size; ++index) {
            PageReference pageReference = new PageReference();
            PageReference pageReferenceToClone = pageToClone.getReferences().get(index);
            if (pageReferenceToClone != null) {
                pageReference.setKey(pageReferenceToClone.getKey());
                pageReference.setLogKey(pageReferenceToClone.getLogKey());
                pageReference.setPageFragments(new ArrayList<PageFragmentKey>(pageReferenceToClone.getPageFragments()));
            }
            this.references[index] = pageReference;
        }
    }

    @Override
    public List<PageReference> getReferences() {
        return Arrays.asList(this.references);
    }

    public PageReference[] getReferencesArray() {
        return this.references;
    }

    @Override
    public PageReference getOrCreateReference(@NonNegative int offset) {
        PageReference newPageReference;
        PageReference pageReference = this.references[offset];
        if (pageReference != null) {
            return pageReference;
        }
        this.references[offset] = newPageReference = new PageReference();
        return newPageReference;
    }

    @Override
    public boolean setOrCreateReference(int offset, PageReference pageReference) {
        this.references[offset] = pageReference;
        return false;
    }

    @Override
    public void commit(@NonNull PageTrx pageWriteTrx) {
        for (PageReference reference : this.references) {
            if (reference == null || reference.getLogKey() == -15) continue;
            pageWriteTrx.commit(reference);
        }
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        for (PageReference ref : this.references) {
            helper.add("reference", (Object)ref);
        }
        return helper.toString();
    }

    @Override
    public Page clearPage() {
        Arrays.fill(this.references, null);
        return Page.super.clearPage();
    }
}

