/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page.delegates;

import com.google.common.base.MoreObjects;
import io.sirix.page.DeserializedReferencesPage4Tuple;
import io.sirix.page.PageReference;
import io.sirix.page.SerializationType;
import io.sirix.page.interfaces.Page;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.bytes.BytesIn;
import org.checkerframework.checker.index.qual.NonNegative;

public final class ReferencesPage4
implements Page {
    private final List<PageReference> references;
    private final ShortList offsets;

    public ReferencesPage4() {
        this.references = new ArrayList<PageReference>(4);
        this.offsets = new ShortArrayList(4);
    }

    public ReferencesPage4(BytesIn<?> in, SerializationType type) {
        DeserializedReferencesPage4Tuple tuple = type.deserializeReferencesPage4(in);
        this.references = tuple.references();
        this.offsets = tuple.offsets();
    }

    public ReferencesPage4(ReferencesPage4 pageToClone) {
        this.references = new ArrayList<PageReference>(4);
        this.offsets = new ShortArrayList(4);
        ShortList otherOffsets = pageToClone.getOffsets();
        int size = otherOffsets.size();
        for (int offset = 0; offset < size; ++offset) {
            this.offsets.add(otherOffsets.getShort(offset));
            PageReference pageReference = new PageReference();
            PageReference pageReferenceToClone = pageToClone.getReferences().get(offset);
            pageReference.setKey(pageReferenceToClone.getKey());
            pageReference.setLogKey(pageReferenceToClone.getLogKey());
            pageReference.setPageFragments(pageReferenceToClone.getPageFragments());
            this.references.add(pageReference);
        }
    }

    public ShortList getOffsets() {
        return this.offsets;
    }

    @Override
    public List<PageReference> getReferences() {
        return this.references;
    }

    @Override
    public PageReference getOrCreateReference(@NonNegative int offset) {
        for (Short currOffset : this.offsets) {
            if (currOffset != offset) continue;
            return this.references.get(offset);
        }
        if (this.offsets.size() < 4) {
            this.offsets.add((short)offset);
            PageReference newReference = new PageReference();
            this.references.add(newReference);
            return newReference;
        }
        return null;
    }

    @Override
    public boolean setOrCreateReference(int offset, PageReference pageReference) {
        int count = this.offsets.size();
        for (int i = 0; i < count; ++i) {
            if (this.offsets.getShort(i) != offset) continue;
            this.references.set(i, pageReference);
            return false;
        }
        if (this.offsets.size() < 4) {
            this.offsets.add((short)offset);
            this.references.add(pageReference);
            return false;
        }
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        ShortListIterator shortListIterator = this.offsets.iterator();
        while (shortListIterator.hasNext()) {
            short offset = (Short)shortListIterator.next();
            helper.add("offset", (int)offset);
        }
        for (PageReference ref : this.references) {
            helper.add("reference", (Object)ref);
        }
        return helper.toString();
    }

    @Override
    public Page clearPage() {
        this.offsets.clear();
        this.references.clear();
        return this;
    }
}

