/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service;

import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.ResourceSession;
import io.sirix.api.visitor.NodeVisitor;
import io.sirix.axis.visitor.VisitorDescendantAxis;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.checkerframework.checker.index.qual.NonNegative;

public abstract class AbstractSerializer<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
implements Callable<Void> {
    protected final ResourceSession<R, W> resMgr;
    protected final LongArrayList stack;
    protected final int[] revisions;
    protected final long startNodeKey;
    protected final NodeVisitor visitor;
    protected boolean hasToSkipSiblings;

    public AbstractSerializer(ResourceSession<R, W> resMgr, NodeVisitor visitor, @NonNegative int revision, int ... revisions) {
        this.visitor = visitor;
        this.stack = new LongArrayList();
        this.revisions = revisions == null ? new int[1] : new int[revisions.length + 1];
        this.initialize(revision, revisions);
        this.resMgr = Objects.requireNonNull(resMgr);
        this.startNodeKey = 0L;
    }

    public AbstractSerializer(ResourceSession<R, W> resMgr, NodeVisitor visitor, @NonNegative long key, @NonNegative int revision, int ... revisions) {
        this.visitor = visitor;
        this.stack = new LongArrayList();
        this.revisions = revisions == null ? new int[1] : new int[revisions.length + 1];
        this.initialize(revision, revisions);
        this.resMgr = Objects.requireNonNull(resMgr);
        this.startNodeKey = key;
    }

    private void initialize(@NonNegative int revision, int ... revisions) {
        this.revisions[0] = revision;
        if (revisions != null) {
            System.arraycopy(revisions, 0, this.revisions, 1, revisions.length);
        }
    }

    @Override
    public Void call() {
        this.emitStartDocument();
        int nrOfRevisions = this.revisions.length;
        int length = nrOfRevisions == 1 && this.revisions[0] < 0 ? this.resMgr.getMostRecentRevisionNumber() : nrOfRevisions;
        for (int i = 1; i <= length; ++i) {
            try (R rtx = this.resMgr.beginNodeReadOnlyTrx(nrOfRevisions == 1 && this.revisions[0] < 0 ? i : this.revisions[i - 1]);){
                this.emitRevisionStartNode(rtx);
                rtx.moveTo(this.startNodeKey);
                VisitorDescendantAxis.Builder builder = VisitorDescendantAxis.newBuilder((NodeCursor)rtx).includeSelf();
                if (this.visitor != null) {
                    builder.visitor(this.visitor);
                    this.setTrxForVisitor(rtx);
                }
                VisitorDescendantAxis descAxis = builder.build();
                boolean closeElements = false;
                while (descAxis.hasNext()) {
                    long key = descAxis.nextLong();
                    if (closeElements) {
                        while (!this.stack.isEmpty() && this.stack.peekLong(0) != ((NodeCursor)rtx).getLeftSiblingKey()) {
                            rtx.moveTo(this.stack.popLong());
                            this.emitEndNode(rtx, false);
                            rtx.moveTo(key);
                        }
                        if (!this.stack.isEmpty()) {
                            rtx.moveTo(this.stack.popLong());
                            this.emitEndNode(rtx, true);
                        }
                        rtx.moveTo(key);
                        closeElements = false;
                    }
                    long nodeKey = rtx.getNodeKey();
                    this.emitNode(rtx);
                    rtx.moveTo(nodeKey);
                    boolean withChildren = false;
                    if (!rtx.isDocumentRoot() && ((NodeCursor)rtx).hasFirstChild() && this.isSubtreeGoingToBeVisited(rtx)) {
                        this.stack.push(rtx.getNodeKey());
                        withChildren = true;
                    }
                    this.hasToSkipSiblings = this.areSiblingNodesGoingToBeSkipped(rtx);
                    if (withChildren || rtx.isDocumentRoot() || ((NodeCursor)rtx).hasRightSibling() && !this.hasToSkipSiblings) continue;
                    closeElements = true;
                }
                while (!this.stack.isEmpty() && this.stack.peekLong(0) != -15L) {
                    rtx.moveTo(this.stack.popLong());
                    this.emitEndNode(rtx, false);
                }
                this.emitRevisionEndNode(rtx);
                continue;
            }
        }
        this.emitEndDocument();
        return null;
    }

    protected abstract void setTrxForVisitor(R var1);

    protected abstract boolean areSiblingNodesGoingToBeSkipped(R var1);

    protected abstract boolean isSubtreeGoingToBeVisited(R var1);

    protected abstract void emitStartDocument();

    protected abstract void emitNode(R var1);

    protected abstract void emitEndNode(R var1, boolean var2);

    protected abstract void emitRevisionStartNode(R var1);

    protected abstract void emitRevisionEndNode(R var1);

    protected abstract void emitEndDocument();
}

