/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.json;

import com.google.common.collect.ImmutableSet;
import io.sirix.access.trx.node.HashType;
import io.sirix.api.JsonDiff;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.json.JsonNodeTrx;
import io.sirix.api.json.JsonResourceSession;
import io.sirix.diff.DiffDepth;
import io.sirix.diff.DiffFactory;
import io.sirix.diff.DiffObserver;
import io.sirix.diff.DiffTuple;
import io.sirix.diff.JsonDiffSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BasicJsonDiff
implements DiffObserver,
JsonDiff {
    private final List<DiffTuple> diffs;
    private final String databaseName;

    public BasicJsonDiff(String databaseName) {
        this.databaseName = databaseName;
        this.diffs = new ArrayList<DiffTuple>();
    }

    @Override
    public String generateDiff(JsonResourceSession resourceManager, int oldRevisionNumber, int newRevisionNumber) {
        return this.generateDiff(resourceManager, oldRevisionNumber, newRevisionNumber, 0L, 0L);
    }

    @Override
    public String generateDiff(JsonResourceSession resourceManager, int oldRevisionNumber, int newRevisionNumber, long startNodeKey, long maxDepth) {
        this.diffs.clear();
        DiffFactory.invokeJsonDiff(new DiffFactory.Builder<JsonNodeReadOnlyTrx, JsonNodeTrx>(resourceManager, newRevisionNumber, oldRevisionNumber, resourceManager.getResourceConfig().hashType == HashType.NONE ? DiffFactory.DiffOptimized.NO : DiffFactory.DiffOptimized.HASHED, (Set<DiffObserver>)ImmutableSet.of((Object)this)).skipSubtrees(true).newStartKey(startNodeKey).oldStartKey(startNodeKey).oldMaxDepth(maxDepth));
        return new JsonDiffSerializer(this.databaseName, resourceManager, oldRevisionNumber, newRevisionNumber, this.diffs).serialize(true);
    }

    @Override
    public void diffListener(@NonNull DiffFactory.DiffType diffType, long newNodeKey, long oldNodeKey, @NonNull DiffDepth depth) {
        this.diffs.add(new DiffTuple(diffType, newNodeKey, oldNodeKey, depth));
    }

    @Override
    public void diffDone() {
    }
}

