/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.json.serialize;

import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.visitor.JsonNodeVisitor;
import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.VisitResultType;
import io.sirix.axis.IncludeSelf;
import io.sirix.node.NodeKind;
import io.sirix.node.immutable.json.ImmutableArrayNode;
import io.sirix.node.immutable.json.ImmutableBooleanNode;
import io.sirix.node.immutable.json.ImmutableJsonDocumentRootNode;
import io.sirix.node.immutable.json.ImmutableNullNode;
import io.sirix.node.immutable.json.ImmutableNumberNode;
import io.sirix.node.immutable.json.ImmutableObjectBooleanNode;
import io.sirix.node.immutable.json.ImmutableObjectKeyNode;
import io.sirix.node.immutable.json.ImmutableObjectNode;
import io.sirix.node.immutable.json.ImmutableObjectNullNode;
import io.sirix.node.immutable.json.ImmutableObjectNumberNode;
import io.sirix.node.immutable.json.ImmutableObjectStringNode;
import io.sirix.node.immutable.json.ImmutableStringNode;
import io.sirix.node.interfaces.immutable.ImmutableStructNode;
import java.util.ArrayDeque;
import java.util.Deque;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class JsonMaxLevelMaxNodesMaxChildNodesVisitor
implements JsonNodeVisitor {
    private final Deque<Long> rightSiblingNodeKeyStack;
    private final long startNodeKey;
    private final long maxLevel;
    private final long maxNodes;
    private final IncludeSelf includeSelf;
    private final long maxChildNodes;
    private long currentChildNodes = 1L;
    private long numberOfVisitedNodesPlusOne = 1L;
    private JsonNodeReadOnlyTrx rtx;
    private long currentLevel = 1L;
    private VisitResultType lastVisitResultType;
    private boolean isFirst = true;
    private boolean deweyIDsAreStored;
    private long startNodeLevel;
    private final Deque<Long> currentChildNodesPerLevel = new ArrayDeque<Long>();
    private long lastVisitedNodeKey;

    public JsonMaxLevelMaxNodesMaxChildNodesVisitor(long startNodeKey, IncludeSelf includeSelf, long maxLevel, long maxNodes, long maxChildNodes) {
        this.startNodeKey = startNodeKey;
        this.includeSelf = includeSelf;
        this.maxLevel = maxLevel;
        this.maxNodes = maxNodes;
        this.maxChildNodes = maxChildNodes;
        this.rightSiblingNodeKeyStack = new ArrayDeque<Long>();
    }

    public JsonMaxLevelMaxNodesMaxChildNodesVisitor setTrx(JsonNodeReadOnlyTrx rtx) {
        this.rtx = rtx;
        this.deweyIDsAreStored = rtx.getResourceSession().getResourceConfig().areDeweyIDsStored;
        if (this.deweyIDsAreStored) {
            long nodeKey = rtx.getNodeKey();
            rtx.moveTo(this.startNodeKey);
            this.startNodeLevel = rtx.getDeweyID().getLevel();
            rtx.moveTo(nodeKey);
            if (rtx.isObjectKey()) {
                this.numberOfVisitedNodesPlusOne = 2L;
            }
        }
        return this;
    }

    public long getNumberOfVisitedNodesPlusOne() {
        return this.numberOfVisitedNodesPlusOne;
    }

    public long getCurrentLevel() {
        return this.currentLevel;
    }

    public long getCurrentChildNodes() {
        return this.currentChildNodes;
    }

    public long getMaxNodes() {
        return this.maxNodes;
    }

    public long getMaxLevel() {
        return this.maxLevel;
    }

    public long getMaxChildNodes() {
        return this.maxChildNodes;
    }

    public VisitResultType getLastVisitResultType() {
        return this.lastVisitResultType;
    }

    private VisitResult getVisitResultType(ImmutableStructNode node) {
        if (this.hasToTerminateTraversal()) {
            this.lastVisitResultType = VisitResultType.TERMINATE;
            return this.lastVisitResultType;
        }
        if (this.currentLevel > this.maxLevel) {
            this.lastVisitResultType = VisitResultType.SKIPSUBTREE;
            return this.lastVisitResultType;
        }
        if (this.hasToSkipSiblingNodes()) {
            return this.adaptCurrentChildNodesAndLevelAndReturnSkipSiblingsResultType(node);
        }
        this.lastVisitResultType = VisitResultType.CONTINUE;
        this.lastVisitedNodeKey = this.rtx.getNodeKey();
        return this.lastVisitResultType;
    }

    private void adaptLevel(ImmutableStructNode node) {
        if (this.isFirst) {
            return;
        }
        if (node.getNodeKey() != this.startNodeKey && node.getNodeKey() == this.lastVisitedNodeKey) {
            return;
        }
        if (node.hasFirstChild() && this.currentChildNodes <= this.maxChildNodes) {
            ++this.currentLevel;
            if (node.hasRightSibling()) {
                this.currentChildNodesPerLevel.push(this.currentChildNodes);
            }
            if (this.deweyIDsAreStored && node.hasRightSibling() && this.currentChildNodes + 1L <= this.maxChildNodes) {
                this.rightSiblingNodeKeyStack.push(node.getRightSiblingKey());
            }
            this.currentChildNodes = 1L;
        } else if (!node.hasRightSibling()) {
            this.adaptChildNodesAndLevel(node);
        } else {
            ++this.currentChildNodes;
        }
    }

    private void adaptChildNodesAndLevel(ImmutableStructNode node) {
        if (this.currentChildNodes <= this.maxChildNodes) {
            this.adaptCurrentChildNodes();
        }
        this.ancestorLevel(node);
    }

    private void ancestorLevel(ImmutableStructNode node) {
        if (this.deweyIDsAreStored) {
            if (this.rightSiblingNodeKeyStack.isEmpty()) {
                this.currentLevel = 1L;
            } else {
                long nextNodeKey = this.rightSiblingNodeKeyStack.pop();
                this.rtx.moveTo(nextNodeKey);
                this.currentLevel = this.startNodeLevel == 0L ? (long)this.rtx.getDeweyID().getLevel() : (long)this.rtx.getDeweyID().getLevel() - this.startNodeLevel + 1L;
                this.rtx.moveTo(node.getNodeKey());
            }
        } else {
            do {
                if (this.rtx.getParentKind() != NodeKind.OBJECT_KEY) {
                    --this.currentLevel;
                }
                this.rtx.moveToParent();
            } while (!this.rtx.hasRightSibling() && this.currentLevel > 1L);
        }
    }

    private boolean hasToTerminateTraversal() {
        return this.numberOfVisitedNodesPlusOne > this.maxNodes && this.rtx.getKind() != NodeKind.OBJECT_KEY;
    }

    @Override
    public VisitResult visit(ImmutableArrayNode node) {
        this.adaptLevel(node);
        this.incrementNumberOfVisitedNodesIfRequired(node.getNodeKey());
        this.isFirst = false;
        return this.getVisitResultType(node);
    }

    @Override
    public VisitResult visit(ImmutableObjectNode node) {
        this.adaptLevel(node);
        this.incrementNumberOfVisitedNodesIfRequired(node.getNodeKey());
        this.isFirst = false;
        return this.getVisitResultType(node);
    }

    private boolean hasToAddNumberOfVisitedNodes(long nodeKey) {
        return !this.isFirst && (this.lastVisitedNodeKey != nodeKey || this.startNodeKey == nodeKey);
    }

    @Override
    public VisitResult visit(ImmutableObjectKeyNode node) {
        if (this.deweyIDsAreStored && node.hasRightSibling() && this.currentChildNodes + 1L <= this.maxChildNodes) {
            this.rightSiblingNodeKeyStack.push(node.getRightSiblingKey());
        }
        this.adaptCurrentChildNodesForObjectKeyNodes(node);
        this.incrementNumberOfVisitedNodesIfRequired(node.getNodeKey());
        this.isFirst = false;
        return this.determineAndGetVisitResultType(node);
    }

    private void adaptCurrentChildNodesForObjectKeyNodes(ImmutableObjectKeyNode node) {
        if (node.hasFirstChild()) {
            if (node.hasRightSibling() && this.currentChildNodes <= this.maxChildNodes) {
                this.currentChildNodesPerLevel.push(this.currentChildNodes);
            }
        } else if (node.hasRightSibling()) {
            ++this.currentChildNodes;
        } else {
            this.adaptCurrentChildNodes();
        }
    }

    @Override
    public VisitResult visit(ImmutableBooleanNode node) {
        this.adaptLevel(node);
        this.isFirst = false;
        this.incrementNumberOfVisitedNodesIfRequired(node.getNodeKey());
        return this.determineAndGetVisitResultType(node);
    }

    private void adaptCurrentChildNodes() {
        this.currentChildNodes = this.currentChildNodesPerLevel.isEmpty() ? this.maxChildNodes + 1L : this.currentChildNodesPerLevel.pop() + 1L;
    }

    @Override
    public VisitResult visit(ImmutableStringNode node) {
        this.adaptLevel(node);
        this.isFirst = false;
        this.incrementNumberOfVisitedNodesIfRequired(node.getNodeKey());
        return this.determineAndGetVisitResultType(node);
    }

    @Override
    public VisitResult visit(ImmutableNumberNode node) {
        this.adaptLevel(node);
        this.isFirst = false;
        this.incrementNumberOfVisitedNodesIfRequired(node.getNodeKey());
        return this.determineAndGetVisitResultType(node);
    }

    @Override
    public VisitResult visit(ImmutableNullNode node) {
        this.adaptLevel(node);
        this.isFirst = false;
        this.incrementNumberOfVisitedNodesIfRequired(node.getNodeKey());
        return this.determineAndGetVisitResultType(node);
    }

    private void incrementNumberOfVisitedNodesIfRequired(long nodeKey) {
        if (this.hasToAddNumberOfVisitedNodes(nodeKey)) {
            ++this.numberOfVisitedNodesPlusOne;
        }
    }

    @Override
    public VisitResult visit(ImmutableObjectBooleanNode node) {
        this.adaptLevel(node);
        this.isFirst = false;
        this.incrementNumberOfVisitedNodesIfRequired(node.getNodeKey());
        return this.determineAndGetVisitResultType(node);
    }

    private boolean hasToSkipSiblingNodes() {
        return this.currentChildNodes > this.maxChildNodes;
    }

    @Override
    public VisitResult visit(ImmutableObjectStringNode node) {
        this.adaptLevel(node);
        this.isFirst = false;
        this.incrementNumberOfVisitedNodesIfRequired(node.getNodeKey());
        return this.determineAndGetVisitResultType(node);
    }

    @Override
    public VisitResult visit(ImmutableObjectNumberNode node) {
        this.adaptLevel(node);
        this.isFirst = false;
        this.incrementNumberOfVisitedNodesIfRequired(node.getNodeKey());
        return this.determineAndGetVisitResultType(node);
    }

    @Override
    public VisitResult visit(ImmutableObjectNullNode node) {
        this.adaptLevel(node);
        this.isFirst = false;
        this.incrementNumberOfVisitedNodesIfRequired(node.getNodeKey());
        return this.determineAndGetVisitResultType(node);
    }

    private VisitResultType determineAndGetVisitResultType(ImmutableStructNode node) {
        if (this.hasToTerminateTraversal()) {
            this.lastVisitResultType = VisitResultType.TERMINATE;
            return this.lastVisitResultType;
        }
        if (this.hasToSkipSiblingNodes()) {
            return this.adaptCurrentChildNodesAndLevelAndReturnSkipSiblingsResultType(node);
        }
        this.lastVisitedNodeKey = node.getNodeKey();
        return VisitResultType.CONTINUE;
    }

    private @NonNull VisitResultType adaptCurrentChildNodesAndLevelAndReturnSkipSiblingsResultType(ImmutableStructNode node) {
        long nodeKey = this.rtx.getNodeKey();
        if (this.rtx.getParentKind() != NodeKind.OBJECT_KEY || !this.rtx.moveToParent() || !this.rtx.hasRightSibling()) {
            this.adaptCurrentChildNodes();
            this.ancestorLevel(node);
        }
        this.rtx.moveTo(nodeKey);
        this.lastVisitResultType = VisitResultType.SKIPSIBLINGS;
        return this.lastVisitResultType;
    }

    @Override
    public VisitResult visit(ImmutableJsonDocumentRootNode node) {
        this.incrementNumberOfVisitedNodesIfRequired(node.getNodeKey());
        this.isFirst = false;
        return VisitResultType.CONTINUE;
    }
}

