/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.json.serialize;

import com.google.common.base.Preconditions;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.json.JsonResourceSession;
import io.sirix.service.json.serialize.JsonSerializer;
import io.sirix.service.json.serialize.JsonSerializerProperties;
import io.sirix.service.xml.serialize.XmlSerializerProperties;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.index.qual.NonNegative;

public final class JsonRecordSerializer
implements Callable<Void> {
    private final long maxLevel;
    private final JsonResourceSession resourceMgr;
    private final int numberOfRecords;
    private final long numberOfNodes;
    private final long maxChildNodes;
    private final Appendable out;
    private final boolean indent;
    private final int indentSpaces;
    private final boolean withInitialIndent;
    private final boolean serializeTimestamp;
    private final boolean withMetaData;
    private final boolean withNodeKeyMetaData;
    private final boolean withNodeKeyAndChildNodeKeyMetaData;
    private boolean hadToAddBracket;
    private int currentIndent;
    private final int[] revisions;
    private long lastTopLevelNodeKey;

    private JsonRecordSerializer(JsonResourceSession resourceMgr, Builder builder, @NonNegative int revision, int ... revisions) {
        this.numberOfRecords = builder.numberOfRecords;
        this.revisions = revisions == null ? new int[1] : new int[revisions.length + 1];
        this.resourceMgr = resourceMgr;
        this.initialize(revision, revisions);
        this.maxLevel = builder.maxLevel;
        this.maxChildNodes = builder.maxChildNodes;
        this.out = builder.stream;
        this.indent = builder.indent;
        this.indentSpaces = builder.indentSpaces;
        this.withInitialIndent = builder.initialIndent;
        this.serializeTimestamp = builder.serializeTimestamp;
        this.withMetaData = builder.withMetaData;
        this.withNodeKeyMetaData = builder.withNodeKey;
        this.withNodeKeyAndChildNodeKeyMetaData = builder.withNodeKeyAndChildCount;
        this.lastTopLevelNodeKey = builder.lastTopLevelNodeKey;
        this.numberOfNodes = builder.maxNodes;
    }

    private void initialize(@NonNegative int revision, int ... revisions) {
        this.revisions[0] = revision;
        if (revisions != null) {
            System.arraycopy(revisions, 0, this.revisions, 1, revisions.length);
        }
    }

    public static Builder newBuilder(JsonResourceSession resMgr, int numberOfRecords, Writer writer, int ... revisions) {
        return new Builder(resMgr, numberOfRecords, writer, revisions);
    }

    public static Builder newBuilder(JsonResourceSession resMgr, int numberOfRecords, @NonNegative long nodeKey, Writer writer, JsonSerializerProperties properties, int ... revisions) {
        return new Builder(resMgr, numberOfRecords, nodeKey, writer, properties, revisions);
    }

    @Override
    public Void call() {
        State state = State.IS_PRIMITIVE;
        int nrOfRevisions = this.revisions.length;
        int length = nrOfRevisions == 1 && this.revisions[0] < 0 ? this.resourceMgr.getMostRecentRevisionNumber() : nrOfRevisions;
        for (int i = 1; i <= length; ++i) {
            try (JsonNodeReadOnlyTrx rtx = (JsonNodeReadOnlyTrx)this.resourceMgr.beginNodeReadOnlyTrx(nrOfRevisions == 1 && this.revisions[0] < 0 ? i : this.revisions[i - 1]);){
                rtx.moveToDocumentRoot();
                if (!rtx.hasFirstChild()) continue;
                rtx.moveToFirstChild();
                JsonSerializer jsonSerializer = new JsonSerializer.Builder(rtx.getResourceSession(), this.out, this.revisions).startNodeKey(rtx.getNodeKey()).serializeStartNodeWithBrackets(false).serializeTimestamp(this.serializeTimestamp).withMetaData(this.withMetaData).withNodeKeyAndChildCountMetaData(this.withNodeKeyAndChildNodeKeyMetaData).withNodeKeyMetaData(this.withNodeKeyMetaData).numberOfNodes(this.numberOfNodes).build();
                jsonSerializer.emitNode(rtx);
                if (rtx.isObject()) {
                    state = State.IS_OBJECT;
                } else if (rtx.isArray()) {
                    state = State.IS_ARRAY;
                }
                if (rtx.hasFirstChild()) {
                    boolean hasMoved = false;
                    if (this.lastTopLevelNodeKey != 0L) {
                        rtx.moveTo(this.lastTopLevelNodeKey);
                        if (rtx.hasRightSibling()) {
                            rtx.moveToRightSibling();
                            hasMoved = true;
                        }
                    } else {
                        rtx.moveToFirstChild();
                        hasMoved = true;
                    }
                    if (hasMoved) {
                        long nodeKey = rtx.getNodeKey();
                        jsonSerializer = new JsonSerializer.Builder(rtx.getResourceSession(), this.out, this.revisions).startNodeKey(nodeKey).serializeStartNodeWithBrackets(false).maxLevel(this.maxLevel).maxChildren(this.maxChildNodes).serializeTimestamp(this.serializeTimestamp).withMetaData(this.withMetaData).withNodeKeyAndChildCountMetaData(this.withNodeKeyAndChildNodeKeyMetaData).withNodeKeyMetaData(this.withNodeKeyMetaData).numberOfNodes(this.numberOfNodes).build();
                        jsonSerializer.call();
                        if (rtx.isObjectKey() && (this.withMetaData || this.withNodeKeyAndChildNodeKeyMetaData || this.withNodeKeyMetaData)) {
                            this.out.append("}");
                        }
                        rtx.moveTo(nodeKey);
                        if (rtx.hasRightSibling()) {
                            for (int j = 1; j < this.numberOfRecords && rtx.hasRightSibling(); ++j) {
                                rtx.moveToRightSibling();
                                nodeKey = rtx.getNodeKey();
                                this.out.append(",");
                                if (rtx.isObjectKey() && (this.withMetaData || this.withNodeKeyAndChildNodeKeyMetaData || this.withNodeKeyMetaData)) {
                                    this.out.append("{");
                                }
                                jsonSerializer = new JsonSerializer.Builder(rtx.getResourceSession(), this.out, this.revisions).startNodeKey(nodeKey).serializeStartNodeWithBrackets(false).maxLevel(this.maxLevel).maxChildren(this.maxChildNodes).serializeTimestamp(this.serializeTimestamp).withMetaData(this.withMetaData).withNodeKeyAndChildCountMetaData(this.withNodeKeyAndChildNodeKeyMetaData).withNodeKeyMetaData(this.withNodeKeyMetaData).numberOfNodes(this.numberOfNodes).build();
                                jsonSerializer.call();
                                if (rtx.isObjectKey() && (this.withMetaData || this.withNodeKeyAndChildNodeKeyMetaData || this.withNodeKeyMetaData)) {
                                    this.out.append("}");
                                }
                                rtx.moveTo(nodeKey);
                            }
                        }
                    }
                }
                if (state == State.IS_OBJECT) {
                    if (this.withMetaData || this.withNodeKeyAndChildNodeKeyMetaData || this.withNodeKeyMetaData) {
                        this.out.append("]");
                    }
                    this.out.append("}");
                    continue;
                }
                if (state != State.IS_ARRAY) continue;
                if (this.withMetaData || this.withNodeKeyAndChildNodeKeyMetaData || this.withNodeKeyMetaData) {
                    this.out.append("]}");
                    continue;
                }
                this.out.append("]");
                continue;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return null;
    }

    public static final class Builder {
        private boolean indent;
        private int indentSpaces = 2;
        private final Appendable stream;
        private final JsonResourceSession resourceMgr;
        private final int numberOfRecords;
        private int[] versions;
        private int version;
        private long nodeKey;
        private boolean initialIndent;
        private boolean serializeTimestamp;
        private boolean withMetaData;
        private long maxLevel = Long.MAX_VALUE;
        private boolean withNodeKey;
        private boolean withNodeKeyAndChildCount;
        private long lastTopLevelNodeKey;
        private long maxNodes = Long.MAX_VALUE;
        private long maxChildNodes = Long.MAX_VALUE;

        public Builder(JsonResourceSession resourceMgr, int numberOfRecords, Appendable stream, int ... revisions) {
            this.numberOfRecords = numberOfRecords;
            this.nodeKey = 0L;
            this.resourceMgr = Objects.requireNonNull(resourceMgr);
            this.stream = Objects.requireNonNull(stream);
            if (revisions == null || revisions.length == 0) {
                this.version = this.resourceMgr.getMostRecentRevisionNumber();
            } else {
                this.version = revisions[0];
                this.versions = new int[revisions.length - 1];
                System.arraycopy(revisions, 1, this.versions, 0, revisions.length - 1);
            }
        }

        public Builder(JsonResourceSession resourceMgr, int numberOfRecords, @NonNegative long nodeKey, Writer stream, JsonSerializerProperties properties, int ... revisions) {
            Preconditions.checkArgument((nodeKey >= 0L ? 1 : 0) != 0, (Object)"nodeKey must be >= 0!");
            this.numberOfRecords = numberOfRecords;
            this.maxLevel = -1L;
            this.resourceMgr = Objects.requireNonNull(resourceMgr);
            this.nodeKey = nodeKey;
            this.stream = Objects.requireNonNull(stream);
            if (revisions == null || revisions.length == 0) {
                this.version = this.resourceMgr.getMostRecentRevisionNumber();
            } else {
                this.version = revisions[0];
                this.versions = new int[revisions.length - 1];
                System.arraycopy(revisions, 1, this.versions, 0, revisions.length - 1);
            }
            ConcurrentMap<String, Object> map = Objects.requireNonNull(properties.getProps());
            this.indent = Objects.requireNonNull((Boolean)map.get(XmlSerializerProperties.S_INDENT[0]));
            this.indentSpaces = Objects.requireNonNull((Integer)map.get(XmlSerializerProperties.S_INDENT_SPACES[0]));
        }

        public Builder startNodeKey(long nodeKey) {
            this.nodeKey = nodeKey;
            return this;
        }

        public Builder lastTopLevelNodeKey(long nodeKey) {
            this.lastTopLevelNodeKey = nodeKey;
            return this;
        }

        public Builder numberOfNodes(long maxNodes) {
            this.maxNodes = maxNodes;
            return this;
        }

        public Builder maxLevel(long maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        public Builder maxChildren(long maxChildren) {
            this.maxChildNodes = maxChildren;
            return this;
        }

        public Builder withInitialIndent() {
            this.initialIndent = true;
            return this;
        }

        public Builder serializeTimestamp(boolean serializeTimestamp) {
            this.serializeTimestamp = serializeTimestamp;
            return this;
        }

        public Builder withMetaData(boolean withMetaData) {
            this.withMetaData = withMetaData;
            this.withNodeKey = true;
            this.withNodeKeyAndChildCount = true;
            return this;
        }

        public Builder withNodeKeyMetaData(boolean withNodeKey) {
            this.withNodeKey = withNodeKey;
            return this;
        }

        public Builder withNodeKeyAndChildCountMetaData(boolean withNodeKeyAndChildCount) {
            this.withNodeKeyAndChildCount = withNodeKeyAndChildCount;
            return this;
        }

        public Builder prettyPrint() {
            this.indent = true;
            return this;
        }

        public Builder revisions(int[] revisions) {
            Objects.requireNonNull(revisions);
            this.version = revisions[0];
            this.versions = new int[revisions.length - 1];
            System.arraycopy(revisions, 1, this.versions, 0, revisions.length - 1);
            return this;
        }

        public JsonRecordSerializer build() {
            return new JsonRecordSerializer(this.resourceMgr, this, this.version, this.versions);
        }
    }

    private static enum State {
        IS_OBJECT,
        IS_ARRAY,
        IS_PRIMITIVE;

    }
}

