/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.json.serialize;

import java.util.HashMap;

public final class StringValue {
    public static String escape(String value) {
        HashMap<Character, String> asciiCharacters = new HashMap<Character, String>(){
            {
                this.put(Character.valueOf('\"'), "\\\"");
                this.put(Character.valueOf('\\'), "\\\\");
                this.put(Character.valueOf('\b'), "\\b");
                this.put(Character.valueOf('\f'), "\\f");
                this.put(Character.valueOf('\n'), "\\n");
                this.put(Character.valueOf('\r'), "\\r");
                this.put(Character.valueOf('\t'), "\\t");
                this.put(Character.valueOf('/'), "\\/");
            }
        };
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            sb.append(asciiCharacters.computeIfAbsent(Character.valueOf(ch), StringValue::escapeUnicode));
        }
        return sb.toString();
    }

    private static String escapeUnicode(char ch) {
        StringBuilder sb = new StringBuilder();
        if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
            String ss = Integer.toHexString(ch);
            sb.append("\\u");
            sb.append("0".repeat(4 - ss.length()));
            sb.append(ss.toUpperCase());
        } else {
            sb.append(ch);
        }
        return sb.toString();
    }
}

