/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.json.shredder;

import com.google.common.collect.AbstractIterator;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.sirix.axis.IncludeSelf;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;

public final class JsonItemIterator
extends AbstractIterator<Item> {
    private final IncludeSelf includeSelf;
    private final Deque<Iter> iter;
    private boolean first;
    private final Item item;

    public JsonItemIterator(Item item, IncludeSelf includeSelf) {
        this.item = Objects.requireNonNull(item);
        this.includeSelf = Objects.requireNonNull(includeSelf);
        this.iter = new ArrayDeque<Iter>();
        this.iter.push(item.iterate());
    }

    protected Item computeNext() {
        if (this.first && this.includeSelf == IncludeSelf.YES) {
            this.first = false;
            Iter currIter = this.item.iterate();
            this.iter.push(currIter);
            return this.item;
        }
        Item currItem = null;
        while (currItem == null && !this.iter.isEmpty()) {
            Iter iterator = this.iter.peek();
            try {
                currItem = iterator.next();
            }
            finally {
                if (iterator == null) continue;
                iterator.close();
            }
        }
        if (currItem != null) {
            this.iter.push(currItem.iterate());
        }
        return currItem;
    }
}

