/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.json.shredder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.trx.node.json.InsertOperations;
import io.sirix.access.trx.node.json.objectvalue.ArrayValue;
import io.sirix.access.trx.node.json.objectvalue.BooleanValue;
import io.sirix.access.trx.node.json.objectvalue.NullValue;
import io.sirix.access.trx.node.json.objectvalue.NumberValue;
import io.sirix.access.trx.node.json.objectvalue.ObjectValue;
import io.sirix.access.trx.node.json.objectvalue.StringValue;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.json.JsonNodeTrx;
import io.sirix.api.json.JsonResourceSession;
import io.sirix.axis.DescendantAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.node.NodeKind;
import io.sirix.service.InsertPosition;
import io.sirix.service.ShredderCommit;
import io.sirix.settings.Fixed;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.Callable;

public final class JsonResourceCopy
implements Callable<Void> {
    private final String INSERT = InsertOperations.INSERT.getName();
    private final String UPDATE = InsertOperations.UPDATE.getName();
    private final String DELETE = InsertOperations.DELETE.getName();
    private final String REPLACE = InsertOperations.REPLACE.getName();
    private final JsonResourceSession readResourceSession;
    private final JsonNodeTrx wtx;
    private final ShredderCommit commit;
    private final JsonNodeReadOnlyTrx rtx;
    private final long startNodeKey;
    private final InsertPosition insert;
    private final boolean copyAllRevisionsUpToMostRecent;
    private final LongArrayList stack = new LongArrayList();

    private JsonResourceCopy(JsonNodeTrx wtx, JsonNodeReadOnlyTrx rtx, Builder builder) {
        this.wtx = wtx;
        this.rtx = rtx;
        this.readResourceSession = rtx.getResourceSession();
        this.insert = builder.insert;
        this.commit = builder.commit;
        this.startNodeKey = rtx.getNodeKey();
        this.copyAllRevisionsUpToMostRecent = builder.copyAllRevisionsUpToMostRecent;
    }

    @Override
    public Void call() {
        this.rtx.moveTo(this.startNodeKey);
        boolean moveToParent = false;
        boolean first = true;
        long previousKey = Fixed.NULL_NODE_KEY.getStandardProperty();
        this.insert(moveToParent, first, previousKey);
        if (this.copyAllRevisionsUpToMostRecent) {
            this.wtx.commit();
            for (int revision = this.rtx.getRevisionNumber() + 1; revision <= this.rtx.getResourceSession().getMostRecentRevisionNumber(); ++revision) {
                try (JsonNodeReadOnlyTrx rtxOnRevision = (JsonNodeReadOnlyTrx)this.readResourceSession.beginNodeReadOnlyTrx(revision);){
                    JsonElement jsonElement;
                    Path updateOperationsFile = this.readResourceSession.getResourceConfig().getResource().resolve(ResourceConfiguration.ResourcePaths.UPDATE_OPERATIONS.getPath()).resolve("diffFromRev" + (revision - 1) + "toRev" + revision + ".json");
                    try {
                        jsonElement = JsonParser.parseString((String)Files.readString(updateOperationsFile));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    JsonArray diffsArray = jsonObject.getAsJsonArray("diffs");
                    for (JsonElement diffsElement : diffsArray) {
                        JsonObject diffsObject = diffsElement.getAsJsonObject();
                        if (diffsObject.has(this.INSERT)) {
                            JsonObject insertObject = diffsObject.getAsJsonObject(this.INSERT);
                            this.executeInsert(insertObject, rtxOnRevision);
                            continue;
                        }
                        if (diffsObject.has(this.REPLACE)) {
                            JsonObject replaceObject = diffsObject.getAsJsonObject(this.REPLACE);
                            this.executeReplace(replaceObject, rtxOnRevision);
                            continue;
                        }
                        if (diffsObject.has(this.UPDATE)) {
                            JsonObject updateObject = diffsObject.getAsJsonObject(this.UPDATE);
                            this.executeUpdate(updateObject, rtxOnRevision);
                            continue;
                        }
                        if (!diffsObject.has(this.DELETE)) continue;
                        long nodeKey = diffsObject.getAsJsonPrimitive(this.DELETE).getAsLong();
                        this.executeDelete(nodeKey);
                    }
                    this.wtx.commit();
                    continue;
                }
            }
        } else {
            this.commit.commit(this.wtx);
        }
        return null;
    }

    private void executeDelete(long nodeKey) {
        this.wtx.moveTo(nodeKey);
        this.wtx.remove();
    }

    private void executeUpdate(JsonObject updateObject, JsonNodeReadOnlyTrx rtxOnRevision) {
        long key = updateObject.get("nodeKey").getAsLong();
        String type = updateObject.get("type").getAsString();
        rtxOnRevision.moveTo(key);
        this.wtx.moveTo(key);
        switch (type) {
            case "boolean": {
                this.wtx.setBooleanValue(rtxOnRevision.getBooleanValue());
                break;
            }
            case "string": {
                this.wtx.setStringValue(rtxOnRevision.getValue());
                break;
            }
            case "number": {
                this.wtx.setNumberValue(rtxOnRevision.getNumberValue());
            }
        }
    }

    private void executeReplace(JsonObject replaceObject, JsonNodeReadOnlyTrx rtxOnRevision) {
        long oldNodeKey = replaceObject.get("oldNodeKey").getAsLong();
        long newNodeKey = replaceObject.get("newNodeKey").getAsLong();
        String type = replaceObject.get("type").getAsString();
        this.wtx.moveTo(oldNodeKey);
        rtxOnRevision.moveTo(newNodeKey);
        String insertPosition = this.wtx.hasRightSibling() ? "insertAsLeftSibling" : (this.wtx.hasLeftSibling() ? "insertAsRightSibling" : "insertAsFirstChild");
        if (this.wtx.getParentKind() == NodeKind.OBJECT_KEY) {
            this.wtx.moveToParent();
            switch (rtxOnRevision.getKind()) {
                case OBJECT: {
                    this.wtx.replaceObjectRecordValue(new ObjectValue());
                    break;
                }
                case ARRAY: {
                    this.wtx.replaceObjectRecordValue(new ArrayValue());
                    break;
                }
                case OBJECT_NUMBER_VALUE: 
                case NUMBER_VALUE: {
                    this.wtx.replaceObjectRecordValue(new NumberValue(rtxOnRevision.getNumberValue()));
                    break;
                }
                case OBJECT_NULL_VALUE: 
                case NULL_VALUE: {
                    this.wtx.replaceObjectRecordValue(new NullValue());
                    break;
                }
                case OBJECT_STRING_VALUE: 
                case STRING_VALUE: {
                    this.wtx.replaceObjectRecordValue(new StringValue(rtxOnRevision.getValue()));
                    break;
                }
                case OBJECT_BOOLEAN_VALUE: 
                case BOOLEAN_VALUE: {
                    this.wtx.replaceObjectRecordValue(new BooleanValue(rtxOnRevision.getBooleanValue()));
                }
            }
        } else {
            this.wtx.remove();
            this.insert(type, rtxOnRevision, insertPosition);
        }
    }

    private void executeInsert(JsonObject insertObject, JsonNodeReadOnlyTrx rtxOnRevision) {
        long key = insertObject.get("nodeKey").getAsLong();
        String insertPosition = insertObject.get("insertPosition").getAsString();
        long insertPositionNodeKey = insertObject.get("insertPositionNodeKey").getAsLong();
        String type = insertObject.get("type").getAsString();
        this.wtx.moveTo(insertPositionNodeKey);
        rtxOnRevision.moveTo(key);
        this.insert(type, rtxOnRevision, insertPosition);
    }

    private void insert(String type, JsonNodeReadOnlyTrx rtxOnRevision, String insertPosition) {
        switch (type) {
            case "jsonFragment": {
                this.insertFragment(rtxOnRevision, insertPosition);
                break;
            }
            case "boolean": {
                if (insertPosition.equals("asFirstChild")) {
                    this.wtx.insertBooleanValueAsFirstChild(rtxOnRevision.getBooleanValue());
                    break;
                }
                this.wtx.insertBooleanValueAsRightSibling(rtxOnRevision.getBooleanValue());
                break;
            }
            case "null": {
                if (insertPosition.equals("asFirstChild")) {
                    this.wtx.insertNullValueAsFirstChild();
                    break;
                }
                this.wtx.insertNullValueAsRightSibling();
                break;
            }
            case "string": {
                if (insertPosition.equals("asFirstChild")) {
                    this.wtx.insertStringValueAsFirstChild(rtxOnRevision.getValue());
                    break;
                }
                this.wtx.insertStringValueAsRightSibling(rtxOnRevision.getValue());
            }
        }
    }

    private void insertFragment(JsonNodeReadOnlyTrx rtxOnRevision, String insertPosition) {
        JsonResourceCopy copyResource = new Builder(this.wtx, rtxOnRevision, InsertPosition.ofString(insertPosition)).build();
        copyResource.call();
    }

    private void insert(boolean moveToParent, boolean isFirst, long previousKey) {
        DescendantAxis axis = new DescendantAxis(this.rtx, IncludeSelf.YES);
        while (axis.hasNext()) {
            long key = axis.nextLong();
            if (moveToParent) {
                while (!this.stack.isEmpty() && this.stack.peekLong(0) != this.rtx.getLeftSiblingKey()) {
                    this.rtx.moveTo(this.stack.popLong());
                    this.rtx.moveTo(key);
                    this.wtx.moveToParent();
                }
                if (!this.stack.isEmpty()) {
                    this.rtx.moveTo(this.stack.popLong());
                    this.wtx.moveToParent();
                }
                this.rtx.moveTo(key);
            }
            long nodeKey = this.rtx.getNodeKey();
            InsertPosition insertPosition = isFirst ? this.insert : (moveToParent ? InsertPosition.AS_RIGHT_SIBLING : (this.rtx.hasLeftSibling() && previousKey == this.rtx.getLeftSiblingKey() ? InsertPosition.AS_RIGHT_SIBLING : InsertPosition.AS_FIRST_CHILD));
            moveToParent = false;
            if (isFirst || this.rtx.getParentKind() != NodeKind.OBJECT_KEY) {
                this.processNode(this.rtx, insertPosition);
            }
            this.rtx.moveTo(nodeKey);
            isFirst = false;
            boolean withChildren = false;
            if (!this.rtx.isDocumentRoot() && this.rtx.hasFirstChild()) {
                this.stack.push(this.rtx.getNodeKey());
                withChildren = true;
            }
            if (!(withChildren || this.rtx.isDocumentRoot() || this.rtx.hasRightSibling())) {
                moveToParent = true;
            }
            previousKey = key;
        }
        while (!this.stack.isEmpty() && this.stack.peekLong(0) != -15L) {
            this.rtx.moveTo(this.stack.popLong());
        }
    }

    public void processNode(JsonNodeReadOnlyTrx rtx, InsertPosition insertPosition) {
        switch (rtx.getKind()) {
            case JSON_DOCUMENT: {
                break;
            }
            case OBJECT: {
                if (insertPosition == InsertPosition.AS_FIRST_CHILD) {
                    this.wtx.insertObjectAsFirstChild();
                    break;
                }
                if (insertPosition == InsertPosition.AS_RIGHT_SIBLING) {
                    this.wtx.insertObjectAsRightSibling();
                    break;
                }
                if (insertPosition == InsertPosition.AS_LEFT_SIBLING) {
                    this.wtx.insertObjectAsLeftSibling();
                    break;
                }
                throw new IllegalStateException("Insert location not known!");
            }
            case ARRAY: {
                if (insertPosition == InsertPosition.AS_FIRST_CHILD) {
                    this.wtx.insertArrayAsFirstChild();
                    break;
                }
                if (insertPosition == InsertPosition.AS_RIGHT_SIBLING) {
                    this.wtx.insertArrayAsRightSibling();
                    break;
                }
                if (insertPosition == InsertPosition.AS_LEFT_SIBLING) {
                    this.wtx.insertArrayAsLeftSibling();
                    break;
                }
                throw new IllegalStateException("Insert location not known!");
            }
            case OBJECT_KEY: {
                if (insertPosition == InsertPosition.AS_FIRST_CHILD) {
                    String key = rtx.getName().getLocalName();
                    rtx.moveToFirstChild();
                    switch (rtx.getKind()) {
                        case OBJECT: {
                            this.wtx.insertObjectRecordAsFirstChild(key, new ObjectValue());
                            break;
                        }
                        case ARRAY: {
                            this.wtx.insertObjectRecordAsFirstChild(key, new ArrayValue());
                            break;
                        }
                        case OBJECT_BOOLEAN_VALUE: {
                            this.wtx.insertObjectRecordAsFirstChild(key, new BooleanValue(rtx.getBooleanValue()));
                            break;
                        }
                        case OBJECT_NULL_VALUE: {
                            this.wtx.insertObjectRecordAsFirstChild(key, new NullValue());
                            break;
                        }
                        case OBJECT_STRING_VALUE: {
                            this.wtx.insertObjectRecordAsFirstChild(key, new StringValue(rtx.getValue()));
                            break;
                        }
                        case OBJECT_NUMBER_VALUE: {
                            this.wtx.insertObjectRecordAsFirstChild(key, new NumberValue(rtx.getNumberValue()));
                        }
                    }
                    rtx.moveToParent();
                    break;
                }
                if (insertPosition == InsertPosition.AS_LEFT_SIBLING) {
                    String key = rtx.getName().getLocalName();
                    rtx.moveToFirstChild();
                    switch (rtx.getKind()) {
                        case OBJECT: {
                            this.wtx.insertObjectRecordAsLeftSibling(key, new ObjectValue());
                            break;
                        }
                        case ARRAY: {
                            this.wtx.insertObjectRecordAsLeftSibling(key, new ArrayValue());
                            break;
                        }
                        case OBJECT_BOOLEAN_VALUE: {
                            this.wtx.insertObjectRecordAsLeftSibling(key, new BooleanValue(rtx.getBooleanValue()));
                            break;
                        }
                        case OBJECT_NULL_VALUE: {
                            this.wtx.insertObjectRecordAsLeftSibling(key, new NullValue());
                            break;
                        }
                        case OBJECT_STRING_VALUE: {
                            this.wtx.insertObjectRecordAsLeftSibling(key, new StringValue(rtx.getValue()));
                            break;
                        }
                        case OBJECT_NUMBER_VALUE: {
                            this.wtx.insertObjectRecordAsLeftSibling(key, new NumberValue(rtx.getNumberValue()));
                        }
                    }
                    rtx.moveToParent();
                    break;
                }
                if (insertPosition == InsertPosition.AS_RIGHT_SIBLING) {
                    String key = rtx.getName().getLocalName();
                    rtx.moveToFirstChild();
                    switch (rtx.getKind()) {
                        case OBJECT: {
                            this.wtx.insertObjectRecordAsRightSibling(key, new ObjectValue());
                            break;
                        }
                        case ARRAY: {
                            this.wtx.insertObjectRecordAsRightSibling(key, new ArrayValue());
                            break;
                        }
                        case OBJECT_BOOLEAN_VALUE: {
                            this.wtx.insertObjectRecordAsRightSibling(key, new BooleanValue(rtx.getBooleanValue()));
                            break;
                        }
                        case OBJECT_NULL_VALUE: {
                            this.wtx.insertObjectRecordAsRightSibling(key, new NullValue());
                            break;
                        }
                        case OBJECT_STRING_VALUE: {
                            this.wtx.insertObjectRecordAsRightSibling(key, new StringValue(rtx.getValue()));
                            break;
                        }
                        case OBJECT_NUMBER_VALUE: {
                            this.wtx.insertObjectRecordAsRightSibling(key, new NumberValue(rtx.getNumberValue()));
                        }
                    }
                    rtx.moveToParent();
                    break;
                }
                throw new IllegalStateException("Insert location not known!");
            }
            case BOOLEAN_VALUE: {
                if (insertPosition == InsertPosition.AS_FIRST_CHILD) {
                    this.wtx.insertBooleanValueAsFirstChild(rtx.getBooleanValue());
                    break;
                }
                if (insertPosition == InsertPosition.AS_RIGHT_SIBLING) {
                    this.wtx.insertBooleanValueAsRightSibling(rtx.getBooleanValue());
                    break;
                }
                if (insertPosition == InsertPosition.AS_LEFT_SIBLING) {
                    this.wtx.insertBooleanValueAsLeftSibling(rtx.getBooleanValue());
                    break;
                }
                throw new IllegalStateException("Insert location not known!");
            }
            case NULL_VALUE: {
                if (insertPosition == InsertPosition.AS_FIRST_CHILD) {
                    this.wtx.insertNullValueAsFirstChild();
                    break;
                }
                if (insertPosition == InsertPosition.AS_RIGHT_SIBLING) {
                    this.wtx.insertNullValueAsRightSibling();
                    break;
                }
                if (insertPosition == InsertPosition.AS_LEFT_SIBLING) {
                    this.wtx.insertNullValueAsLeftSibling();
                    break;
                }
                throw new IllegalStateException("Insert location not known!");
            }
            case NUMBER_VALUE: {
                if (insertPosition == InsertPosition.AS_FIRST_CHILD) {
                    this.wtx.insertNumberValueAsFirstChild(rtx.getNumberValue());
                    break;
                }
                if (insertPosition == InsertPosition.AS_RIGHT_SIBLING) {
                    this.wtx.insertNumberValueAsRightSibling(rtx.getNumberValue());
                    break;
                }
                if (insertPosition == InsertPosition.AS_LEFT_SIBLING) {
                    this.wtx.insertNumberValueAsLeftSibling(rtx.getNumberValue());
                    break;
                }
                throw new IllegalStateException("Insert location not known!");
            }
            case STRING_VALUE: {
                if (insertPosition == InsertPosition.AS_FIRST_CHILD) {
                    this.wtx.insertStringValueAsFirstChild(rtx.getValue());
                    break;
                }
                if (insertPosition == InsertPosition.AS_RIGHT_SIBLING) {
                    this.wtx.insertStringValueAsRightSibling(rtx.getValue());
                    break;
                }
                if (insertPosition == InsertPosition.AS_LEFT_SIBLING) {
                    this.wtx.insertStringValueAsLeftSibling(rtx.getValue());
                    break;
                }
                throw new IllegalStateException("Insert location not known!");
            }
            default: {
                throw new IllegalStateException("Node kind not known!");
            }
        }
    }

    public static class Builder {
        private final JsonNodeTrx wtx;
        private final JsonNodeReadOnlyTrx rtx;
        private final InsertPosition insert;
        private ShredderCommit commit = ShredderCommit.NOCOMMIT;
        private boolean copyAllRevisionsUpToMostRecent;

        public Builder(JsonNodeTrx wtx, JsonNodeReadOnlyTrx rtx, InsertPosition insert) {
            this.wtx = Objects.requireNonNull(wtx);
            this.rtx = Objects.requireNonNull(rtx);
            this.insert = Objects.requireNonNull(insert);
        }

        public Builder commitAfterwards() {
            this.commit = ShredderCommit.COMMIT;
            return this;
        }

        public Builder copyAllRevisionsUpToMostRecent() {
            this.copyAllRevisionsUpToMostRecent = true;
            return this;
        }

        public JsonResourceCopy build() {
            return new JsonResourceCopy(this.wtx, this.rtx, this);
        }
    }
}

