/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.shredder;

import com.google.common.base.Preconditions;
import io.sirix.access.DatabaseConfiguration;
import io.sirix.access.Databases;
import io.sirix.access.ResourceConfiguration;
import io.sirix.api.Database;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.api.xml.XmlResourceSession;
import io.sirix.diff.algorithm.fmse.DefaultNodeComparisonFactory;
import io.sirix.diff.algorithm.fmse.FMSE;
import io.sirix.exception.SirixException;
import io.sirix.node.NodeKind;
import io.sirix.service.InsertPosition;
import io.sirix.service.xml.shredder.Import;
import io.sirix.service.xml.shredder.XmlShredder;
import io.sirix.service.xml.xpath.XPathAxis;
import io.sirix.utils.LogWrapper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.LoggerFactory;

public final class WikipediaImport
implements Import<StartElement> {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(WikipediaImport.class));
    private transient XMLEventReader mReader;
    private final XmlResourceSession mResourceManager;
    private transient XmlNodeTrx mWtx;
    private transient Deque<XMLEvent> mPageEvents = new ArrayDeque<XMLEvent>();
    private transient boolean mFound;
    private transient String mIdText;
    private transient boolean mIsRev;
    private transient String mTimestamp;
    private final Database<XmlResourceSession> mDatabase;

    public WikipediaImport(Path xmlFile, Path sirixDatabase) throws SirixException {
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        xmlif.setProperty("javax.xml.stream.supportDTD", false);
        try {
            this.mReader = xmlif.createXMLEventReader(new FileInputStream(Objects.requireNonNull(xmlFile.toFile())));
        }
        catch (FileNotFoundException | XMLStreamException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
        DatabaseConfiguration config = new DatabaseConfiguration(sirixDatabase);
        Databases.createXmlDatabase(config);
        this.mDatabase = Databases.openXmlDatabase(sirixDatabase);
        this.mDatabase.createResource(new ResourceConfiguration.Builder("shredded").build());
        this.mResourceManager = this.mDatabase.beginResourceSession("shredded");
        this.mWtx = (XmlNodeTrx)this.mResourceManager.beginNodeTrx();
    }

    @Override
    public void importData(DateBy dateRange, List<StartElement> data) {
        Objects.requireNonNull(dateRange);
        Objects.requireNonNull(data);
        Preconditions.checkArgument((data.size() == 5 ? 1 : 0) != 0, (Object)"data must have 5 elements!");
        StartElement timestamp = data.get(0);
        StartElement page = data.get(1);
        StartElement rev = data.get(2);
        StartElement id = data.get(3);
        this.mFound = false;
        this.mIsRev = false;
        boolean isFirst = true;
        try {
            while (this.mReader.hasNext()) {
                XMLEvent event = this.mReader.nextEvent();
                if (this.isWhitespace(event)) continue;
                this.mPageEvents.add(event);
                switch (event.getEventType()) {
                    case 1: {
                        if (WikipediaImport.checkStAXStartElement(event.asStartElement(), rev)) {
                            isFirst = false;
                            this.mIsRev = true;
                            break;
                        }
                        this.parseStartTag(event, timestamp, page, rev, id, dateRange);
                        break;
                    }
                    case 2: {
                        if (!event.asEndElement().getName().equals(page.getName()) || isFirst) break;
                        this.mIsRev = false;
                        if (this.mFound) {
                            try {
                                this.updateShredder();
                            }
                            catch (IOException e) {
                                LOGWRAPPER.error(e.getMessage(), e);
                            }
                            break;
                        }
                        this.mWtx.moveToDocumentRoot();
                        boolean hasFirstChild = this.mWtx.hasFirstChild();
                        if (hasFirstChild) {
                            this.moveToLastPage(page);
                            assert (this.mWtx.getName().getLocalName().equals(page.getName().getLocalPart()));
                        }
                        XmlShredder shredder = null;
                        shredder = hasFirstChild ? new XmlShredder.Builder(this.mWtx, XmlShredder.createQueueReader(this.mPageEvents), InsertPosition.AS_RIGHT_SIBLING).build() : new XmlShredder.Builder(this.mWtx, XmlShredder.createQueueReader(this.mPageEvents), InsertPosition.AS_FIRST_CHILD).build();
                        shredder.call();
                        this.mPageEvents = new ArrayDeque<XMLEvent>();
                        break;
                    }
                }
            }
            this.mWtx.commit();
            this.mWtx.close();
            this.mResourceManager.close();
            this.mDatabase.close();
        }
        catch (SirixException | IOException | XMLStreamException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    private void updateShredder() throws SirixException, IOException, XMLStreamException {
        Path path = Files.createTempDirectory("sdbtmp", new FileAttribute[0]);
        DatabaseConfiguration dbConf = new DatabaseConfiguration(path);
        Databases.createXmlDatabase(dbConf);
        try (Database<XmlResourceSession> db = Databases.openXmlDatabase(path);){
            db.createResource(new ResourceConfiguration.Builder("wiki").build());
            try (XmlResourceSession resourceManager = db.beginResourceSession("wiki");){
                if (this.mPageEvents.peek() != null && this.mPageEvents.peek().isStartElement() && !this.mPageEvents.peek().asStartElement().getName().getLocalPart().equals("root")) {
                    this.mPageEvents.addFirst(XMLEventFactory.newInstance().createStartElement(new QName("root"), null, null));
                    this.mPageEvents.addLast(XMLEventFactory.newInstance().createEndElement(new QName("root"), null));
                }
                XmlNodeTrx wtx = (XmlNodeTrx)resourceManager.beginNodeTrx();
                XmlShredder shredder = new XmlShredder.Builder(wtx, XmlShredder.createQueueReader(this.mPageEvents), InsertPosition.AS_FIRST_CHILD).commitAfterwards().build();
                shredder.call();
                wtx.close();
                this.mPageEvents = new ArrayDeque<XMLEvent>();
                XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)resourceManager.beginNodeReadOnlyTrx();
                rtx.moveToFirstChild();
                rtx.moveToFirstChild();
                long nodeKey = this.mWtx.getNodeKey();
                try (FMSE fmse = FMSE.createInstance(new DefaultNodeComparisonFactory());){
                    fmse.diff(this.mWtx, rtx);
                }
                this.mWtx.moveTo(nodeKey);
                rtx.close();
            }
        }
        Databases.removeDatabase(path);
    }

    private void parseStartTag(XMLEvent startTagEvent, StartElement timestamp, StartElement wikiPage, StartElement revision, StartElement pageID, DateBy dateRange) throws XMLStreamException, SirixException {
        XMLEvent event = startTagEvent;
        if (WikipediaImport.checkStAXStartElement(event.asStartElement(), pageID)) {
            event = this.mReader.nextEvent();
            this.mPageEvents.add(event);
            if (!this.mIsRev) {
                this.mIdText = event.asCharacters().getData();
            }
        } else if (WikipediaImport.checkStAXStartElement(event.asStartElement(), timestamp)) {
            event = this.mReader.nextEvent();
            this.mPageEvents.add(event);
            String currTimestamp = event.asCharacters().getData();
            if (this.mTimestamp == null) {
                this.mTimestamp = this.parseTimestamp(dateRange, currTimestamp);
            } else if (!this.parseTimestamp(dateRange, currTimestamp).equals(this.mTimestamp)) {
                this.mTimestamp = this.parseTimestamp(dateRange, currTimestamp);
                this.mWtx.commit();
                this.mWtx.close();
                this.mWtx = (XmlNodeTrx)this.mResourceManager.beginNodeTrx();
            }
            assert (this.mIdText != null);
            QName page = wikiPage.getName();
            QName id = pageID.getName();
            String query = "//" + WikipediaImport.qNameToString(page) + "[fn:string(" + WikipediaImport.qNameToString(id) + ") = '" + this.mIdText + "']";
            this.mWtx.moveToDocumentRoot();
            XPathAxis axis = new XPathAxis(this.mWtx, query);
            this.mFound = false;
            int resCounter = 0;
            long key = this.mWtx.getNodeKey();
            while (axis.hasNext()) {
                axis.next();
                this.mFound = true;
                assert (++resCounter == 1);
                assert (this.mWtx.getName().getLocalName().equals(wikiPage.getName().getLocalPart()));
                key = this.mWtx.getNodeKey();
            }
            this.mWtx.moveTo(key);
        }
    }

    private String parseTimestamp(DateBy dateRange, String timestamp) {
        StringBuilder sb = new StringBuilder();
        switch (dateRange.ordinal()) {
            case 0: {
                sb.append(timestamp);
                break;
            }
            case 2: {
                String[] splittedHour = timestamp.split(":");
                sb.append(splittedHour[0]);
                sb.append(":");
                sb.append(splittedHour[1]);
                break;
            }
            case 3: {
                String[] splittedDay = timestamp.split("T");
                sb.append(splittedDay[0]);
                break;
            }
            case 1: {
                throw new UnsupportedOperationException("Not supported right now!");
            }
            case 4: {
                String[] splittedMonth = timestamp.split("-");
                sb.append(splittedMonth[0]);
                sb.append("-");
                sb.append(splittedMonth[1]);
                break;
            }
            default: {
                throw new IllegalStateException("Date range not known!");
            }
        }
        return sb.toString();
    }

    private boolean isWhitespace(XMLEvent event) {
        return event.isCharacters() && event.asCharacters().isWhiteSpace();
    }

    private static String qNameToString(QName name) {
        StringBuilder retVal = new StringBuilder();
        if ("".equals(name.getPrefix())) {
            retVal.append(name.getLocalPart());
        } else {
            retVal.append(name.getPrefix()).append(":").append(name.getLocalPart());
        }
        return retVal.toString();
    }

    private void moveToLastPage(StartElement page) {
        assert (page != null);
        this.mWtx.moveToFirstChild();
        this.mWtx.moveToFirstChild();
        assert (this.mWtx.getKind() == NodeKind.ELEMENT);
        assert (this.mWtx.getName().getLocalName().equals(page.getName().getLocalPart()));
        while (this.mWtx.hasRightSibling()) {
            this.mWtx.moveToRightSibling();
        }
        assert (this.mWtx.getKind() == NodeKind.ELEMENT);
        assert (this.mWtx.getName().getLocalName().equals(page.getName().getLocalPart()));
    }

    private static boolean checkStAXStartElement(StartElement startTag, StartElement elem) throws XMLStreamException {
        assert (startTag != null && elem != null);
        boolean retVal = false;
        if (startTag.getEventType() == 1 && startTag.getName().equals(elem.getName())) {
            boolean foundAtts = false;
            boolean hasAtts = false;
            Iterator<Attribute> itStartTag = startTag.getAttributes();
            while (itStartTag.hasNext()) {
                hasAtts = true;
                Attribute attStartTag = itStartTag.next();
                Iterator<Attribute> itElem = elem.getAttributes();
                while (itElem.hasNext()) {
                    Attribute attElem = itElem.next();
                    if (!attStartTag.getName().equals(attElem.getName())) continue;
                    foundAtts = true;
                    break;
                }
                if (foundAtts) continue;
                break;
            }
            if (!hasAtts) {
                foundAtts = true;
            }
            boolean foundNamesps = false;
            boolean hasNamesps = false;
            Iterator<Namespace> itStartTag2 = startTag.getNamespaces();
            while (itStartTag2.hasNext()) {
                hasNamesps = true;
                Namespace nsStartTag = itStartTag2.next();
                Iterator<Namespace> itElem = elem.getNamespaces();
                while (itElem.hasNext()) {
                    Namespace nsElem = itElem.next();
                    if (!nsStartTag.getName().equals(nsElem.getName())) continue;
                    foundNamesps = true;
                    break;
                }
                if (foundNamesps) continue;
                break;
            }
            if (!hasNamesps) {
                foundNamesps = true;
            }
            retVal = foundAtts && foundNamesps;
        }
        return retVal;
    }

    public static void main(String[] args) throws SirixException {
        if (args.length != 2) {
            throw new IllegalArgumentException("Usage: WikipediaImport path/to/xmlFile path/to/SirixStorage");
        }
        LOGWRAPPER.info("Importing wikipedia...", new Object[0]);
        long start = System.nanoTime();
        Path xml = Paths.get(args[0], new String[0]);
        Path resource = Paths.get(args[1], new String[0]);
        Databases.removeDatabase(resource);
        String NSP_URI = "http://www.mediawiki.org/xml/export-0.5/";
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        StartElement timestamp = eventFactory.createStartElement(new QName("http://www.mediawiki.org/xml/export-0.5/", "timestamp", ""), null, null);
        StartElement page = eventFactory.createStartElement(new QName("http://www.mediawiki.org/xml/export-0.5/", "page", ""), null, null);
        StartElement rev = eventFactory.createStartElement(new QName("http://www.mediawiki.org/xml/export-0.5/", "revision", ""), null, null);
        StartElement id = eventFactory.createStartElement(new QName("http://www.mediawiki.org/xml/export-0.5/", "id", ""), null, null);
        StartElement text = eventFactory.createStartElement(new QName("http://www.mediawiki.org/xml/export-0.5/", "text", ""), null, null);
        List<StartElement> list = List.of(timestamp, page, rev, id, text);
        new WikipediaImport(xml, resource).importData(DateBy.HOURS, list);
        LOGWRAPPER.info(" done in " + (System.nanoTime() - start) / 1000000000L + "[s].", new Object[0]);
    }

    public static enum DateBy {
        SECONDS,
        MINUTES,
        HOURS,
        DAYS,
        MONTHS;

    }
}

