/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath;

import io.sirix.api.Axis;
import io.sirix.axis.AncestorAxis;
import io.sirix.axis.ChildAxis;
import io.sirix.axis.DescendantAxis;
import io.sirix.axis.FollowingAxis;
import io.sirix.axis.FollowingSiblingAxis;
import io.sirix.axis.NestedAxis;
import io.sirix.axis.ParentAxis;
import io.sirix.axis.PrecedingAxis;
import io.sirix.axis.PrecedingSiblingAxis;
import io.sirix.axis.filter.FilterAxis;
import io.sirix.service.xml.xpath.DupState;
import io.sirix.service.xml.xpath.OrdState;
import io.sirix.service.xml.xpath.expr.UnionAxis;
import io.sirix.service.xml.xpath.filter.DupFilterAxis;

public class ExpressionSingle {
    private int mNumber = 0;
    private Axis mFirstAxis;
    private Axis mExpr;
    private OrdState mOrd = OrdState.MAX1;
    private DupState mDup;

    public ExpressionSingle() {
        this.mOrd.init();
        this.mDup = DupState.MAX1;
    }

    public void add(Axis pAx) {
        Axis axis = pAx;
        if (this.isDupOrd(axis)) {
            axis = new DupFilterAxis(axis.asXmlNodeReadTrx(), axis);
            DupState.nodup = true;
        }
        switch (this.mNumber) {
            case 0: {
                this.mFirstAxis = axis;
                ++this.mNumber;
                break;
            }
            case 1: {
                this.mExpr = new NestedAxis(this.mFirstAxis, axis);
                ++this.mNumber;
                break;
            }
            default: {
                Axis cache = this.mExpr;
                this.mExpr = new NestedAxis(cache, axis);
            }
        }
    }

    public Axis getExpr() {
        return this.mNumber == 1 ? this.mFirstAxis : this.mExpr;
    }

    public int getSize() {
        return this.mNumber;
    }

    public boolean isDupOrd(Axis ax) {
        Axis axis = ax;
        while (axis instanceof FilterAxis) {
            axis = ((FilterAxis)axis).getAxis();
        }
        if (axis instanceof UnionAxis) {
            this.mOrd = this.mOrd.updateOrdUnion();
            this.mDup = this.mDup.updateUnion();
        } else if (axis instanceof ChildAxis) {
            this.mOrd = this.mOrd.updateOrdChild();
            this.mDup = this.mDup.updateDupChild();
        } else if (axis instanceof ParentAxis) {
            this.mOrd = this.mOrd.updateOrdParent();
            this.mDup = this.mDup.updateDupParent();
        } else if (axis instanceof DescendantAxis) {
            this.mOrd = this.mOrd.updateOrdDesc();
            this.mDup = this.mDup.updateDupDesc();
        } else if (axis instanceof AncestorAxis) {
            this.mOrd = this.mOrd.updateOrdAncestor();
            this.mDup = this.mDup.updateDupAncestor();
        } else if (axis instanceof FollowingAxis || axis instanceof PrecedingAxis) {
            this.mOrd = this.mOrd.updateOrdFollPre();
            this.mDup = this.mDup.updateDupFollPre();
        } else if (axis instanceof FollowingSiblingAxis || axis instanceof PrecedingSiblingAxis) {
            this.mOrd = this.mOrd.updateOrdFollPreSib();
            this.mDup = this.mDup.updateDupFollPreSib();
        }
        return !DupState.nodup;
    }

    public boolean isOrdered() {
        return this.mOrd != OrdState.UNORD && OrdState.mOrdRank == 0;
    }
}

